/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.azuredevops;

import jakarta.inject.Named;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.squashtest.csp.core.bugtracker.core.NamespacedBugtrackerMessageSource;
import org.squashtest.tm.api.config.SquashPathProperties;
import org.squashtest.tm.plugin.bugtracker.azuredevops.licensevalidator.LicenseValidator;
import org.squashtest.tm.plugin.bugtracker.azuredevops.licensevalidator.service.ValidationService;
import org.squashtest.tm.plugin.bugtracker.azuredevops.licensevalidator.service.impl.ValidationServiceImpl;

@Configuration
@ComponentScan
public class AzureDevOpsBugtrackerConnectorConfig {
    private final SquashPathProperties squashPathProperties;

    public AzureDevOpsBugtrackerConnectorConfig(SquashPathProperties squashPathProperties) {
        this.squashPathProperties = squashPathProperties;
    }

    @Bean
    public MessageSource azureDevOpsConnectorMessageSource() {
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
        messageSource.setCacheSeconds(60);
        messageSource.setBasenames(new String[]{"classpath:/org/squashtest/tm/plugin/bugtracker/azuredevops/messages"});
        return new NamespacedBugtrackerMessageSource((MessageSource)messageSource, "bugtracker.azuredevops.");
    }

    @Bean(name={"org.squashtest.tm.plugin.bugtracker.azuredevops.ValidationService"})
    public ValidationService validationService() {
        return new ValidationServiceImpl();
    }

    @Bean(name={"org.squashtest.tm.plugin.bugtracker.azuredevops.LicenseValidator"})
    public LicenseValidator licenseValidator(@Named(value="org.squashtest.tm.plugin.bugtracker.azuredevops.ValidationService") ValidationService service) {
        return new LicenseValidator(service);
    }
}

