/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.service.impl;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.bugtracker.BugtrackerProject;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.exception.NoBugTrackerBindingException;
import org.squashtest.tm.plugin.rest.admin.jackson.model.BugTrackerDto;
import org.squashtest.tm.plugin.rest.admin.jackson.model.BugTrackerProjectDto;
import org.squashtest.tm.plugin.rest.admin.service.RestBugTrackerService;
import org.squashtest.tm.plugin.rest.admin.service.patcher.BugTrackerPatcher;
import org.squashtest.tm.service.internal.repository.BugTrackerDao;
import org.squashtest.tm.service.internal.repository.GenericProjectDao;

@Service
@Transactional
public class RestBugTrackerServiceImpl
implements RestBugTrackerService {
    @Inject
    private BugTrackerDao bugTrackerDao;
    @Inject
    private GenericProjectDao projectDao;
    @Inject
    private BugTrackerPatcher bugTrackerPatcher;

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public BugTracker createBugTracker(BugTracker bt) {
        BugTracker existing = this.bugTrackerDao.findByName(bt.getName());
        if (existing != null) {
            throw new NameAlreadyInUseException(NameAlreadyInUseException.EntityType.BUG_TRACKER, bt.getName());
        }
        BugTracker saveBugTracker = (BugTracker)this.bugTrackerDao.saveAndFlush((Object)bt);
        return saveBugTracker;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public BugTracker updateBugTracker(Long id, BugTrackerDto bt) {
        BugTracker bugTrackerToUpdate = (BugTracker)this.bugTrackerDao.getReferenceById((Object)id);
        this.bugTrackerPatcher.patch(bugTrackerToUpdate, bt);
        return bugTrackerToUpdate;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public BugTracker findById(Long bugTrackerId) {
        return (BugTracker)this.bugTrackerDao.getReferenceById((Object)bugTrackerId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public BugTracker getBugTrackerByProjectId(Long projectId) {
        GenericProject project = (GenericProject)this.projectDao.getReferenceById((Object)projectId);
        if (project.isBoundToBugtracker()) {
            return project.getBugTracker();
        }
        throw new NoBugTrackerBindingException();
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void setBugTrackerProjectOnSquashProject(BugTrackerProjectDto bugTrackerProjectDto, Long projectId) {
        GenericProject project = this.projectDao.getProjectWithBugtrackerProjects(projectId.longValue());
        List<String> addedProjectNamesList = bugTrackerProjectDto.getBugtrackerPojectList();
        if (project.isBoundToBugtracker()) {
            List currentProjectNamesList = project.getBugtrackerProjectNames();
            ArrayList<BugtrackerProject> newBugtrackerProjects = new ArrayList<BugtrackerProject>();
            for (String projectName : addedProjectNamesList) {
                if (currentProjectNamesList.contains(projectName)) continue;
                newBugtrackerProjects.add(new BugtrackerProject(projectName, project));
            }
            if (!newBugtrackerProjects.isEmpty()) {
                project.addBugtrackerProjects(newBugtrackerProjects);
            }
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public List<String> getBugTrackerProjectOfSquashProject(Long projectId) {
        GenericProject project = this.projectDao.getProjectWithBugtrackerProjects(projectId.longValue());
        List<String> projectNamesList = new ArrayList<String>();
        if (project.isBoundToBugtracker()) {
            projectNamesList = project.getBugtrackerProjectNames();
        }
        return projectNamesList;
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void deleteBugTrackerProjectOnSquashProject(BugTrackerProjectDto bugTrackerProjectDto, Long projectId) {
        GenericProject project = this.projectDao.getProjectWithBugtrackerProjects(projectId.longValue());
        List<String> deletedProjectNamesList = bugTrackerProjectDto.getBugtrackerPojectList();
        if (project.isBoundToBugtracker() && project.getBugtrackerProjectNames().size() > 1) {
            project.getBugtrackerProjects().removeIf(bp -> deletedProjectNamesList.contains(bp.getBugtrackerProjectName()));
        }
    }
}

