/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.controller;

import jakarta.inject.Inject;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.requirement.RequirementVersionLinkType;
import org.squashtest.tm.plugin.rest.admin.jackson.model.RequirementVersionLinkTypeDto;
import org.squashtest.tm.plugin.rest.admin.service.RestLinkTypeService;
import org.squashtest.tm.plugin.rest.admin.validators.RequirementVersionLinkTypeValidator;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;

@RestApiController(value=RequirementVersionLinkType.class)
@UseDefaultRestApiConfiguration
public class RestLinkTypeController
extends BaseRestController {
    @Inject
    private RestLinkTypeService restLinkTypeService;
    @Inject
    private RequirementVersionLinkTypeValidator linkTypeValidator;

    @GetMapping(value={"/requirement-link-types"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<PagedModel<EntityModel<RequirementVersionLinkType>>> findAllLinkTypes(Pageable pageable) {
        Page<RequirementVersionLinkType> pagedLinkTypes = this.restLinkTypeService.findAllLinkTypes(pageable);
        PagedModel res = this.toPagedModel(pagedLinkTypes);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/requirement-link-types/{id}"})
    @ResponseBody
    @EntityGetter
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<RequirementVersionLinkType>> findLinkTypeById(@PathVariable(value="id") Long linkTypeId) {
        RequirementVersionLinkType linkType = this.restLinkTypeService.findLinkTypeById(linkTypeId);
        EntityModel res = this.toEntityModel((Identified)linkType);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/requirement-link-types"}, params={"codeRole"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<EntityModel<RequirementVersionLinkType>> findLinkTypeByCode(@RequestParam(value="codeRole") String codeRole) {
        RequirementVersionLinkType linkType = this.restLinkTypeService.findLinkTypeByCodeRole(codeRole);
        EntityModel res = this.toEntityModel((Identified)linkType);
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/requirement-link-types"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<EntityModel<RequirementVersionLinkType>> addLinkType(@RequestBody RequirementVersionLinkTypeDto linkTypeDto) throws BindException {
        this.linkTypeValidator.linkTypePostValidator(linkTypeDto);
        RequirementVersionLinkType linkType = this.restLinkTypeService.addLinkType(linkTypeDto);
        EntityModel res = this.toEntityModel((Identified)linkType);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)res);
    }

    @PatchMapping(value={"/requirement-link-types/{id}"})
    @ResponseBody
    @DynamicFilterExpression
    public ResponseEntity<EntityModel<RequirementVersionLinkType>> patchMilestone(@PathVariable(value="id") Long linkTypeId, @RequestBody RequirementVersionLinkTypeDto linkTypeDto) throws BindException {
        this.linkTypeValidator.linkTypePatchValidator(linkTypeId, linkTypeDto);
        RequirementVersionLinkType linkType = this.restLinkTypeService.updateLinkType(linkTypeId, linkTypeDto);
        EntityModel res = this.toEntityModel((Identified)linkType);
        return ResponseEntity.ok((Object)res);
    }

    @ResponseBody
    @DeleteMapping(value={"/requirement-link-types/{ids}"})
    public ResponseEntity<Void> removeLinkType(@PathVariable(value="ids") List<Long> linkTypeIds) {
        this.restLinkTypeService.deleteLinkType(linkTypeIds);
        return ResponseEntity.noContent().build();
    }
}

