/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.http.impl.io;

import java.io.IOException;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.Header;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.HeaderIterator;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.HttpException;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.HttpMessage;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.io.HttpMessageWriter;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.io.SessionOutputBuffer;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.message.BasicLineFormatter;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.message.LineFormatter;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.params.HttpParams;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.util.Args;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.util.CharArrayBuffer;

public abstract class AbstractMessageWriter<T extends HttpMessage>
implements HttpMessageWriter<T> {
    protected final SessionOutputBuffer sessionBuffer;
    protected final CharArrayBuffer lineBuf;
    protected final LineFormatter lineFormatter;

    @Deprecated
    public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter, HttpParams params) {
        Args.notNull(buffer, "Session input buffer");
        this.sessionBuffer = buffer;
        this.lineBuf = new CharArrayBuffer(128);
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.INSTANCE;
    }

    public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter) {
        this.sessionBuffer = Args.notNull(buffer, "Session input buffer");
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    protected abstract void writeHeadLine(T var1) throws IOException;

    @Override
    public void write(T message) throws IOException, HttpException {
        Args.notNull(message, "HTTP message");
        this.writeHeadLine(message);
        HeaderIterator it = message.headerIterator();
        while (it.hasNext()) {
            Header header = it.nextHeader();
            this.sessionBuffer.writeLine(this.lineFormatter.formatHeader(this.lineBuf, header));
        }
        this.lineBuf.clear();
        this.sessionBuffer.writeLine(this.lineBuf);
    }
}

