/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.http.impl.cookie;

import org.squashtest.tm.plugin.bugtracker.redmine3.http.annotation.Contract;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.annotation.ThreadingBehavior;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.cookie.CommonCookieAttributeHandler;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.cookie.Cookie;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.cookie.CookieOrigin;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.cookie.CookieRestrictionViolationException;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.cookie.MalformedCookieException;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.cookie.SetCookie;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.impl.cookie.AbstractCookieAttributeHandler;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RFC2109VersionHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        if (value.trim().isEmpty()) {
            throw new MalformedCookieException("Blank value for version attribute");
        }
        try {
            cookie.setVersion(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid version: " + e.getMessage());
        }
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie.getVersion() < 0) {
            throw new CookieRestrictionViolationException("Cookie version may not be negative");
        }
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

