/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.glassfish.jersey.media.multipart.internal;

import gitlabbt.org.glassfish.jersey.internal.inject.ExtractorException;
import gitlabbt.org.glassfish.jersey.internal.util.ReflectionHelper;
import gitlabbt.org.glassfish.jersey.internal.util.collection.MultivaluedStringMap;
import gitlabbt.org.glassfish.jersey.media.multipart.BodyPartEntity;
import gitlabbt.org.glassfish.jersey.media.multipart.FormDataBodyPart;
import gitlabbt.org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import gitlabbt.org.glassfish.jersey.media.multipart.FormDataMultiPart;
import gitlabbt.org.glassfish.jersey.media.multipart.FormDataParam;
import gitlabbt.org.glassfish.jersey.media.multipart.FormDataParamException;
import gitlabbt.org.glassfish.jersey.media.multipart.internal.LocalizationMessages;
import gitlabbt.org.glassfish.jersey.message.MessageBodyWorkers;
import gitlabbt.org.glassfish.jersey.message.MessageUtils;
import gitlabbt.org.glassfish.jersey.message.internal.Utils;
import gitlabbt.org.glassfish.jersey.model.Parameter;
import gitlabbt.org.glassfish.jersey.server.ContainerRequest;
import gitlabbt.org.glassfish.jersey.server.internal.inject.AbstractValueParamProvider;
import gitlabbt.org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractor;
import gitlabbt.org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import gitlabbt.org.glassfish.jersey.server.model.Parameter;
import gitlabbt.org.glassfish.jersey.server.spi.internal.ValueParamProvider;
import gitlabbt.org.jvnet.mimepull.MIMEParsingException;
import jakarta.inject.Provider;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.core.EntityPart;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

final class FormDataParamValueParamProvider
extends AbstractValueParamProvider {
    private static final Logger LOGGER = Logger.getLogger(FormDataParamValueParamProvider.class.getName());
    private static final Set<Class<?>> TYPES = FormDataParamValueParamProvider.initializeTypes();

    private static Set<Class<?>> initializeTypes() {
        HashSet<Class<Serializable>> newSet = new HashSet<Class<Serializable>>();
        newSet.add(Byte.class);
        newSet.add(Byte.TYPE);
        newSet.add(Short.class);
        newSet.add(Short.TYPE);
        newSet.add(Integer.class);
        newSet.add(Integer.TYPE);
        newSet.add(Long.class);
        newSet.add(Long.TYPE);
        newSet.add(Float.class);
        newSet.add(Float.TYPE);
        newSet.add(Double.class);
        newSet.add(Double.TYPE);
        newSet.add(Boolean.class);
        newSet.add(Boolean.TYPE);
        newSet.add(Character.class);
        newSet.add(Character.TYPE);
        return Collections.unmodifiableSet(newSet);
    }

    private static boolean isPrimitiveType(Class<?> type) {
        return TYPES.contains(type);
    }

    public FormDataParamValueParamProvider(Provider<MultivaluedParameterExtractorProvider> extractorProvider) {
        super(extractorProvider, new Parameter.Source[]{Parameter.Source.ENTITY, Parameter.Source.FORM, Parameter.Source.UNKNOWN});
    }

    protected Function<ContainerRequest, ?> createValueProvider(Parameter parameter) {
        Class rawType = parameter.getRawType();
        if (Parameter.Source.ENTITY == parameter.getSource()) {
            if (FormDataMultiPart.class.isAssignableFrom(rawType)) {
                return new FormDataMultiPartProvider();
            }
            return null;
        }
        for (Annotation sourceAnnotation : parameter.getAnnotations()) {
            Class<?> clazz;
            String paramName;
            if (sourceAnnotation.annotationType() == FormDataParam.class) {
                paramName = ((FormDataParam)sourceAnnotation).value();
                if (paramName == null || paramName.isEmpty()) {
                    return null;
                }
                if (Collection.class == rawType || List.class == rawType) {
                    clazz = ReflectionHelper.getGenericTypeArgumentClasses(parameter.getType()).get(0);
                    if (FormDataBodyPart.class == clazz) {
                        return new ListFormDataBodyPartValueProvider(paramName);
                    }
                    if (FormDataContentDisposition.class == clazz) {
                        return new ListFormDataContentDispositionProvider(paramName);
                    }
                    return new FormDataParamValueProvider(parameter, this.get(parameter));
                }
                if (FormDataBodyPart.class == rawType) {
                    return new FormDataBodyPartProvider(paramName);
                }
                if (FormDataContentDisposition.class == rawType) {
                    return new FormDataContentDispositionProvider(paramName);
                }
                if (File.class == rawType) {
                    return new FileProvider(paramName);
                }
                return new FormDataParamValueProvider(parameter, this.get(parameter));
            }
            if (!FormParam.class.equals(sourceAnnotation.annotationType())) continue;
            paramName = ((FormParam)sourceAnnotation).value();
            if (Collection.class == rawType || List.class == rawType) {
                clazz = ReflectionHelper.getGenericTypeArgumentClasses(parameter.getType()).get(0);
                if (!EntityPart.class.equals(clazz)) continue;
                return new ListEntityPartValueProvider(paramName);
            }
            if (!EntityPart.class.equals((Object)rawType)) continue;
            return new EntityPartValueProvider(paramName);
        }
        return null;
    }

    public ValueParamProvider.PriorityType getPriority() {
        return ValueParamProvider.Priority.HIGH;
    }

    private final class EntityPartValueProvider
    extends ValueProvider<EntityPart> {
        private final String name;

        public EntityPartValueProvider(String name) {
            this.name = name;
        }

        @Override
        public EntityPart apply(ContainerRequest request) {
            List<FormDataBodyPart> bodyParts = this.getEntity(request).getFields(this.name);
            return bodyParts.size() != 0 ? (EntityPart)bodyParts.get(0) : null;
        }
    }

    private final class ListEntityPartValueProvider
    extends ValueProvider<List<EntityPart>> {
        private final String name;

        public ListEntityPartValueProvider(String name) {
            this.name = name;
        }

        @Override
        public List<EntityPart> apply(ContainerRequest request) {
            return this.getEntity(request).getFields(this.name);
        }
    }

    private final class FormDataParamValueProvider
    extends ValueProvider<Object> {
        private final MultivaluedParameterExtractor<?> extractor;
        private final Parameter parameter;

        public FormDataParamValueProvider(Parameter parameter, MultivaluedParameterExtractor<?> extractor) {
            this.parameter = parameter;
            this.extractor = extractor;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object apply(ContainerRequest request) {
            String sourceName = this.parameter.getAnnotations().length == 1 ? this.parameter.getSourceName() : Arrays.stream(this.parameter.getAnnotations()).filter(ann -> FormDataParam.class.isInstance(ann)).map(ann -> (FormDataParam)FormDataParam.class.cast(ann)).findFirst().get().value();
            List<FormDataBodyPart> parts = this.getEntity(request).getFields(sourceName);
            FormDataBodyPart part = parts != null ? parts.get(0) : null;
            MediaType mediaType = part != null ? part.getMediaType() : MediaType.TEXT_PLAIN_TYPE;
            MessageBodyWorkers messageBodyWorkers = request.getWorkers();
            MessageBodyReader messageBodyReader = messageBodyWorkers.getMessageBodyReader(this.parameter.getRawType(), this.parameter.getType(), this.parameter.getAnnotations(), mediaType);
            if (messageBodyReader != null && !FormDataParamValueParamProvider.isPrimitiveType(this.parameter.getRawType())) {
                InputStream stream;
                if (part == null) {
                    if (this.parameter.getDefaultValue() == null) return null;
                    stream = new ByteArrayInputStream(this.parameter.getDefaultValue().getBytes(MessageUtils.getCharset(mediaType)));
                } else {
                    stream = part.getEntityAs(BodyPartEntity.class).getInputStream();
                }
                try {
                    return messageBodyReader.readFrom(this.parameter.getRawType(), this.parameter.getType(), this.parameter.getAnnotations(), mediaType, request.getHeaders(), stream);
                }
                catch (IOException e) {
                    throw new FormDataParamException(e, this.parameter.getSourceName(), this.parameter.getDefaultValue());
                }
            }
            if (this.extractor == null) return null;
            MultivaluedStringMap map = new MultivaluedStringMap();
            try {
                if (part == null) return this.extractor.extract((MultivaluedMap)map);
                for (FormDataBodyPart p : parts) {
                    MessageBodyReader<String> messageBodyReader2 = messageBodyWorkers.getMessageBodyReader(String.class, (Type)((Object)String.class), this.parameter.getAnnotations(), p.getMediaType());
                    String value = messageBodyReader2.readFrom(String.class, (Type)((Object)String.class), this.parameter.getAnnotations(), mediaType, request.getHeaders(), ((BodyPartEntity)p.getEntity()).getInputStream());
                    map.add(this.parameter.getSourceName(), value);
                }
                return this.extractor.extract((MultivaluedMap)map);
            }
            catch (ExtractorException | IOException ex) {
                throw new FormDataParamException(ex, this.extractor.getName(), this.extractor.getDefaultValueString());
            }
        }
    }

    private final class FileProvider
    extends ValueProvider<File> {
        private final String name;

        public FileProvider(String name) {
            this.name = name;
        }

        @Override
        public File apply(ContainerRequest request) {
            BodyPartEntity entity;
            FormDataBodyPart part = this.getEntity(request).getField(this.name);
            BodyPartEntity bodyPartEntity = entity = part != null ? part.getEntityAs(BodyPartEntity.class) : null;
            if (entity != null) {
                try {
                    File file = Utils.createTempFile();
                    entity.moveTo(file);
                    return file;
                }
                catch (MIMEParsingException | IOException cannotMove) {
                    LOGGER.log(Level.WARNING, LocalizationMessages.CANNOT_INJECT_FILE(), cannotMove);
                }
            }
            return null;
        }
    }

    private final class FormDataContentDispositionProvider
    extends ValueProvider<FormDataContentDisposition> {
        private final String name;

        public FormDataContentDispositionProvider(String name) {
            this.name = name;
        }

        @Override
        public FormDataContentDisposition apply(ContainerRequest request) {
            FormDataBodyPart part = this.getEntity(request).getField(this.name);
            return part == null ? null : part.getFormDataContentDisposition();
        }
    }

    private final class FormDataBodyPartProvider
    extends ValueProvider<FormDataBodyPart> {
        private final String name;

        public FormDataBodyPartProvider(String name) {
            this.name = name;
        }

        @Override
        public FormDataBodyPart apply(ContainerRequest request) {
            return this.getEntity(request).getField(this.name);
        }
    }

    private final class ListFormDataContentDispositionProvider
    extends ValueProvider<List<FormDataContentDisposition>> {
        private final String name;

        public ListFormDataContentDispositionProvider(String name) {
            this.name = name;
        }

        @Override
        public List<FormDataContentDisposition> apply(ContainerRequest request) {
            List<FormDataBodyPart> parts = this.getEntity(request).getFields(this.name);
            return parts == null ? null : parts.stream().map(FormDataBodyPart::getFormDataContentDisposition).collect(Collectors.toList());
        }
    }

    private final class ListFormDataBodyPartValueProvider
    extends ValueProvider<List<FormDataBodyPart>> {
        private final String name;

        public ListFormDataBodyPartValueProvider(String name) {
            this.name = name;
        }

        @Override
        public List<FormDataBodyPart> apply(ContainerRequest request) {
            return this.getEntity(request).getFields(this.name);
        }
    }

    private final class FormDataMultiPartProvider
    extends ValueProvider<FormDataMultiPart> {
        private FormDataMultiPartProvider() {
        }

        @Override
        public FormDataMultiPart apply(ContainerRequest request) {
            return this.getEntity(request);
        }
    }

    private abstract class ValueProvider<T>
    implements Function<ContainerRequest, T> {
        private ValueProvider() {
        }

        FormDataMultiPart getEntity(ContainerRequest request) {
            String requestPropertyName = FormDataMultiPart.class.getName();
            Object entity = request.getProperty(requestPropertyName);
            if (entity == null) {
                entity = request.readEntity(FormDataMultiPart.class);
                if (entity == null) {
                    throw new BadRequestException(LocalizationMessages.ENTITY_IS_EMPTY());
                }
                request.setProperty(requestPropertyName, entity);
            }
            return (FormDataMultiPart)entity;
        }
    }
}

