/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import jakarta.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.domain.requirement.RequirementLibraryNode;
import org.squashtest.tm.domain.resource.Resource;
import org.squashtest.tm.plugin.rest.controller.helper.ResourceLinksHelper;
import org.squashtest.tm.plugin.rest.core.hateoas.SingleRelPagedResources;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.ContentInclusion;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.FolderTreeDto;
import org.squashtest.tm.plugin.rest.jackson.model.ParentFolderTreeDto;
import org.squashtest.tm.plugin.rest.jackson.model.ProjectTreeDto;
import org.squashtest.tm.plugin.rest.jackson.model.RequirementFolderDto;
import org.squashtest.tm.plugin.rest.service.RestProjectService;
import org.squashtest.tm.plugin.rest.service.RestRequirementFolderService;
import org.squashtest.tm.plugin.rest.validators.RequirementFolderPatchValidator;
import org.squashtest.tm.plugin.rest.validators.RequirementFolderPostValidator;

@RestApiController(value=RequirementFolder.class)
@UseDefaultRestApiConfiguration
public class RestRequirementFolderController
extends BaseRestController {
    private static final String REQUIREMENT_FOLDER_TYPE = "requirement-folder";
    @Inject
    private RestRequirementFolderService service;
    @Inject
    private RequirementFolderPostValidator requirementFolderPostValidator;
    @Inject
    private RequirementFolderPatchValidator requirementFolderPatchValidator;
    @Inject
    private ResourceLinksHelper linksHelper;
    @Inject
    private RestProjectService projectService;

    @GetMapping(value={"/requirement-folders"})
    @ResponseBody
    @DynamicFilterExpression(value="name")
    public ResponseEntity<PagedModel<EntityModel<RequirementFolder>>> findAllReadableRequirementFolders(Pageable pageable) {
        Page<RequirementFolder> folders = this.service.findAllReadable(pageable);
        PagedModel res = this.toPagedModel(folders);
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/requirement-folders/tree/{projectIds}"})
    @ResponseBody
    @DynamicFilterExpression(value="*")
    public ResponseEntity<List<ProjectTreeDto>> findRequirementFoldersTreeByProject(@PathVariable(value="projectIds") List<Long> projectIds) {
        ArrayList<Long> alreadyAddedIds = new ArrayList<Long>();
        List<Long> readableProjectIds = this.projectService.getReadableProjectIdsOnRequirementLibrary(projectIds);
        List<RequirementFolder> folders = this.service.findAllRequirementFoldersByPojectIds(readableProjectIds);
        List<ParentFolderTreeDto> tree = this.getRequirementFolderTree(folders, alreadyAddedIds);
        List<ProjectTreeDto> projTree = this.buildProjectTreeFromParentFolders(tree, readableProjectIds);
        return ResponseEntity.ok(projTree);
    }

    @GetMapping(value={"/requirement-folders/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], project[name]")
    @EntityGetter
    public ResponseEntity<EntityModel<RequirementFolder>> findRequirementFolder(@PathVariable(value="id") long id) {
        RequirementFolder folder = this.service.getOne(id);
        EntityModel res = this.toEntityModel((Identified)folder);
        res.add(this.linkService.createLinkTo((Identified)folder.getProject()));
        res.add(this.createRelationTo("content"));
        res.add(this.createRelationTo("attachments"));
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/requirement-folders/{id}/content"})
    @ResponseBody
    @DynamicFilterExpression(value="name")
    public ResponseEntity<PagedModel<EntityModel<RequirementLibraryNode<Resource>>>> findTestCaseFolderContent(@PathVariable(value="id") long folderId, Pageable pageable, ContentInclusion include) {
        Page<RequirementLibraryNode<Resource>> content = null;
        switch (include) {
            case NESTED: {
                content = this.service.findFolderAllContent(folderId, pageable);
                break;
            }
            default: {
                content = this.service.findFolderContent(folderId, pageable);
            }
        }
        SingleRelPagedResources res = this.toPagedResourcesWithRel(content, "content");
        return ResponseEntity.ok((Object)res);
    }

    @PostMapping(value={"/requirement-folders"})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], project[name]")
    public ResponseEntity<EntityModel<RequirementFolder>> createRequirementFolder(@RequestBody RequirementFolderDto folderDto) throws BindException, InvocationTargetException, IllegalAccessException {
        this.requirementFolderPostValidator.validatePostRequirementFolder(folderDto);
        RequirementFolder folder = this.service.addRequirementFolder(folderDto);
        EntityModel res = this.toEntityModel((Identified)folder);
        this.linksHelper.addAllLinksForRequirementFolder((EntityModel<RequirementFolder>)res);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)res);
    }

    @PatchMapping(value={"/requirement-folders/{id}"})
    @ResponseBody
    @DynamicFilterExpression(value="*, parent[name], project[name]")
    public ResponseEntity<EntityModel<RequirementFolder>> patchRequirementFolder(@RequestBody RequirementFolderDto folderPatch, @PathVariable(value="id") long id) throws BindException {
        folderPatch.setId(id);
        this.requirementFolderPatchValidator.validatePatchRequirementFolder(folderPatch);
        RequirementFolder folder = this.service.patchRequirementFolder(folderPatch, id);
        EntityModel res = this.toEntityModel((Identified)folder);
        this.linksHelper.addAllLinksForRequirementFolder((EntityModel<RequirementFolder>)res);
        return ResponseEntity.ok((Object)res);
    }

    @DeleteMapping(value={"/requirement-folders/{ids}"})
    @ResponseBody
    public ResponseEntity<Void> deleteTestCaseFolder(@PathVariable(value="ids") List<Long> folderIds) {
        this.service.deleteFolder(folderIds);
        return ResponseEntity.noContent().build();
    }

    private List<ParentFolderTreeDto> getRequirementFolderTree(List<RequirementFolder> folders, List<Long> alreadyAddedIds) {
        ArrayList<ParentFolderTreeDto> listDto = new ArrayList<ParentFolderTreeDto>();
        for (RequirementFolder folder : folders) {
            if (alreadyAddedIds.contains(folder.getId())) continue;
            ParentFolderTreeDto dto = new ParentFolderTreeDto();
            dto.setType(REQUIREMENT_FOLDER_TYPE);
            dto.setId(folder.getId());
            dto.setName(folder.getName());
            dto.setUrl(this.createSelfLink((Identified)folder).getHref());
            dto.setChildren(Collections.emptyList());
            dto.setProject(folder.getProject());
            if (folder.hasContent()) {
                List<RequirementFolder> folderChildren = this.getAllRequirementFolderFromContent(folder);
                List<ParentFolderTreeDto> tcftd = this.getRequirementFolderTree(folderChildren, alreadyAddedIds);
                dto.setChildren(tcftd);
            }
            alreadyAddedIds.add(folder.getId());
            listDto.add(dto);
        }
        return listDto;
    }

    private List<RequirementFolder> getAllRequirementFolderFromContent(RequirementFolder folder) {
        ArrayList<RequirementFolder> reqFolderList = new ArrayList<RequirementFolder>();
        for (RequirementLibraryNode rln : folder.getContent()) {
            if (!(rln instanceof RequirementFolder)) continue;
            reqFolderList.add((RequirementFolder)rln);
        }
        return reqFolderList;
    }

    private List<ProjectTreeDto> buildProjectTreeFromParentFolders(List<ParentFolderTreeDto> parentFolders, List<Long> projectIds) {
        if (!parentFolders.isEmpty()) {
            return this.appendProjectTreesWithFolderList(parentFolders);
        }
        if (!projectIds.isEmpty()) {
            return this.appendProjectTreesWithoutFolderList(projectIds);
        }
        return Collections.emptyList();
    }

    private List<ProjectTreeDto> appendProjectTreesWithFolderList(List<ParentFolderTreeDto> tree) {
        ArrayList<ProjectTreeDto> projTree = new ArrayList<ProjectTreeDto>();
        Map<Project, List<FolderTreeDto>> map = tree.stream().collect(Collectors.groupingBy(FolderTreeDto::getProject));
        for (Map.Entry<Project, List<FolderTreeDto>> folderTreesByProjectMap : map.entrySet()) {
            Project project = folderTreesByProjectMap.getKey();
            List<FolderTreeDto> list = folderTreesByProjectMap.getValue();
            Collections.sort(list);
            ProjectTreeDto dto = new ProjectTreeDto(project.getId(), project.getName(), list);
            projTree.add(dto);
        }
        Collections.sort(projTree);
        return projTree;
    }

    private List<ProjectTreeDto> appendProjectTreesWithoutFolderList(List<Long> projectIds) {
        ArrayList<ProjectTreeDto> projTree = new ArrayList<ProjectTreeDto>();
        Map<Long, String> projectNameByIdMap = this.projectService.findNamesByProjectIds(projectIds);
        projectNameByIdMap.forEach((projectId, projectName) -> {
            ProjectTreeDto dto = new ProjectTreeDto((Long)projectId, (String)projectName, (List<FolderTreeDto>)new ArrayList<FolderTreeDto>());
            projTree.add(dto);
        });
        Collections.sort(projTree);
        return projTree;
    }
}

