/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.service;

import jakarta.inject.Named;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.plugin.jirasync.client.JiraClient;
import org.squashtest.tm.plugin.jirasync.client.JiraReport;
import org.squashtest.tm.plugin.jirasync.domain.Configuration;
import org.squashtest.tm.plugin.jirasync.service.ClientProvider;
import org.squashtest.tm.plugin.jirasync.service.ConfigurationManager;
import org.squashtest.tm.plugin.jirasync.service.ConfigurationService;
import org.squashtest.tm.plugin.jirasync.service.JiraReportingEffectiveConfiguration;
import org.squashtest.tm.service.internal.repository.RemoteSynchronisationDao;
import org.squashtest.tm.service.statistics.testingstatus.RemoteRequirementStatistics;
import org.squashtest.tm.service.statistics.testingstatus.RemoteRequirementStatisticsDictionary;
import org.squashtest.tm.service.statistics.testingstatus.RemoteTestingStatusService;

@Service
public class JiraReportingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraReportingService.class);
    private final PlatformTransactionManager transactionManager;
    private final ClientProvider clientProvider;
    private final ConfigurationService confService;
    private final RemoteSynchronisationDao remoteSynchronisationDao;
    private final RemoteTestingStatusService remoteTestingStatusService;
    private final ConfigurationManager configurationManager;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    JiraReportingService(PlatformTransactionManager transactionManager, ClientProvider clientProvider, ConfigurationService confService, RemoteSynchronisationDao remoteSynchronisationDao, RemoteTestingStatusService remoteTestingStatusService, @Named(value="org.squashtest.tm.plugin.jirasync.ConfigurationManager") ConfigurationManager configurationManager) {
        this.transactionManager = transactionManager;
        this.clientProvider = clientProvider;
        this.confService = confService;
        this.remoteSynchronisationDao = remoteSynchronisationDao;
        this.remoteTestingStatusService = remoteTestingStatusService;
        this.configurationManager = configurationManager;
    }

    public void performReportingToJira(List<Long> remoteSynchronisationIds) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("[JIRA-SYNC] - Begin reporting to JIRA for {} synchronizations.", (Object)remoteSynchronisationIds.size());
        }
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setPropagationBehavior(3);
        RemoteRequirementStatisticsDictionary remoteRequirementStatisticsDictionary = this.remoteTestingStatusService.getRemoteRequirementStatisticsDictionary("squash.tm.plugin.jirasync");
        for (Long remoteSynchronisationId : remoteSynchronisationIds) {
            TransactionStatus transaction = this.transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[JIRA-SYNC] - Begin rates calculation for sync ID: {}", (Object)remoteSynchronisationId);
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[JIRA-SYNC] - Calculated rates for {} issues in sync ID: {}", (Object)remoteRequirementStatisticsDictionary.combinedStats.size(), (Object)remoteSynchronisationId);
                }
                this.doReportingForOneSync(remoteSynchronisationId, remoteRequirementStatisticsDictionary);
                this.transactionManager.commit(transaction);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("[JIRA-SYNC] - Successfully completed sync ID: {}", (Object)remoteSynchronisationId);
            }
            catch (Exception e) {
                this.transactionManager.rollback(transaction);
                LOGGER.error("[JIRA-SYNC] - Sync failed for ID: {}. Error: {}", (Object)remoteSynchronisationId, (Object)e.getMessage());
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("[JIRA-SYNC] - Finished reporting to JIRA.");
        }
    }

    private void doReportingForOneSync(Long remoteSynchronisationId, RemoteRequirementStatisticsDictionary remoteRequirementStatisticsDictionary) {
        RemoteSynchronisation remoteSynchronisation = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)remoteSynchronisationId);
        try (JiraClient jiraClient = null;){
            BugTracker server = remoteSynchronisation.getServer();
            jiraClient = remoteSynchronisation.getOwner() != null ? this.clientProvider.createUserClient(server, remoteSynchronisation.getOwner().getLogin()) : this.clientProvider.createAppLevelClient(server);
            Configuration conf = this.confService.getConfigurationForProject(remoteSynchronisation);
            JiraReportingEffectiveConfiguration effectiveConfiguration = jiraClient.createJiraReportingEffectiveConfiguration(conf);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[JIRA-SYNC] Begin reporting to JIRA for sync : %d".formatted(remoteSynchronisationId));
            }
            List keys = this.remoteSynchronisationDao.findAllReqSyncExtenderKeys(remoteSynchronisationId);
            keys.forEach(issueKey -> {
                Set ids = remoteRequirementStatisticsDictionary.getRequirementIdsForRemote(server.getId(), issueKey);
                if (ids.size() > 1) {
                    String idsAsString = StringUtils.join((Iterable)ids, (String)",");
                    String msg = String.format("[JIRA-SYNC] Multiple synchronisations of the same JIRA issue %s in server %s. The affected requirements in squash are : %s. Note that it could result in apparently wrong reporting in Jira. You should probably adjust synchronisations perimeters to avoid clashes.", issueKey, server.getName(), idsAsString);
                    LOGGER.warn(msg);
                }
            });
            if (effectiveConfiguration.getValidFieldIds().isEmpty()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[JIRA-SYNC] Skipping reporting to JIRA : No valid field configuration for sync {}", (Object)remoteSynchronisationId);
                }
                return;
            }
            ArrayList<JiraReport> reportsToPost = new ArrayList<JiraReport>();
            int processed = 0;
            int total = keys.size();
            int batchSize = this.configurationManager.getBatchSize();
            while (processed < total) {
                int nextBatchSize = Math.min(processed + batchSize, keys.size());
                List<String> subKeys = keys.subList(processed, nextBatchSize);
                Iterable<JiraReport> initialReport = jiraClient.getInitialReport(subKeys, effectiveConfiguration);
                processed += subKeys.size();
                for (JiraReport jiraReport : initialReport) {
                    this.doStatReconciliation(remoteRequirementStatisticsDictionary, server, jiraReport);
                    if (!jiraReport.shouldBePostToJIRA()) continue;
                    reportsToPost.add(jiraReport);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[JIRA-SYNC] Finished preparing phase for reporting to JIRA. {} Issues are out of date and need to be updated in JIRA.", (Object)reportsToPost.size());
            }
            jiraClient.performReportingToJira(reportsToPost, effectiveConfiguration);
        }
    }

    private void doStatReconciliation(RemoteRequirementStatisticsDictionary dictionary, BugTracker server, JiraReport jiraReport) {
        String issueKey = jiraReport.getKey();
        Set ids = dictionary.getRequirementIdsForRemote(server.getId(), issueKey);
        if (ids == null || ids.isEmpty()) {
            String msg = String.format("Unknown requirement for Jira issue with key \"%s\". The issue may have been moved. Skipping statistics update for this issue.", issueKey);
            LOGGER.warn(msg);
            return;
        }
        RemoteRequirementStatistics stats = dictionary.getMergedStatistics(server.getId(), issueKey);
        jiraReport.performStatReconciliation(stats);
    }

    void setEntityManager(EntityManager em) {
        this.entityManager = em;
    }
}

