/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.controller;

import jakarta.inject.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldBinding;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.plugin.jirasync.controller.dto.ConfigPageConfiguration;
import org.squashtest.tm.plugin.jirasync.controller.dto.ConfigurationPage;
import org.squashtest.tm.plugin.jirasync.controller.model.JiraRemoteSynchronisationModel;
import org.squashtest.tm.plugin.jirasync.controller.model.JiraRemoteSynchronisationModelBuilder;
import org.squashtest.tm.plugin.jirasync.controller.model.JiraSelectTypeModel;
import org.squashtest.tm.plugin.jirasync.controller.model.RestThirdPartyServer;
import org.squashtest.tm.plugin.jirasync.domain.BuiltinSquashField;
import org.squashtest.tm.plugin.jirasync.domain.Configuration;
import org.squashtest.tm.plugin.jirasync.domain.CredentialStatusDto;
import org.squashtest.tm.plugin.jirasync.domain.FieldMapping;
import org.squashtest.tm.plugin.jirasync.domain.JiraRemoteSynchronisation;
import org.squashtest.tm.plugin.jirasync.domain.JiraSelectType;
import org.squashtest.tm.plugin.jirasync.domain.RemoteJiraIssueDto;
import org.squashtest.tm.plugin.jirasync.helpers.SquashRequirementVersionLinkTypeHelper;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraSprint;
import org.squashtest.tm.plugin.jirasync.service.ConfigurationService;
import org.squashtest.tm.plugin.jirasync.service.RequirementSynchronizationService;
import org.squashtest.tm.service.bugtracker.BugTrackerFinderService;
import org.squashtest.tm.service.customfield.CustomFieldBindingFinderService;
import org.squashtest.tm.service.project.GenericProjectFinder;
import org.squashtest.tm.service.templateplugin.TemplateConfigurablePluginBindingService;
import org.squashtest.tm.web.i18n.InternationalizationHelper;

@RestController(value="squash.tm.plugin.jirasync.configurationController")
@RequestMapping(value={"backend/plugin/jirasync/configuration/project/{projectId}"})
public class ConfigurationController {
    private static final String LANG_FIELD_PREFIX = "henix.jirasync.fields.";
    private static final String LANG_SELECT_TYPE_PREFIX = "henix.jirasync.configuration.sync.type.";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationController.class);
    private static final List<String> BUGTRACKER_KINDS = Arrays.asList("jira.rest", "jira.cloud", "jira.xsquash");
    private final BugTrackerFinderService btService;
    private final ConfigurationService pluginService;
    private final RequirementSynchronizationService requirementSynchronizationService;
    private final InternationalizationHelper i18nhelper;
    private final CustomFieldBindingFinderService cufService;
    private final GenericProjectFinder genericProjectFinder;
    private final Provider<JiraRemoteSynchronisationModelBuilder> syncModelBuilderProvider;
    private final SquashRequirementVersionLinkTypeHelper linkTypeHelper;
    private final TemplateConfigurablePluginBindingService templateConfigurablePluginBindingService;

    public ConfigurationController(BugTrackerFinderService btService, ConfigurationService pluginService, RequirementSynchronizationService requirementSynchronizationService, InternationalizationHelper i18nhelper, CustomFieldBindingFinderService cufService, GenericProjectFinder genericProjectFinder, Provider<JiraRemoteSynchronisationModelBuilder> syncModelBuilderProvider, SquashRequirementVersionLinkTypeHelper linkTypeHelper, TemplateConfigurablePluginBindingService templateConfigurablePluginBindingService) {
        this.btService = btService;
        this.pluginService = pluginService;
        this.requirementSynchronizationService = requirementSynchronizationService;
        this.i18nhelper = i18nhelper;
        this.cufService = cufService;
        this.genericProjectFinder = genericProjectFinder;
        this.syncModelBuilderProvider = syncModelBuilderProvider;
        this.linkTypeHelper = linkTypeHelper;
        this.templateConfigurablePluginBindingService = templateConfigurablePluginBindingService;
    }

    @PostMapping(value={"/sync/{syncId}/full"})
    @ResponseBody
    public void forceFullSynchronisation(@PathVariable(value="syncId") List<Long> syncIds) {
        for (Long syncId : syncIds) {
            this.pluginService.commandFullSynchronisation(syncId);
        }
    }

    @DeleteMapping(value={"/sync/{syncId}"})
    @ResponseBody
    public void deleteSync(@PathVariable(value="syncId") List<Long> syncIds) {
        this.pluginService.deleteJiraRemoteSynchronisations(syncIds);
    }

    @PostMapping(value={"/sync/{syncId}/changeSynchronisationId"}, params={"synchronisationEnable"})
    @ResponseBody
    public void changeSync(@PathVariable(value="syncId") long syncId, @RequestParam String synchronisationEnable) {
        this.pluginService.changeSync(syncId, synchronisationEnable);
    }

    @PostMapping(value={"/sync/{syncId}/name"})
    @ResponseBody
    public void updateSyncName(@PathVariable(value="syncId") long syncId, @RequestBody SingleValueRequestBodyDto<String> requestBody) {
        this.pluginService.changeSyncName(syncId, requestBody.value());
    }

    @PostMapping(value={"/sync/{syncId}/selectValue"})
    @ResponseBody
    public void updateSyncSelectValue(@PathVariable(value="syncId") long syncId, @RequestBody SingleValueRequestBodyDto<String> requestBody) {
        this.pluginService.changeSyncSelectValue(syncId, requestBody.value());
    }

    @PostMapping(value={"/sync/{syncId}/owner/{ownerId}"})
    @ResponseBody
    public void updateSyncOwner(@PathVariable(value="syncId") long syncId, @PathVariable(value="ownerId") Long ownerId) {
        this.pluginService.changeSyncOwner(syncId, ownerId);
    }

    @PostMapping(value={"/sync/{syncId}/owner/app-level"})
    @ResponseBody
    public void removeOwner(@PathVariable(value="syncId") long syncId) {
        this.pluginService.removeOwner(syncId);
    }

    @PostMapping(value={"/sync/{syncId}/additionalJQL"})
    @ResponseBody
    public void updateSyncAdditionalJQL(@PathVariable(value="syncId") long syncId, @RequestBody SingleValueRequestBodyDto<String> requestBody) {
        this.pluginService.changeSyncAdditionalJQL(syncId, requestBody.value());
    }

    @PostMapping(value={"/sync/{syncId}/sprintAdditionalJQL"})
    @ResponseBody
    public void updateSyncSprintAdditionalJQL(@PathVariable(value="syncId") long syncId, @RequestBody SingleValueRequestBodyDto<String> requestBody) {
        this.pluginService.changeSyncSprintAdditionalJQL(syncId, requestBody.value());
    }

    @PostMapping(value={"/sync"})
    @ResponseBody
    public JiraRemoteSynchronisationModel createNewSync(@PathVariable(value="projectId") long projectId, @RequestBody JiraRemoteSynchronisationModel newSyncModel) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Try to create synchronisation in project %d : %s", projectId, newSyncModel));
        }
        JiraRemoteSynchronisation jiraRemoteSynchronisation = this.pluginService.addJiraRemoteSynchronisation(projectId, newSyncModel);
        return ((JiraRemoteSynchronisationModelBuilder)this.syncModelBuilderProvider.get()).build(jiraRemoteSynchronisation);
    }

    @PostMapping(value={"/update-sync"})
    @ResponseBody
    public JiraRemoteSynchronisationModel updateSync(@RequestBody JiraRemoteSynchronisationModel syncUpdateModel) {
        JiraRemoteSynchronisation updatedSync = this.pluginService.updateSynchronizationFromModel(syncUpdateModel);
        return ((JiraRemoteSynchronisationModelBuilder)this.syncModelBuilderProvider.get()).build(updatedSync);
    }

    @PostMapping(value={"/create-sprint-sync"})
    @ResponseBody
    public JiraRemoteSynchronisationModel createSprintSynchronisation(@RequestBody JiraRemoteSynchronisationModel syncUpdateModel) {
        JiraRemoteSynchronisation updatedSync = this.pluginService.createSprintSynchronisation(syncUpdateModel);
        return ((JiraRemoteSynchronisationModelBuilder)this.syncModelBuilderProvider.get()).build(updatedSync);
    }

    @PostMapping(value={"/sync/{syncId}/delete-sprint-sync"})
    @ResponseBody
    public void deleteSprintSync(@PathVariable(value="syncId") long syncId) {
        this.pluginService.deleteSprintSync(syncId);
    }

    @PostMapping(value={"/validate-form-step-one"})
    @ResponseBody
    public void validateFormStepOne(@PathVariable(value="projectId") long projectId, @RequestBody JiraRemoteSynchronisationModel newSyncModel) {
        this.pluginService.validateFormStepOne(projectId, newSyncModel);
    }

    @PostMapping(value={"/simulate-new-sync"})
    @ResponseBody
    public List<RemoteJiraIssueDto> simulateNewSync(@PathVariable(value="projectId") long projectId, @RequestBody JiraRemoteSynchronisationModel newSyncModel) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Simulate new sync in project %d : %s", projectId, newSyncModel));
        }
        JiraRemoteSynchronisation sync = this.pluginService.simulateJiraRemoteSynchronisationFromModel(projectId, newSyncModel);
        return this.requirementSynchronizationService.simulateNewSynchronisation(sync, newSyncModel.isCheckMaxItems());
    }

    @PostMapping(value={"/simulate-new-sprint-sync"})
    @ResponseBody
    public List<JiraSprint> simulateNewSprintSync(@PathVariable(value="projectId") Long projectId, @RequestBody JiraRemoteSynchronisationModel newSyncModel) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Simulate new sync in project %d : %s", projectId, newSyncModel));
        }
        JiraRemoteSynchronisation sync = this.pluginService.simulateJiraRemoteSynchronisationFromModel(projectId, newSyncModel);
        return this.requirementSynchronizationService.simulateNewSprintSynchronisation(sync, newSyncModel.isCheckMaxItems());
    }

    @PostMapping(value={"/identify-credentials-status/{serverId}"})
    @ResponseBody
    public CredentialStatusDto identifyCredentialStatus(@PathVariable(value="projectId") long projectId, @PathVariable(value="serverId") Long serverId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Try to identify used credentials for server with id %d in project %d", serverId, projectId));
        }
        return this.pluginService.getCredentialsStatus(serverId);
    }

    @GetMapping
    public ConfigurationPage getConfigurationPanel(@PathVariable(value="projectId") long projectId) {
        ConfigPageConfiguration pageconf = new ConfigPageConfiguration();
        pageconf.setProjectId(projectId);
        ArrayList<BugTracker> bugtrackers = new ArrayList<BugTracker>(Collections.emptyList());
        BUGTRACKER_KINDS.forEach(kind -> {
            boolean bl = bugtrackers.addAll(this.btService.findByKind(kind));
        });
        bugtrackers.sort((a, b) -> a.getName().compareToIgnoreCase(b.getName()));
        pageconf.setServers(this.toRestServers(bugtrackers));
        pageconf.setSelectTypes(this.getSelectTypes());
        Map<String, String> fieldList = this.makeFieldList(projectId);
        pageconf.setAvailableFields(fieldList);
        Map<Long, String> types = this.linkTypeHelper.createLinkTypeMap();
        pageconf.setLinkTypes(types);
        Map<String, List<String>> valueMappings = this.makeValueMappingsList(projectId);
        pageconf.setValueMappingsHelper(valueMappings);
        List<JiraRemoteSynchronisation> jiraRemoteSynchronisations = this.pluginService.findRemoteSyncForProject(projectId, "squash.tm.plugin.jirasync");
        List<JiraRemoteSynchronisationModel> synchronisationModels = jiraRemoteSynchronisations.stream().map(jiraRemoteSynchronisation -> ((JiraRemoteSynchronisationModelBuilder)this.syncModelBuilderProvider.get()).build((JiraRemoteSynchronisation)jiraRemoteSynchronisation)).collect(Collectors.toList());
        pageconf.setSynchronisations(synchronisationModels);
        Configuration conf = this.pluginService.getConfigurationForProject(projectId);
        pageconf.setConfiguration(conf);
        boolean isConfigurationBound = this.templateConfigurablePluginBindingService.isProjectConfigurationBoundToTemplate(projectId, "squash.tm.plugin.jirasync");
        return new ConfigurationPage(pageconf, projectId, isConfigurationBound);
    }

    private List<JiraSelectTypeModel> getSelectTypes() {
        EnumSet<JiraSelectType> selectTypes = EnumSet.allOf(JiraSelectType.class);
        return selectTypes.stream().map(selectType -> {
            String key = LANG_SELECT_TYPE_PREFIX + selectType.name().toLowerCase();
            return new JiraSelectTypeModel(selectType.name(), key);
        }).collect(Collectors.toList());
    }

    private Collection<RestThirdPartyServer> toRestServers(List<BugTracker> btrackers) {
        List<RestThirdPartyServer> servers = btrackers.stream().map(bt -> new RestThirdPartyServer(bt.getId(), bt.getName(), bt.getUrl())).sorted((a, b) -> a.getName().compareToIgnoreCase(b.getName())).collect(Collectors.toList());
        String nullServerName = this.i18nhelper.internationalize("label.None", LocaleContextHolder.getLocale());
        RestThirdPartyServer nullServer = new RestThirdPartyServer(0L, nullServerName, null);
        servers.add(0, nullServer);
        return servers;
    }

    private Map<String, String> makeFieldList(Long projectId) {
        String code;
        Locale locale = LocaleContextHolder.getLocale();
        HashMap<String, String> fields = new HashMap<String, String>();
        BuiltinSquashField[] builtinSquashFieldArray = BuiltinSquashField.values();
        int n = builtinSquashFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            BuiltinSquashField f = builtinSquashFieldArray[n2];
            code = f.toString();
            String label = this.i18nhelper.getMessage(LANG_FIELD_PREFIX + code, null, "translation of " + code, locale);
            fields.put(code, label);
            ++n2;
        }
        List cufs = this.cufService.findCustomFieldsForProjectAndEntity(projectId.longValue(), BindableEntity.REQUIREMENT_VERSION);
        for (CustomFieldBinding cufB : cufs) {
            CustomField cf = cufB.getCustomField();
            code = cf.getCode();
            String name = cf.getName();
            fields.put(code, name);
        }
        return fields;
    }

    private Map<String, List<String>> makeValueMappingsList(long projectId) {
        LinkedHashMap<String, List<String>> valueMappings = new LinkedHashMap<String, List<String>>();
        GenericProject p = this.genericProjectFinder.findById(projectId);
        InfoList categories = p.getRequirementCategories();
        List<String> strCrits = Arrays.asList("critical", "major", "minor", "undefined");
        List<String> strStats = Arrays.asList("work_in_progress", "under_review", "approved", "obsolete");
        ArrayList<String> strCats = new ArrayList<String>(categories.getItems().size());
        boolean canLowercase = "DEF_REQ_CAT".equals(categories.getCode());
        for (InfoListItem item : categories.getItems()) {
            String code = canLowercase ? item.getCode().toLowerCase() : item.getCode();
            strCats.add(code);
        }
        valueMappings.put("criticality", strCrits);
        valueMappings.put("category", strCats);
        valueMappings.put("status", strStats);
        return valueMappings;
    }

    @PostMapping(value={"/mappings"})
    @ResponseBody
    public void addFieldMapping(@PathVariable(value="projectId") long projectId, @RequestBody FieldMapping newMapping) {
        this.pluginService.addFieldMapping(projectId, newMapping);
    }

    @PostMapping(value={"/mappings/{id}/squashfield"})
    @ResponseBody
    public void changeMappingSquashField(@PathVariable(value="projectId") Long projectId, @PathVariable(value="id") String mappingId, @RequestBody SingleValueRequestBodyDto<String> requestBody) {
        this.pluginService.updateFieldMappingSquashField(projectId, mappingId, requestBody.value());
    }

    @PostMapping(value={"/mappings/{id}/jirafield"})
    @ResponseBody
    public void changeMappingJiraField(@PathVariable(value="projectId") Long projectId, @PathVariable(value="id") String mappingId, @RequestBody SingleValueRequestBodyDto<String> requestBody) {
        this.pluginService.updateFieldMappingJiraField(projectId, mappingId, requestBody.value());
    }

    @DeleteMapping(value={"/mappings/{ids}"})
    @ResponseBody
    public void removeFieldMappings(@PathVariable(value="projectId") Long projectId, @PathVariable(value="ids") List<String> mappingIds) {
        this.pluginService.removeFieldMappingsByIds(projectId, mappingIds);
    }

    @PostMapping(value={"/valuemappings"})
    @ResponseBody
    public void changeValueMappings(@PathVariable(value="projectId") Long projectId, @RequestBody SingleValueRequestBodyDto<String> requestBody) {
        this.pluginService.updateValueMappings(projectId, requestBody.value());
    }

    @GetMapping(value={"/valuemappings"})
    @ResponseBody
    public Map<String, String> retrieveValueMappings(@PathVariable(value="projectId") Long projectId) {
        Configuration conf = this.pluginService.getConfigurationForProject(projectId);
        return Collections.singletonMap("mappings", conf.getYamlFieldvalueMapping());
    }

    @PostMapping(value={"jira-field-test-status"})
    @ResponseBody
    public void updateJiraFieldStatus(@PathVariable(value="projectId") long projectId, @RequestBody SingleValueRequestBodyDto<String> requestBody) {
        this.pluginService.changeJiraStatusField(projectId, requestBody.value());
    }

    @PostMapping(value={"jira-field-progress-redaction"})
    @ResponseBody
    public void updateJiraFieldRedaction(@PathVariable(value="projectId") long projectId, @RequestBody SingleValueRequestBodyDto<String> requestBody) {
        this.pluginService.changeJiraRedactionField(projectId, requestBody.value());
    }

    @PostMapping(value={"jira-field-redaction-ratio"})
    @ResponseBody
    public void updateJiraFieldRedactionRatio(@PathVariable(value="projectId") long projectId, @RequestBody SingleValueRequestBodyDto<String> requestBody) {
        this.pluginService.changeJiraRedactionRatioField(projectId, requestBody.value());
    }

    @PostMapping(value={"jira-field-progress-verification"})
    @ResponseBody
    public void updateJiraFieldVerification(@PathVariable(value="projectId") long projectId, @RequestBody SingleValueRequestBodyDto<String> requestBody) {
        this.pluginService.changeJiraVerificationField(projectId, requestBody.value());
    }

    @PostMapping(value={"jira-field-verification-ratio"})
    @ResponseBody
    public void updateJiraFieldVerificationRatio(@PathVariable(value="projectId") long projectId, @RequestBody SingleValueRequestBodyDto<String> requestBody) {
        this.pluginService.changeJiraVerificationRatioField(projectId, requestBody.value());
    }

    @PostMapping(value={"jira-field-progress-validation"})
    @ResponseBody
    public void updateJiraFieldValidation(@PathVariable(value="projectId") long projectId, @RequestBody SingleValueRequestBodyDto<String> requestBody) {
        this.pluginService.changeJiraValidationField(projectId, requestBody.value());
    }

    @PostMapping(value={"jira-field-validation-ratio"})
    @ResponseBody
    public void updateJiraFieldValidationRatio(@PathVariable(value="projectId") long projectId, @RequestBody SingleValueRequestBodyDto<String> requestBody) {
        this.pluginService.changeJiraValidationRatioField(projectId, requestBody.value());
    }

    @PostMapping(value={"/links/jirafield"})
    @ResponseBody
    public void changeLinkJiraField(@PathVariable(value="projectId") Long projectId, @RequestParam(value="linkId") String linkId, @RequestBody SingleValueRequestBodyDto<String> requestBody) {
        this.pluginService.updateRequirementLinkJiraField(projectId, linkId, requestBody.value());
    }

    public record SingleValueRequestBodyDto<T>(T value) {
    }
}

