--  Lock Database
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 1, LOCKEDBY = 'runner-yfpexrfv8-project-33554404-concurrent-0-yb8hs38o (100.64.14.145)', LOCKGRANTED = NOW() WHERE ID = 1 AND `LOCKED` = 0;

--  *********************************************************************
--  Update Database Script
--  *********************************************************************
--  Change Log: upgrade.changelog-up-to-10.0.0.xml
--  Ran at: 19/11/2025 12:31
--  Against: root@jdbc:mariadb://mariadb/squashtest
--  Liquibase version: 4.29.2
--  *********************************************************************

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-export-right-in-custom-report-workspace::bmarejus
INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID)
      SELECT ACL_GROUP.ID AS ACL_GROUP_ID,
             64           AS PERMISSION_MASK,
             ACL_CLASS.ID AS CLASS_ID
      FROM ACL_GROUP_PERMISSION
             INNER JOIN ACL_GROUP ON ACL_GROUP_PERMISSION.ACL_GROUP_ID = ACL_GROUP.ID
             INNER JOIN ACL_CLASS ON ACL_GROUP_PERMISSION.CLASS_ID = ACL_CLASS.ID
      WHERE ACL_GROUP_PERMISSION.PERMISSION_MASK = 1
        AND ACL_CLASS.CLASSNAME = 'org.squashtest.tm.domain.customreport.CustomReportLibrary'
        AND ACL_GROUP.QUALIFIED_NAME != 'squashtest.acl.group.tm.ProjectViewer';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-export-right-in-custom-report-workspace', 'bmarejus', 'tm/tm.changelog-10.0.0.xml', NOW(), 1, '9:82e6480dadeb2840ba7b81a5b9ba15e5', 'sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-delete-execution-permission::bmarejus
INSERT INTO ACL_GROUP_PERMISSION (ACL_GROUP_ID, PERMISSION_MASK, CLASS_ID)
      SELECT ACL_GROUP.ID,
             131072,
             ACL_CLASS.ID
      FROM ACL_GROUP_PERMISSION
             INNER JOIN ACL_GROUP ON ACL_GROUP_PERMISSION.ACL_GROUP_ID = ACL_GROUP.ID
             INNER JOIN ACL_CLASS ON ACL_GROUP_PERMISSION.CLASS_ID = ACL_CLASS.ID
      WHERE ACL_GROUP_PERMISSION.PERMISSION_MASK = 8
        AND ACL_CLASS.CLASSNAME = 'org.squashtest.tm.domain.campaign.CampaignLibrary';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-delete-execution-permission', 'bmarejus', 'tm/tm.changelog-10.0.0.xml', NOW(), 2, '9:97a59d379e93ac4c96c767e7d3a0f4d1', 'sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-sequences-for-mariadb::pguygot
SET @startvalue = (SELECT COALESCE(MAX(ID), 0) + 1 FROM ACL_CLASS);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS acl_class_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(ID), 0) + 1 FROM ACL_GROUP);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS acl_group_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(ID), 0) + 1 FROM ACL_OBJECT_IDENTITY);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS acl_object_identity_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(ID), 0) + 1 FROM ACL_RESPONSIBILITY_SCOPE_ENTRY);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS acl_responsibility_scope_entry_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(ACTION_WORD_ID), 0) + 1 FROM ACTION_WORD);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS action_word_action_word_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(ACTION_WORD_FRAGMENT_ID), 0) + 1 FROM ACTION_WORD_FRAGMENT);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS action_word_fragment_action_word_fragment_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(AWL_ID), 0) + 1 FROM ACTION_WORD_LIBRARY);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS action_word_library_awl_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(AWLN_ID), 0) + 1 FROM ACTION_WORD_LIBRARY_NODE);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS action_word_library_node_awln_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(ACTION_WORD_PARAMETER_VALUE_ID), 0) + 1 FROM ACTION_WORD_PARAMETER_VALUE);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS action_word_parameter_value_action_word_parameter_value_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(TOKEN_ID), 0) + 1 FROM API_TOKEN);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS api_token_token_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(ATTACHMENT_ID), 0) + 1 FROM ATTACHMENT);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS attachment_attachment_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(ATTACHMENT_CONTENT_ID), 0) + 1 FROM ATTACHMENT_CONTENT);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS attachment_content_attachment_content_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(ATTACHMENT_LIST_ID), 0) + 1 FROM ATTACHMENT_LIST);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS attachment_list_attachment_list_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(EXTENDER_ID), 0) + 1 FROM AUTOMATED_EXECUTION_EXTENDER);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS automated_execution_extender_extender_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(AT_TECHNOLOGY_ID), 0) + 1 FROM AUTOMATED_TEST_TECHNOLOGY);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS automated_test_technology_at_technology_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(TEST_ID), 0) + 1 FROM AUTOMATED_TEST);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS automated_test_test_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(AUTOMATION_REQUEST_ID), 0) + 1 FROM AUTOMATION_REQUEST);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS automation_request_automation_request_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(ARL_ID), 0) + 1 FROM AUTOMATION_REQUEST_LIBRARY);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS automation_request_library_arl_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(BUGTRACKER_PROJECT_ID), 0) + 1 FROM BUGTRACKER_PROJECT);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS bugtracker_project_bugtracker_project_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(CL_ID), 0) + 1 FROM CAMPAIGN_LIBRARY);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS campaign_library_cl_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(CLN_ID), 0) + 1 FROM CAMPAIGN_LIBRARY_NODE);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS campaign_library_node_cln_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(CTPI_ID), 0) + 1 FROM CAMPAIGN_TEST_PLAN_ITEM);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS campaign_test_plan_item_ctpi_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(CHART_ID), 0) + 1 FROM CHART_DEFINITION);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS chart_definition_chart_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(FILTER_ID), 0) + 1 FROM CHART_FILTER);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS chart_filter_filter_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(CHART_PROJECT_SCOPE_ID), 0) + 1 FROM CHART_PROJECT_SCOPE);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS chart_project_scope_chart_project_scope_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(ATTEMPT_ID), 0) + 1 FROM CONNECTION_ATTEMPT_LOG);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS connection_attempt_log_attempt_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(ID), 0) + 1 FROM CORE_GROUP);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS core_group_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(PARTY_ID), 0) + 1 FROM CORE_PARTY);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS core_party_party_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(PARTY_ID), 0) + 1 FROM CORE_USER);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS core_user_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(CFB_ID), 0) + 1 FROM CUSTOM_FIELD_BINDING);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS custom_field_binding_cfb_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(CF_ID), 0) + 1 FROM CUSTOM_FIELD);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS custom_field_cf_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(CFV_ID), 0) + 1 FROM CUSTOM_FIELD_VALUE);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS custom_field_value_cfv_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(CRCB_ID), 0) + 1 FROM CUSTOM_REPORT_CHART_BINDING);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS custom_report_chart_binding_crcb_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(CRCE_ID), 0) + 1 FROM CUSTOM_REPORT_CUSTOM_EXPORT);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS custom_report_custom_export_crce_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(CRD_ID), 0) + 1 FROM CUSTOM_REPORT_DASHBOARD);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS custom_report_dashboard_crd_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(CRF_ID), 0) + 1 FROM CUSTOM_REPORT_FOLDER);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS custom_report_folder_crf_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(CRL_ID), 0) + 1 FROM CUSTOM_REPORT_LIBRARY);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS custom_report_library_crl_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(CRLN_ID), 0) + 1 FROM CUSTOM_REPORT_LIBRARY_NODE);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS custom_report_library_node_crln_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(CRRB_ID), 0) + 1 FROM CUSTOM_REPORT_REPORT_BINDING);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS custom_report_report_binding_crrb_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(DATASET_ID), 0) + 1 FROM DATASET);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS dataset_dataset_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(DATASET_PARAM_VALUE_ID), 0) + 1 FROM DATASET_PARAM_VALUE);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS dataset_param_value_dataset_param_value_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(DET_ID), 0) + 1 FROM DENORMALIZED_ENVIRONMENT_TAG);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS denormalized_environment_tag_det_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(DEV_ID), 0) + 1 FROM DENORMALIZED_ENVIRONMENT_VARIABLE);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS denormalized_environment_variable_dev_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(DFV_ID), 0) + 1 FROM DENORMALIZED_FIELD_VALUE);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS denormalized_field_value_dfv_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(EVB_ID), 0) + 1 FROM ENVIRONMENT_VARIABLE_BINDING);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS environment_variable_binding_evb_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(EV_ID), 0) + 1 FROM ENVIRONMENT_VARIABLE);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS environment_variable_ev_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(EXECUTION_ID), 0) + 1 FROM EXECUTION);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS execution_execution_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(EXECUTION_STEP_ID), 0) + 1 FROM EXECUTION_STEP);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS execution_step_execution_step_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(EVENT_ID), 0) + 1 FROM EXPLORATORY_EXECUTION_EVENT);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS exploratory_execution_event_event_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(OVERVIEW_ID), 0) + 1 FROM EXPLORATORY_SESSION_OVERVIEW);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS exploratory_session_overview_overview_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(FAILURE_DETAIL_ID), 0) + 1 FROM FAILURE_DETAIL);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS failure_detail_failure_detail_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(GCDC_ID), 0) + 1 FROM GRID_COLUMN_DISPLAY_CONFIGURATION);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS grid_column_display_configuration_gcdc_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(GCDR_ID), 0) + 1 FROM GRID_COLUMN_DISPLAY_REFERENCE);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS grid_column_display_reference_gcdr_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(INFO_LIST_ID), 0) + 1 FROM INFO_LIST);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS info_list_info_list_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(ITEM_ID), 0) + 1 FROM INFO_LIST_ITEM);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS info_list_item_item_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(ISSUE_ID), 0) + 1 FROM ISSUE);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS issue_issue_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(ISSUE_LIST_ID), 0) + 1 FROM ISSUE_LIST);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS issue_list_issue_list_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(ITEM_TEST_PLAN_ID), 0) + 1 FROM ITERATION_TEST_PLAN_ITEM);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS item_test_plan_item_test_plan_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(ITERATION_ID), 0) + 1 FROM ITERATION);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS iteration_iteration_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(PLUGIN_BINDING_ID), 0) + 1 FROM LIBRARY_PLUGIN_BINDING);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS library_plugin_binding_plugin_binding_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(MILESTONE_BINDING_ID), 0) + 1 FROM MILESTONE_BINDING);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS milestone_binding_milestone_binding_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(MILESTONE_BINDING_PERIMETER_ID), 0) + 1 FROM MILESTONE_BINDING_PERIMETER);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS milestone_binding_perimeter_milestone_binding_perimeter_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(MILESTONE_ID), 0) + 1 FROM MILESTONE);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS milestone_milestone_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(PARAM_ID), 0) + 1 FROM PARAMETER);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS parameter_param_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(PREFERENCE_ID), 0) + 1 FROM PARTY_PREFERENCE);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS party_preference_preference_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(PFI_ID), 0) + 1 FROM PIVOT_FORMAT_IMPORT);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS pivot_format_import_pfi_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(PROJECT_FILTER_ID), 0) + 1 FROM PROJECT_FILTER);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS project_filter_project_filter_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(PROJECT_ID), 0) + 1 FROM PROJECT);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS project_project_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(TA_PROJECT_ID), 0) + 1 FROM TEST_AUTOMATION_PROJECT);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS proto_test_automation_project_ta_project_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(QUERY_COLUMN_ID), 0) + 1 FROM QUERY_COLUMN_PROTOTYPE);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS query_column_prototype_query_column_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(QUERY_FILTER_ID), 0) + 1 FROM QUERY_FILTER_COLUMN);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS query_filter_column_query_filter_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(QUERY_MODEL_ID), 0) + 1 FROM QUERY_MODEL);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS query_model_query_model_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(REMOTE_AUTOMATION_REQUEST_EXTENDER_ID), 0) + 1 FROM REMOTE_AUTOMATION_REQUEST_EXTENDER);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS remote_automation_request_ext_remote_automation_request_ext_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(REMOTE_SYNCHRONISATION_ID), 0) + 1 FROM REMOTE_SYNCHRONISATION);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS remote_synchronisation_remote_synchronisation_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(REPORT_ID), 0) + 1 FROM REPORT_DEFINITION);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS report_definition_report_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(EVENT_ID), 0) + 1 FROM REQUIREMENT_AUDIT_EVENT);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS requirement_audit_event_event_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(RF_SYNC_EXTENDER_ID), 0) + 1 FROM REQUIREMENT_FOLDER_SYNC_EXTENDER);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS requirement_folder_sync_extender_rf_sync_extender_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(RLN_ID), 0) + 1 FROM REQUIREMENT_LIBRARY_NODE);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS requirement_library_node_rln_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(RL_ID), 0) + 1 FROM REQUIREMENT_LIBRARY);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS requirement_library_rl_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(REQ_SYNC_ID), 0) + 1 FROM REQUIREMENT_SYNC_EXTENDER);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS requirement_sync_extender_req_sync_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(REQUIREMENT_VERSION_COVERAGE_ID), 0) + 1 FROM REQUIREMENT_VERSION_COVERAGE);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS requirement_version_coverage_requirement_version_coverage_i_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(LINK_ID), 0) + 1 FROM REQUIREMENT_VERSION_LINK);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS requirement_version_link_link_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(TYPE_ID), 0) + 1 FROM REQUIREMENT_VERSION_LINK_TYPE);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS requirement_version_link_type_type_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(RES_ID), 0) + 1 FROM RESOURCE);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS resource_res_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(SCM_REPOSITORY_ID), 0) + 1 FROM SCM_REPOSITORY);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS scm_repository_scm_repository_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(NOTE_ID), 0) + 1 FROM SESSION_NOTE);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS session_note_note_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(SPRINT_REQ_VERSION_ID), 0) + 1 FROM SPRINT_REQ_VERSION);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS sprint_req_version_sprint_req_version_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(SPRINT_REQ_SYNC_ID), 0) + 1 FROM SPRINT_REQUIREMENT_SYNC_EXTENDER);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS sprint_requirement_sync_extender_sprint_req_sync_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(CREDENTIAL_ID), 0) + 1 FROM STORED_CREDENTIALS);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS stored_credentials_credential_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(BINDING_ID), 0) + 1 FROM TEMPLATE_CONFIGURABLE_PLUGIN_BINDING);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS template_configurable_plugin_binding_binding_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(TCLN_ID), 0) + 1 FROM TEST_CASE_LIBRARY_NODE);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS test_case_library_node_tcln_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(TCL_ID), 0) + 1 FROM TEST_CASE_LIBRARY);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS test_case_library_tcl_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(TEST_PLAN_ITEM_ID), 0) + 1 FROM TEST_PLAN_ITEM);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS test_plan_item_test_plan_item_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(TEST_PLAN_ID), 0) + 1 FROM TEST_PLAN);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS test_plan_test_plan_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(TEST_STEP_ID), 0) + 1 FROM TEST_STEP);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS test_step_test_step_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(ID), 0) + 1 FROM TEST_SUITE);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS test_suite_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

SET @startvalue = (SELECT COALESCE(MAX(SERVER_ID), 0) + 1 FROM THIRD_PARTY_SERVER);

SET @altersql = CONCAT('CREATE SEQUENCE IF NOT EXISTS third_party_server_server_id_seq START WITH ', @startvalue, ' INCREMENT BY 1;');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-sequences-for-mariadb', 'pguygot', 'tm/tm.changelog-10.0.0.xml', NOW(), 3, '9:6b3a250b48639e49321abf055baed5bb', 'sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sq...', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-grant-sequence-and-change-id-auto-increment-to-sequence-nextvalue::pguygot
GRANT ALL ON acl_class_id_seq TO alter_squash_table_seq;

ALTER TABLE ACL_CLASS MODIFY ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR acl_class_id_seq);

GRANT ALL ON acl_group_id_seq TO alter_squash_table_seq;

ALTER TABLE ACL_GROUP MODIFY ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR acl_group_id_seq);

GRANT ALL ON acl_object_identity_id_seq TO alter_squash_table_seq;

ALTER TABLE ACL_OBJECT_IDENTITY MODIFY ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR acl_object_identity_id_seq);

GRANT ALL ON acl_responsibility_scope_entry_id_seq TO alter_squash_table_seq;

ALTER TABLE ACL_RESPONSIBILITY_SCOPE_ENTRY MODIFY ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR acl_responsibility_scope_entry_id_seq);

GRANT ALL ON action_word_action_word_id_seq TO alter_squash_table_seq;

ALTER TABLE ACTION_WORD MODIFY ACTION_WORD_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR action_word_action_word_id_seq);

GRANT ALL ON action_word_fragment_action_word_fragment_id_seq TO alter_squash_table_seq;

ALTER TABLE ACTION_WORD_FRAGMENT MODIFY ACTION_WORD_FRAGMENT_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR action_word_fragment_action_word_fragment_id_seq);

GRANT ALL ON action_word_library_awl_id_seq TO alter_squash_table_seq;

ALTER TABLE ACTION_WORD_LIBRARY MODIFY AWL_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR action_word_library_awl_id_seq);

GRANT ALL ON action_word_library_node_awln_id_seq TO alter_squash_table_seq;

ALTER TABLE ACTION_WORD_LIBRARY_NODE MODIFY AWLN_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR action_word_library_node_awln_id_seq);

GRANT ALL ON action_word_parameter_value_action_word_parameter_value_id_seq TO alter_squash_table_seq;

ALTER TABLE ACTION_WORD_PARAMETER_VALUE MODIFY ACTION_WORD_PARAMETER_VALUE_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR action_word_parameter_value_action_word_parameter_value_id_seq);

GRANT ALL ON api_token_token_id_seq TO alter_squash_table_seq;

ALTER TABLE API_TOKEN MODIFY TOKEN_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR api_token_token_id_seq);

GRANT ALL ON attachment_attachment_id_seq TO alter_squash_table_seq;

ALTER TABLE ATTACHMENT MODIFY ATTACHMENT_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR attachment_attachment_id_seq);

GRANT ALL ON attachment_content_attachment_content_id_seq TO alter_squash_table_seq;

ALTER TABLE ATTACHMENT_CONTENT MODIFY ATTACHMENT_CONTENT_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR attachment_content_attachment_content_id_seq);

GRANT ALL ON attachment_list_attachment_list_id_seq TO alter_squash_table_seq;

ALTER TABLE ATTACHMENT_LIST MODIFY ATTACHMENT_LIST_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR attachment_list_attachment_list_id_seq);

GRANT ALL ON automated_execution_extender_extender_id_seq TO alter_squash_table_seq;

ALTER TABLE AUTOMATED_EXECUTION_EXTENDER MODIFY EXTENDER_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR automated_execution_extender_extender_id_seq);

GRANT ALL ON automated_test_technology_at_technology_id_seq TO alter_squash_table_seq;

ALTER TABLE AUTOMATED_TEST_TECHNOLOGY MODIFY AT_TECHNOLOGY_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR automated_test_technology_at_technology_id_seq);

GRANT ALL ON automated_test_test_id_seq TO alter_squash_table_seq;

ALTER TABLE AUTOMATED_TEST MODIFY TEST_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR automated_test_test_id_seq);

GRANT ALL ON automation_request_automation_request_id_seq TO alter_squash_table_seq;

ALTER TABLE AUTOMATION_REQUEST MODIFY AUTOMATION_REQUEST_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR automation_request_automation_request_id_seq);

GRANT ALL ON automation_request_library_arl_id_seq TO alter_squash_table_seq;

ALTER TABLE AUTOMATION_REQUEST_LIBRARY MODIFY ARL_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR automation_request_library_arl_id_seq);

GRANT ALL ON bugtracker_project_bugtracker_project_id_seq TO alter_squash_table_seq;

ALTER TABLE BUGTRACKER_PROJECT MODIFY BUGTRACKER_PROJECT_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR bugtracker_project_bugtracker_project_id_seq);

GRANT ALL ON campaign_library_cl_id_seq TO alter_squash_table_seq;

ALTER TABLE CAMPAIGN_LIBRARY MODIFY CL_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR campaign_library_cl_id_seq);

GRANT ALL ON campaign_library_node_cln_id_seq TO alter_squash_table_seq;

ALTER TABLE CAMPAIGN_LIBRARY_NODE MODIFY CLN_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR campaign_library_node_cln_id_seq);

GRANT ALL ON campaign_test_plan_item_ctpi_id_seq TO alter_squash_table_seq;

ALTER TABLE CAMPAIGN_TEST_PLAN_ITEM MODIFY CTPI_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR campaign_test_plan_item_ctpi_id_seq);

GRANT ALL ON chart_definition_chart_id_seq TO alter_squash_table_seq;

ALTER TABLE CHART_DEFINITION MODIFY CHART_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR chart_definition_chart_id_seq);

GRANT ALL ON chart_filter_filter_id_seq TO alter_squash_table_seq;

ALTER TABLE CHART_FILTER MODIFY FILTER_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR chart_filter_filter_id_seq);

GRANT ALL ON chart_project_scope_chart_project_scope_id_seq TO alter_squash_table_seq;

ALTER TABLE CHART_PROJECT_SCOPE MODIFY CHART_PROJECT_SCOPE_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR chart_project_scope_chart_project_scope_id_seq);

GRANT ALL ON connection_attempt_log_attempt_id_seq TO alter_squash_table_seq;

ALTER TABLE CONNECTION_ATTEMPT_LOG MODIFY ATTEMPT_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR connection_attempt_log_attempt_id_seq);

GRANT ALL ON core_group_id_seq TO alter_squash_table_seq;

ALTER TABLE CORE_GROUP MODIFY ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR core_group_id_seq);

GRANT ALL ON core_party_party_id_seq TO alter_squash_table_seq;

ALTER TABLE CORE_PARTY MODIFY PARTY_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR core_party_party_id_seq);

GRANT ALL ON core_user_id_seq TO alter_squash_table_seq;

ALTER TABLE CORE_USER MODIFY PARTY_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR core_user_id_seq);

GRANT ALL ON custom_field_binding_cfb_id_seq TO alter_squash_table_seq;

ALTER TABLE CUSTOM_FIELD_BINDING MODIFY CFB_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR custom_field_binding_cfb_id_seq);

GRANT ALL ON custom_field_cf_id_seq TO alter_squash_table_seq;

ALTER TABLE CUSTOM_FIELD MODIFY CF_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR custom_field_cf_id_seq);

GRANT ALL ON custom_field_value_cfv_id_seq TO alter_squash_table_seq;

ALTER TABLE CUSTOM_FIELD_VALUE MODIFY CFV_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR custom_field_value_cfv_id_seq);

GRANT ALL ON custom_report_chart_binding_crcb_id_seq TO alter_squash_table_seq;

ALTER TABLE CUSTOM_REPORT_CHART_BINDING MODIFY CRCB_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR custom_report_chart_binding_crcb_id_seq);

GRANT ALL ON custom_report_custom_export_crce_id_seq TO alter_squash_table_seq;

ALTER TABLE CUSTOM_REPORT_CUSTOM_EXPORT MODIFY CRCE_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR custom_report_custom_export_crce_id_seq);

GRANT ALL ON custom_report_dashboard_crd_id_seq TO alter_squash_table_seq;

ALTER TABLE CUSTOM_REPORT_DASHBOARD MODIFY CRD_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR custom_report_dashboard_crd_id_seq);

GRANT ALL ON custom_report_folder_crf_id_seq TO alter_squash_table_seq;

ALTER TABLE CUSTOM_REPORT_FOLDER MODIFY CRF_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR custom_report_folder_crf_id_seq);

GRANT ALL ON custom_report_library_crl_id_seq TO alter_squash_table_seq;

ALTER TABLE CUSTOM_REPORT_LIBRARY MODIFY CRL_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR custom_report_library_crl_id_seq);

GRANT ALL ON custom_report_library_node_crln_id_seq TO alter_squash_table_seq;

ALTER TABLE CUSTOM_REPORT_LIBRARY_NODE MODIFY CRLN_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR custom_report_library_node_crln_id_seq);

GRANT ALL ON custom_report_report_binding_crrb_id_seq TO alter_squash_table_seq;

ALTER TABLE CUSTOM_REPORT_REPORT_BINDING MODIFY CRRB_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR custom_report_report_binding_crrb_id_seq);

GRANT ALL ON dataset_dataset_id_seq TO alter_squash_table_seq;

ALTER TABLE DATASET MODIFY DATASET_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR dataset_dataset_id_seq);

GRANT ALL ON dataset_param_value_dataset_param_value_id_seq TO alter_squash_table_seq;

ALTER TABLE DATASET_PARAM_VALUE MODIFY DATASET_PARAM_VALUE_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR dataset_param_value_dataset_param_value_id_seq);

GRANT ALL ON denormalized_environment_tag_det_id_seq TO alter_squash_table_seq;

ALTER TABLE DENORMALIZED_ENVIRONMENT_TAG MODIFY DET_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR denormalized_environment_tag_det_id_seq);

GRANT ALL ON denormalized_environment_variable_dev_id_seq TO alter_squash_table_seq;

ALTER TABLE DENORMALIZED_ENVIRONMENT_VARIABLE MODIFY DEV_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR denormalized_environment_variable_dev_id_seq);

GRANT ALL ON denormalized_field_value_dfv_id_seq TO alter_squash_table_seq;

ALTER TABLE DENORMALIZED_FIELD_VALUE MODIFY DFV_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR denormalized_field_value_dfv_id_seq);

GRANT ALL ON environment_variable_binding_evb_id_seq TO alter_squash_table_seq;

ALTER TABLE ENVIRONMENT_VARIABLE_BINDING MODIFY EVB_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR environment_variable_binding_evb_id_seq);

GRANT ALL ON environment_variable_ev_id_seq TO alter_squash_table_seq;

ALTER TABLE ENVIRONMENT_VARIABLE MODIFY EV_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR environment_variable_ev_id_seq);

GRANT ALL ON execution_execution_id_seq TO alter_squash_table_seq;

ALTER TABLE EXECUTION MODIFY EXECUTION_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR execution_execution_id_seq);

GRANT ALL ON execution_step_execution_step_id_seq TO alter_squash_table_seq;

ALTER TABLE EXECUTION_STEP MODIFY EXECUTION_STEP_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR execution_step_execution_step_id_seq);

GRANT ALL ON exploratory_execution_event_event_id_seq TO alter_squash_table_seq;

ALTER TABLE EXPLORATORY_EXECUTION_EVENT MODIFY EVENT_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR exploratory_execution_event_event_id_seq);

GRANT ALL ON exploratory_session_overview_overview_id_seq TO alter_squash_table_seq;

ALTER TABLE EXPLORATORY_SESSION_OVERVIEW MODIFY OVERVIEW_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR exploratory_session_overview_overview_id_seq);

GRANT ALL ON failure_detail_failure_detail_id_seq TO alter_squash_table_seq;

ALTER TABLE FAILURE_DETAIL MODIFY FAILURE_DETAIL_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR failure_detail_failure_detail_id_seq);

GRANT ALL ON grid_column_display_configuration_gcdc_id_seq TO alter_squash_table_seq;

ALTER TABLE GRID_COLUMN_DISPLAY_CONFIGURATION MODIFY GCDC_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR grid_column_display_configuration_gcdc_id_seq);

GRANT ALL ON grid_column_display_reference_gcdr_id_seq TO alter_squash_table_seq;

ALTER TABLE GRID_COLUMN_DISPLAY_REFERENCE MODIFY GCDR_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR grid_column_display_reference_gcdr_id_seq);

GRANT ALL ON info_list_info_list_id_seq TO alter_squash_table_seq;

ALTER TABLE INFO_LIST MODIFY INFO_LIST_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR info_list_info_list_id_seq);

GRANT ALL ON info_list_item_item_id_seq TO alter_squash_table_seq;

ALTER TABLE INFO_LIST_ITEM MODIFY ITEM_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR info_list_item_item_id_seq);

GRANT ALL ON issue_issue_id_seq TO alter_squash_table_seq;

ALTER TABLE ISSUE MODIFY ISSUE_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR issue_issue_id_seq);

GRANT ALL ON issue_list_issue_list_id_seq TO alter_squash_table_seq;

ALTER TABLE ISSUE_LIST MODIFY ISSUE_LIST_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR issue_list_issue_list_id_seq);

GRANT ALL ON item_test_plan_item_test_plan_id_seq TO alter_squash_table_seq;

ALTER TABLE ITERATION_TEST_PLAN_ITEM MODIFY ITEM_TEST_PLAN_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR item_test_plan_item_test_plan_id_seq);

GRANT ALL ON iteration_iteration_id_seq TO alter_squash_table_seq;

ALTER TABLE ITERATION MODIFY ITERATION_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR iteration_iteration_id_seq);

GRANT ALL ON library_plugin_binding_plugin_binding_id_seq TO alter_squash_table_seq;

ALTER TABLE LIBRARY_PLUGIN_BINDING MODIFY PLUGIN_BINDING_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR library_plugin_binding_plugin_binding_id_seq);

GRANT ALL ON milestone_binding_milestone_binding_id_seq TO alter_squash_table_seq;

ALTER TABLE MILESTONE_BINDING MODIFY MILESTONE_BINDING_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR milestone_binding_milestone_binding_id_seq);

GRANT ALL ON milestone_binding_perimeter_milestone_binding_perimeter_id_seq TO alter_squash_table_seq;

ALTER TABLE MILESTONE_BINDING_PERIMETER MODIFY MILESTONE_BINDING_PERIMETER_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR milestone_binding_perimeter_milestone_binding_perimeter_id_seq);

GRANT ALL ON milestone_milestone_id_seq TO alter_squash_table_seq;

ALTER TABLE MILESTONE MODIFY MILESTONE_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR milestone_milestone_id_seq);

GRANT ALL ON parameter_param_id_seq TO alter_squash_table_seq;

ALTER TABLE PARAMETER MODIFY PARAM_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR parameter_param_id_seq);

GRANT ALL ON party_preference_preference_id_seq TO alter_squash_table_seq;

ALTER TABLE PARTY_PREFERENCE MODIFY PREFERENCE_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR party_preference_preference_id_seq);

GRANT ALL ON pivot_format_import_pfi_id_seq TO alter_squash_table_seq;

ALTER TABLE PIVOT_FORMAT_IMPORT MODIFY PFI_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR pivot_format_import_pfi_id_seq);

GRANT ALL ON project_filter_project_filter_id_seq TO alter_squash_table_seq;

ALTER TABLE PROJECT_FILTER MODIFY PROJECT_FILTER_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR project_filter_project_filter_id_seq);

GRANT ALL ON project_project_id_seq TO alter_squash_table_seq;

ALTER TABLE PROJECT MODIFY PROJECT_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR project_project_id_seq);

GRANT ALL ON proto_test_automation_project_ta_project_id_seq TO alter_squash_table_seq;

ALTER TABLE TEST_AUTOMATION_PROJECT MODIFY TA_PROJECT_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR proto_test_automation_project_ta_project_id_seq);

GRANT ALL ON query_column_prototype_query_column_id_seq TO alter_squash_table_seq;

ALTER TABLE QUERY_COLUMN_PROTOTYPE MODIFY QUERY_COLUMN_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR query_column_prototype_query_column_id_seq);

GRANT ALL ON query_filter_column_query_filter_id_seq TO alter_squash_table_seq;

ALTER TABLE QUERY_FILTER_COLUMN MODIFY QUERY_FILTER_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR query_filter_column_query_filter_id_seq);

GRANT ALL ON query_model_query_model_id_seq TO alter_squash_table_seq;

ALTER TABLE QUERY_MODEL MODIFY QUERY_MODEL_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR query_model_query_model_id_seq);

GRANT ALL ON remote_automation_request_ext_remote_automation_request_ext_seq TO alter_squash_table_seq;

ALTER TABLE REMOTE_AUTOMATION_REQUEST_EXTENDER MODIFY REMOTE_AUTOMATION_REQUEST_EXTENDER_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR remote_automation_request_ext_remote_automation_request_ext_seq);

GRANT ALL ON remote_synchronisation_remote_synchronisation_id_seq TO alter_squash_table_seq;

ALTER TABLE REMOTE_SYNCHRONISATION MODIFY REMOTE_SYNCHRONISATION_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR remote_synchronisation_remote_synchronisation_id_seq);

GRANT ALL ON report_definition_report_id_seq TO alter_squash_table_seq;

ALTER TABLE REPORT_DEFINITION MODIFY REPORT_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR report_definition_report_id_seq);

GRANT ALL ON requirement_audit_event_event_id_seq TO alter_squash_table_seq;

ALTER TABLE REQUIREMENT_AUDIT_EVENT MODIFY EVENT_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR requirement_audit_event_event_id_seq);

GRANT ALL ON requirement_folder_sync_extender_rf_sync_extender_id_seq TO alter_squash_table_seq;

ALTER TABLE REQUIREMENT_FOLDER_SYNC_EXTENDER MODIFY RF_SYNC_EXTENDER_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR requirement_folder_sync_extender_rf_sync_extender_id_seq);

GRANT ALL ON requirement_library_node_rln_id_seq TO alter_squash_table_seq;

ALTER TABLE REQUIREMENT_LIBRARY_NODE MODIFY RLN_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR requirement_library_node_rln_id_seq);

GRANT ALL ON requirement_library_rl_id_seq TO alter_squash_table_seq;

ALTER TABLE REQUIREMENT_LIBRARY MODIFY RL_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR requirement_library_rl_id_seq);

GRANT ALL ON requirement_sync_extender_req_sync_id_seq TO alter_squash_table_seq;

ALTER TABLE REQUIREMENT_SYNC_EXTENDER MODIFY REQ_SYNC_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR requirement_sync_extender_req_sync_id_seq);

GRANT ALL ON requirement_version_coverage_requirement_version_coverage_i_seq TO alter_squash_table_seq;

ALTER TABLE REQUIREMENT_VERSION_COVERAGE MODIFY REQUIREMENT_VERSION_COVERAGE_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR requirement_version_coverage_requirement_version_coverage_i_seq);

GRANT ALL ON requirement_version_link_link_id_seq TO alter_squash_table_seq;

ALTER TABLE REQUIREMENT_VERSION_LINK MODIFY LINK_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR requirement_version_link_link_id_seq);

GRANT ALL ON requirement_version_link_type_type_id_seq TO alter_squash_table_seq;

ALTER TABLE REQUIREMENT_VERSION_LINK_TYPE MODIFY TYPE_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR requirement_version_link_type_type_id_seq);

GRANT ALL ON resource_res_id_seq TO alter_squash_table_seq;

ALTER TABLE RESOURCE MODIFY RES_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR resource_res_id_seq);

GRANT ALL ON scm_repository_scm_repository_id_seq TO alter_squash_table_seq;

ALTER TABLE SCM_REPOSITORY MODIFY SCM_REPOSITORY_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR scm_repository_scm_repository_id_seq);

GRANT ALL ON session_note_note_id_seq TO alter_squash_table_seq;

ALTER TABLE SESSION_NOTE MODIFY NOTE_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR session_note_note_id_seq);

GRANT ALL ON sprint_req_version_sprint_req_version_id_seq TO alter_squash_table_seq;

ALTER TABLE SPRINT_REQ_VERSION MODIFY SPRINT_REQ_VERSION_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR sprint_req_version_sprint_req_version_id_seq);

GRANT ALL ON sprint_requirement_sync_extender_sprint_req_sync_id_seq TO alter_squash_table_seq;

ALTER TABLE SPRINT_REQUIREMENT_SYNC_EXTENDER MODIFY SPRINT_REQ_SYNC_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR sprint_requirement_sync_extender_sprint_req_sync_id_seq);

GRANT ALL ON stored_credentials_credential_id_seq TO alter_squash_table_seq;

ALTER TABLE STORED_CREDENTIALS MODIFY CREDENTIAL_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR stored_credentials_credential_id_seq);

GRANT ALL ON template_configurable_plugin_binding_binding_id_seq TO alter_squash_table_seq;

ALTER TABLE TEMPLATE_CONFIGURABLE_PLUGIN_BINDING MODIFY BINDING_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR template_configurable_plugin_binding_binding_id_seq);

GRANT ALL ON test_case_library_node_tcln_id_seq TO alter_squash_table_seq;

ALTER TABLE TEST_CASE_LIBRARY_NODE MODIFY TCLN_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR test_case_library_node_tcln_id_seq);

GRANT ALL ON test_case_library_tcl_id_seq TO alter_squash_table_seq;

ALTER TABLE TEST_CASE_LIBRARY MODIFY TCL_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR test_case_library_tcl_id_seq);

GRANT ALL ON test_plan_item_test_plan_item_id_seq TO alter_squash_table_seq;

ALTER TABLE TEST_PLAN_ITEM MODIFY TEST_PLAN_ITEM_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR test_plan_item_test_plan_item_id_seq);

GRANT ALL ON test_plan_test_plan_id_seq TO alter_squash_table_seq;

ALTER TABLE TEST_PLAN MODIFY TEST_PLAN_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR test_plan_test_plan_id_seq);

GRANT ALL ON test_step_test_step_id_seq TO alter_squash_table_seq;

ALTER TABLE TEST_STEP MODIFY TEST_STEP_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR test_step_test_step_id_seq);

GRANT ALL ON test_suite_id_seq TO alter_squash_table_seq;

ALTER TABLE TEST_SUITE MODIFY ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR test_suite_id_seq);

GRANT ALL ON third_party_server_server_id_seq TO alter_squash_table_seq;

ALTER TABLE THIRD_PARTY_SERVER MODIFY SERVER_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR third_party_server_server_id_seq);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-grant-sequence-and-change-id-auto-increment-to-sequence-nextvalue', 'pguygot', 'tm/tm.changelog-10.0.0.xml', NOW(), 4, '9:67cab24e23e4f28a48e3ba3681036f2c', 'sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sq...', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-drop-automated_suite_workflows-foreign-key::ssviridov
ALTER TABLE AUTOMATED_SUITE_WORKFLOWS DROP FOREIGN KEY fk_automated_suite_workflows_suite_id;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-drop-automated_suite_workflows-foreign-key', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 5, '9:afb4edaf144aeffd70beb90b462167cd', 'dropForeignKeyConstraint baseTableName=AUTOMATED_SUITE_WORKFLOWS, constraintName=fk_automated_suite_workflows_suite_id', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-drop-automated_execution_extender-foreign-key::ssviridov
ALTER TABLE AUTOMATED_EXECUTION_EXTENDER DROP FOREIGN KEY fk_auto_exec_suite;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-drop-automated_execution_extender-foreign-key', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 6, '9:51cd90365b7ebad8c0859c376087c078', 'dropForeignKeyConstraint baseTableName=AUTOMATED_EXECUTION_EXTENDER, constraintName=fk_auto_exec_suite', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-create-uuid-column::ssviridov
ALTER TABLE AUTOMATED_SUITE ADD UUID VARCHAR(50) NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-create-uuid-column', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 7, '9:415c6e5bfb1a4a8dc6fc2ff99de280a2', 'addColumn tableName=AUTOMATED_SUITE', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-migrate-data-to-uuid-column::ssviridov
UPDATE AUTOMATED_SUITE SET UUID = SUITE_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-migrate-data-to-uuid-column', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 8, '9:248a4df5b7a03816eb207ddfcfb34139', 'update tableName=AUTOMATED_SUITE', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-replace-varchar-suite_id-column-by-bigint-suite_id-column-in-automated_suites::ssviridov
ALTER TABLE AUTOMATED_SUITE DROP COLUMN SUITE_ID;

ALTER TABLE AUTOMATED_SUITE ADD SUITE_ID BIGINT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-replace-varchar-suite_id-column-by-bigint-suite_id-column-in-automated_suites', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 9, '9:1d795624d2736c2aa1528cd0b1f7afe0', 'dropColumn columnName=SUITE_ID, tableName=AUTOMATED_SUITE; addColumn tableName=AUTOMATED_SUITE', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-populate-suite-id-maria::ssviridov
CREATE SEQUENCE TEMP_SEQUENCE
        INCREMENT BY 1 START WITH 1;

UPDATE AUTOMATED_SUITE SET SUITE_ID = NEXTVAL(TEMP_SEQUENCE);

DROP SEQUENCE TEMP_SEQUENCE;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-populate-suite-id-maria', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 10, '9:88fc9f694d325649708bae29bd07b17f', 'sql; sql; sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-suite-id-primary-key::ssviridov
ALTER TABLE AUTOMATED_SUITE MODIFY SUITE_ID BIGINT NOT NULL;

ALTER TABLE AUTOMATED_SUITE ADD PRIMARY KEY (SUITE_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-suite-id-primary-key', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 11, '9:5fc100e3d7ac7e379e5c12692a160c73', 'addNotNullConstraint columnName=SUITE_ID, tableName=AUTOMATED_SUITE; addPrimaryKey constraintName=pk_automated_suite, tableName=AUTOMATED_SUITE', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-rename-suite_id-column-to-uuid-and-create-a-bigint-suite_id-column-in-automated_suite_workflows::ssviridov
ALTER TABLE AUTOMATED_SUITE_WORKFLOWS CHANGE SUITE_ID UUID VARCHAR(50);

ALTER TABLE AUTOMATED_SUITE_WORKFLOWS ADD SUITE_ID BIGINT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-rename-suite_id-column-to-uuid-and-create-a-bigint-suite_id-column-in-automated_suite_workflows', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 12, '9:ec3dc24946bb776d421bedf0ff860062', 'renameColumn newColumnName=UUID, oldColumnName=SUITE_ID, tableName=AUTOMATED_SUITE_WORKFLOWS; addColumn tableName=AUTOMATED_SUITE_WORKFLOWS', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-rename-suite_id-column-to-uuid-and-create-a-bigint-suite_id-column-in-automated_execution_extender::ssviridov
ALTER TABLE AUTOMATED_EXECUTION_EXTENDER CHANGE SUITE_ID UUID VARCHAR(50);

ALTER TABLE AUTOMATED_EXECUTION_EXTENDER ADD SUITE_ID BIGINT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-rename-suite_id-column-to-uuid-and-create-a-bigint-suite_id-column-in-automated_execution_extender', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 13, '9:25c3b59a0b5e356dec93b59671cf618d', 'renameColumn newColumnName=UUID, oldColumnName=SUITE_ID, tableName=AUTOMATED_EXECUTION_EXTENDER; addColumn tableName=AUTOMATED_EXECUTION_EXTENDER', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-update-automated_suite-constraints::ssviridov
ALTER TABLE AUTOMATED_SUITE ADD CONSTRAINT uq_automated_suite_uuid UNIQUE (UUID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-update-automated_suite-constraints', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 14, '9:a5597c31763134fc900117f0ce7622b8', 'addUniqueConstraint constraintName=uq_automated_suite_uuid, tableName=AUTOMATED_SUITE', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-fill-out-suite_id-column-in-automated_suite_workflows-based-on-existing-references-h2-mariadb::ssviridov
UPDATE AUTOMATED_SUITE_WORKFLOWS SET suite_id = ( SELECT AUTOMATED_SUITE.suite_id FROM AUTOMATED_SUITE WHERE AUTOMATED_SUITE_WORKFLOWS.uuid = AUTOMATED_SUITE.uuid);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-fill-out-suite_id-column-in-automated_suite_workflows-based-on-existing-references-h2-mariadb', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 15, '9:43574ad57f7c95bc228617ad9d56db00', 'sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-fill-out-suite_id-column-in-automated_execution_extender-based-on-existing-references-h2-mariadb::ssviridov
UPDATE AUTOMATED_EXECUTION_EXTENDER SET suite_id = ( SELECT AUTOMATED_SUITE.suite_id FROM AUTOMATED_SUITE WHERE AUTOMATED_EXECUTION_EXTENDER.uuid = AUTOMATED_SUITE.uuid);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-fill-out-suite_id-column-in-automated_execution_extender-based-on-existing-references-h2-mariadb', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 16, '9:08470b0ba17f6bd1c443feeebbb11d34', 'sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-suite_id-fk-constraint-index-to-automated_suite_workflows::ssviridov
CREATE INDEX idx_fk_automated_suite_workflows_suite_id ON AUTOMATED_SUITE_WORKFLOWS(SUITE_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-suite_id-fk-constraint-index-to-automated_suite_workflows', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 17, '9:43252ff1bdc9b52d8a91c8916764ee2c', 'createIndex indexName=idx_fk_automated_suite_workflows_suite_id, tableName=AUTOMATED_SUITE_WORKFLOWS', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-suite_id-fk-constraint-index-to-automated_execution_extender::ssviridov
CREATE INDEX idx_fk_automated_execution_extender_suite_id ON AUTOMATED_EXECUTION_EXTENDER(SUITE_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-suite_id-fk-constraint-index-to-automated_execution_extender', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 18, '9:a9ff19ce080f815180e3485f3d33457b', 'createIndex indexName=idx_fk_automated_execution_extender_suite_id, tableName=AUTOMATED_EXECUTION_EXTENDER', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-suite_id-fk-constraint-to-automated_suite_workflows::ssviridov
ALTER TABLE AUTOMATED_SUITE_WORKFLOWS ADD CONSTRAINT fk_automated_suite_workflows_automated_suite FOREIGN KEY (SUITE_ID) REFERENCES AUTOMATED_SUITE (SUITE_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-suite_id-fk-constraint-to-automated_suite_workflows', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 19, '9:bd0c9a55b1da9f652de6143b849d1e7d', 'addForeignKeyConstraint baseTableName=AUTOMATED_SUITE_WORKFLOWS, constraintName=fk_automated_suite_workflows_automated_suite, referencedTableName=AUTOMATED_SUITE', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-suite_id-fk-constraint-to-automated_execution_extender::ssviridov
ALTER TABLE AUTOMATED_EXECUTION_EXTENDER ADD CONSTRAINT fk_automated_execution_extender_automated_suite FOREIGN KEY (SUITE_ID) REFERENCES AUTOMATED_SUITE (SUITE_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-suite_id-fk-constraint-to-automated_execution_extender', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 20, '9:4d321ab3c02545affd02205c2c565370', 'addForeignKeyConstraint baseTableName=AUTOMATED_EXECUTION_EXTENDER, constraintName=fk_automated_execution_extender_automated_suite, referencedTableName=AUTOMATED_SUITE', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-drop-uuid-column-in-automated_suite_workflows::ssviridov
ALTER TABLE AUTOMATED_SUITE_WORKFLOWS DROP COLUMN UUID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-drop-uuid-column-in-automated_suite_workflows', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 21, '9:7022bc31160990571dfc0a0408297ee7', 'dropColumn columnName=UUID, tableName=AUTOMATED_SUITE_WORKFLOWS', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-drop-uuid-column-in-automated_execution_extender::ssviridov
ALTER TABLE AUTOMATED_EXECUTION_EXTENDER DROP COLUMN UUID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-drop-uuid-column-in-automated_execution_extender', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 22, '9:710cf945d3ab462aca7b6d2c4b979046', 'dropColumn columnName=UUID, tableName=AUTOMATED_EXECUTION_EXTENDER', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-create-sequence-for-suite_id-maria::ssviridov
SET @startvalue = (SELECT COALESCE(MAX(suite_id), 0) + 1 FROM AUTOMATED_SUITE);

DROP SEQUENCE IF EXISTS automated_suite_suite_id_seq;

SET @altersql = CONCAT('CREATE SEQUENCE automated_suite_suite_id_seq START WITH ', @startvalue, ' INCREMENT BY 1');

PREPARE stmt FROM @altersql;

EXECUTE stmt;

DEALLOCATE PREPARE stmt;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-create-sequence-for-suite_id-maria', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 23, '9:aa683a15d204c1cc1a9cb41eefad2cab', 'sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-link-sequence-to-pk-column-mariadb::ssviridov
GRANT ALL ON automated_suite_suite_id_seq TO alter_squash_table_seq;

ALTER TABLE AUTOMATED_SUITE MODIFY SUITE_ID BIGINT NOT NULL DEFAULT (NEXT VALUE FOR automated_suite_suite_id_seq);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-link-sequence-to-pk-column-mariadb', 'ssviridov', 'tm/tm.changelog-10.0.0.xml', NOW(), 24, '9:059dc15bf86bb49af02ef1b695a36af0', 'sql; sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-create-tmp_executions_to_delete::pckerneis
CREATE TABLE TMP_EXECUTIONS_TO_DELETE (EXECUTION_ID BIGINT NULL);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-create-tmp_executions_to_delete', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 25, '9:83d158dd232e6fff162886c273857bd1', 'createTable tableName=TMP_EXECUTIONS_TO_DELETE', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-truncate-tmp_executions_to_delete::pckerneis
TRUNCATE TABLE TMP_EXECUTIONS_TO_DELETE;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-truncate-tmp_executions_to_delete', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 26, '9:0b871fa255e9370143292962bccd6cf8', 'sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-create-TMP_ORPHAN_ITERATIONS-table::pckerneis
CREATE TABLE TMP_ORPHAN_ITERATIONS (ITERATION_ID BIGINT NULL);

CREATE INDEX idx_tmp_orphan_iterations_iteration_id ON TMP_ORPHAN_ITERATIONS(ITERATION_ID);

TRUNCATE TABLE TMP_ORPHAN_ITERATIONS;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-create-TMP_ORPHAN_ITERATIONS-table', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 27, '9:c174f36df862133afbbff1d144439583', 'createTable tableName=TMP_ORPHAN_ITERATIONS; createIndex indexName=idx_tmp_orphan_iterations_iteration_id, tableName=TMP_ORPHAN_ITERATIONS; sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-create-TMP_ORPHAN_AUTOMATED_SUITE-table::pckerneis
CREATE TABLE TMP_ORPHAN_AUTOMATED_SUITE (SUITE_ID BIGINT NULL);

CREATE INDEX idx_tmp_orphan_automated_suite_suite_id ON TMP_ORPHAN_AUTOMATED_SUITE(SUITE_ID);

TRUNCATE TABLE TMP_ORPHAN_AUTOMATED_SUITE;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-create-TMP_ORPHAN_AUTOMATED_SUITE-table', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 28, '9:bcb2ba5415b3ce98c9034995344226a7', 'createTable tableName=TMP_ORPHAN_AUTOMATED_SUITE; createIndex indexName=idx_tmp_orphan_automated_suite_suite_id, tableName=TMP_ORPHAN_AUTOMATED_SUITE; sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-remove-orphan-iterations-and-automated-suites::pckerneis
INSERT INTO TMP_ORPHAN_ITERATIONS SELECT DISTINCT a.ITERATION_ID
      FROM ITERATION a LEFT JOIN CAMPAIGN_ITERATION b ON a.ITERATION_ID = b.ITERATION_ID
      WHERE b.ITERATION_ID IS NULL;

INSERT INTO TMP_ORPHAN_AUTOMATED_SUITE SELECT DISTINCT SUITE_ID
      FROM AUTOMATED_SUITE a JOIN TMP_ORPHAN_ITERATIONS b ON a.ITERATION_ID = b.ITERATION_ID;

DELETE FROM ITERATION_TEST_SUITE
      WHERE ITERATION_ID IN (SELECT ITERATION_ID FROM TMP_ORPHAN_ITERATIONS);

DELETE FROM ITEM_TEST_PLAN_LIST
      WHERE ITERATION_ID IN (SELECT ITERATION_ID FROM TMP_ORPHAN_ITERATIONS);

DELETE FROM AUTOMATED_EXECUTION_FAILURE_DETAIL
      WHERE EXECUTION_EXTENDER_ID IN (SELECT DISTINCT EXTENDER_ID
                                      FROM AUTOMATED_EXECUTION_EXTENDER a JOIN TMP_ORPHAN_AUTOMATED_SUITE b ON a.SUITE_ID = b.SUITE_ID);

DELETE FROM FAILURE_DETAIL
      WHERE FAILURE_DETAIL_ID NOT IN (SELECT DISTINCT FAILURE_DETAIL_ID
                                      FROM AUTOMATED_EXECUTION_FAILURE_DETAIL);

DELETE FROM AUTOMATED_EXECUTION_EXTENDER
      WHERE SUITE_ID IN (SELECT SUITE_ID
                         FROM TMP_ORPHAN_AUTOMATED_SUITE);

DELETE FROM AUTOMATED_SUITE_WORKFLOWS
      WHERE SUITE_ID IN (SELECT SUITE_ID
                         FROM TMP_ORPHAN_AUTOMATED_SUITE);

DELETE FROM ITERATION
      WHERE ITERATION_ID IN (SELECT ITERATION_ID
                             FROM TMP_ORPHAN_ITERATIONS);

DROP TABLE IF EXISTS TMP_ORPHAN_ITERATIONS;

DROP TABLE IF EXISTS TMP_ORPHAN_AUTOMATED_SUITE;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-remove-orphan-iterations-and-automated-suites', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 29, '9:275fbb14bc855d2051f7038c26819c09', 'sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-fill-tmp_executions_to_delete::pckerneis
INSERT INTO TMP_EXECUTIONS_TO_DELETE SELECT a.EXECUTION_ID
      FROM EXECUTION a
             LEFT JOIN ITEM_TEST_PLAN_EXECUTION b on a.EXECUTION_ID = b.EXECUTION_ID
             LEFT JOIN ITEM_TEST_PLAN_LIST c on b.ITEM_TEST_PLAN_ID = c.ITEM_TEST_PLAN_ID
      WHERE a.TEST_PLAN_ITEM_ID IS NULL
        AND c.ITERATION_ID IS NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-fill-tmp_executions_to_delete', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 30, '9:d50b8daba29d16d54272f14594530712', 'sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-delete-orphan-executions::pckerneis
DELETE FROM AUTOMATED_EXECUTION_FAILURE_DETAIL
      WHERE EXECUTION_EXTENDER_ID IN (SELECT EXTENDER_ID FROM AUTOMATED_EXECUTION_EXTENDER JOIN TMP_EXECUTIONS_TO_DELETE ON MASTER_EXECUTION_ID = EXECUTION_ID);

DELETE FROM AUTOMATED_EXECUTION_EXTENDER
      WHERE MASTER_EXECUTION_ID IN (SELECT EXECUTION_ID FROM TMP_EXECUTIONS_TO_DELETE);

DELETE FROM EXPLORATORY_EXECUTION_EVENT
      WHERE EXECUTION_ID IN (SELECT EXECUTION_ID FROM TMP_EXECUTIONS_TO_DELETE);

DELETE FROM EXPLORATORY_EXECUTION
      WHERE EXECUTION_ID IN (SELECT EXECUTION_ID FROM TMP_EXECUTIONS_TO_DELETE);

DELETE FROM KEYWORD_EXECUTION
      WHERE EXECUTION_ID IN (SELECT EXECUTION_ID FROM TMP_EXECUTIONS_TO_DELETE);

DELETE FROM SCRIPTED_EXECUTION
      WHERE EXECUTION_ID IN (SELECT EXECUTION_ID FROM TMP_EXECUTIONS_TO_DELETE);

DELETE FROM SESSION_NOTE
      WHERE EXECUTION_ID IN (SELECT EXECUTION_ID FROM TMP_EXECUTIONS_TO_DELETE);

DELETE FROM EXECUTION_EXECUTION_STEPS
      WHERE EXECUTION_ID IN (SELECT EXECUTION_ID FROM TMP_EXECUTIONS_TO_DELETE);

DELETE a FROM EXECUTION_STEP a LEFT JOIN EXECUTION_EXECUTION_STEPS b ON a.EXECUTION_STEP_ID = b.EXECUTION_STEP_ID
      WHERE b.EXECUTION_STEP_ID IS NULL;

DELETE FROM ITEM_TEST_PLAN_EXECUTION
      WHERE EXECUTION_ID IN (SELECT EXECUTION_ID FROM TMP_EXECUTIONS_TO_DELETE);

DELETE FROM EXECUTION
      WHERE EXECUTION_ID IN (SELECT EXECUTION_ID FROM TMP_EXECUTIONS_TO_DELETE);

DELETE a FROM CUSTOM_FIELD_VALUE a LEFT JOIN EXECUTION b ON a.BOUND_ENTITY_ID = b.EXECUTION_ID
      WHERE b.EXECUTION_ID IS NULL AND a.BOUND_ENTITY_TYPE = 'EXECUTION';

DELETE a FROM CUSTOM_FIELD_VALUE a LEFT JOIN EXECUTION_STEP b ON a.BOUND_ENTITY_ID = b.EXECUTION_STEP_ID
      WHERE b.EXECUTION_STEP_ID IS NULL AND a.BOUND_ENTITY_TYPE = 'EXECUTION_STEP';

DELETE a FROM DENORMALIZED_FIELD_VALUE a LEFT JOIN EXECUTION b ON a.DENORMALIZED_FIELD_HOLDER_ID = b.EXECUTION_ID
      WHERE b.EXECUTION_ID IS NULL AND a.DENORMALIZED_FIELD_HOLDER_TYPE = 'EXECUTION';

DELETE a FROM DENORMALIZED_FIELD_VALUE a LEFT JOIN EXECUTION_STEP b ON a.DENORMALIZED_FIELD_HOLDER_ID = b.EXECUTION_STEP_ID
      WHERE b.EXECUTION_STEP_ID IS NULL AND a.DENORMALIZED_FIELD_HOLDER_TYPE = 'EXECUTION_STEP';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-delete-orphan-executions', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 31, '9:bb1e9a8a95d118c52ad694907b20d78e', 'sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-drop-tmp_executions_to_delete::pckerneis
DROP TABLE TMP_EXECUTIONS_TO_DELETE;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-drop-tmp_executions_to_delete', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 32, '9:ebe89a0d616725c274b4099cbe3f4bf4', 'dropTable tableName=TMP_EXECUTIONS_TO_DELETE', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-iteration-testplan::pckerneis
ALTER TABLE ITERATION ADD TEST_PLAN_ID BIGINT NULL;

ALTER TABLE ITERATION ADD CONSTRAINT fk_iteration_test_plan FOREIGN KEY (TEST_PLAN_ID) REFERENCES TEST_PLAN (TEST_PLAN_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-iteration-testplan', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 33, '9:cc0756d81bf56192693c7bc1f30a77b2', 'addColumn tableName=ITERATION', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-index-on-iteration.test_plan_id::pckerneis
CREATE INDEX idx_iteration_test_plan_id ON ITERATION(TEST_PLAN_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-index-on-iteration.test_plan_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 34, '9:7e02cec576c7ba3e00362f7d4bcdd774', 'createIndex indexName=idx_iteration_test_plan_id, tableName=ITERATION', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-test_plan.tmp_iteration_id::pckerneis
ALTER TABLE TEST_PLAN ADD TMP_ITERATION_ID BIGINT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-test_plan.tmp_iteration_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 35, '9:958c4d63ce8bc5dcb7baed32dfd4e7af', 'addColumn tableName=TEST_PLAN', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-index-for-test_plan.tmp_iteration_id::pckerneis
CREATE INDEX idx_test_plan_tmp_iteration_id ON TEST_PLAN(TMP_ITERATION_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-index-for-test_plan.tmp_iteration_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 36, '9:9f102b53a6efdcd41348781d4d7792b8', 'createIndex indexName=idx_test_plan_tmp_iteration_id, tableName=TEST_PLAN', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-create-iteration-test-plans::pckerneis
INSERT INTO TEST_PLAN (CL_ID, TMP_ITERATION_ID)
      SELECT PROJECT.CL_ID, ITERATION.ITERATION_ID
      FROM ITERATION
        JOIN CAMPAIGN_ITERATION ON ITERATION.ITERATION_ID = CAMPAIGN_ITERATION.ITERATION_ID
        JOIN CAMPAIGN_LIBRARY_NODE ON CAMPAIGN_ITERATION.CAMPAIGN_ID = CAMPAIGN_LIBRARY_NODE.CLN_ID
        JOIN PROJECT ON CAMPAIGN_LIBRARY_NODE.PROJECT_ID = PROJECT.PROJECT_ID
      WHERE TEST_PLAN_ID IS NULL;

UPDATE ITERATION
      SET TEST_PLAN_ID = (
        SELECT TEST_PLAN_ID
        FROM TEST_PLAN
        WHERE TMP_ITERATION_ID = ITERATION.ITERATION_ID
      );

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-create-iteration-test-plans', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 37, '9:d130fc9a5d9be9ae377e145dfcb1ce6d', 'sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-drop-test_plan.tmp_iteration_id::pckerneis
ALTER TABLE TEST_PLAN DROP COLUMN TMP_ITERATION_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-drop-test_plan.tmp_iteration_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 38, '9:92f14b8bde955b1544accc5892636dd6', 'dropColumn columnName=TMP_ITERATION_ID, tableName=TEST_PLAN', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-non-nullable-constraint-to-iteration-test_plan_id::pckerneis
ALTER TABLE ITERATION MODIFY TEST_PLAN_ID BIGINT NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-non-nullable-constraint-to-iteration-test_plan_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 39, '9:7fa828dab7adb3b81f097bb8e7d15514', 'addNotNullConstraint columnName=TEST_PLAN_ID, tableName=ITERATION', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-test_plan_item.tmp_itpi_id::pckerneis
ALTER TABLE TEST_PLAN_ITEM ADD TMP_ITPI_ID BIGINT NULL;

ALTER TABLE TEST_PLAN_ITEM ADD CONSTRAINT fk_test_plan_item_iteration_test_plan_item FOREIGN KEY (TMP_ITPI_ID) REFERENCES ITERATION_TEST_PLAN_ITEM (ITEM_TEST_PLAN_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-test_plan_item.tmp_itpi_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 40, '9:4ad56115e6250cf6282e74c9927a5aa8', 'addColumn tableName=TEST_PLAN_ITEM', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-index-for-test_plan_item.tmp_itpi_id::pckerneis
CREATE INDEX idx_test_plan_item_tmp_itpi_id ON TEST_PLAN_ITEM(TMP_ITPI_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-index-for-test_plan_item.tmp_itpi_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 41, '9:c89cd93093a6822e4cd4489d807dfe40', 'createIndex indexName=idx_test_plan_item_tmp_itpi_id, tableName=TEST_PLAN_ITEM', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-migrate-iteration-test-plan-item::pckerneis
INSERT INTO TEST_PLAN_ITEM (
          TMP_ITPI_ID,
          TEST_PLAN_ID,
          ITEM_ORDER,
          EXECUTION_STATUS,
          LAST_EXECUTED_BY,
          LAST_EXECUTED_ON,
          TCLN_ID,
          DATASET_ID,
          LABEL,
          ASSIGNEE_ID,
          CREATED_BY,
          CREATED_ON,
          LAST_MODIFIED_BY,
          LAST_MODIFIED_ON
      ) SELECT
          itpi.ITEM_TEST_PLAN_ID,
          i.TEST_PLAN_ID,
          itpl.ITEM_TEST_PLAN_ORDER,
          itpi.EXECUTION_STATUS,
          itpi.LAST_EXECUTED_BY,
          itpi.LAST_EXECUTED_ON,
          itpi.TCLN_ID,
          itpi.DATASET_ID,
          itpi.LABEL,
          itpi.USER_ID,
          itpi.CREATED_BY,
          itpi.CREATED_ON,
          itpi.LAST_MODIFIED_BY,
          itpi.LAST_MODIFIED_ON
        FROM ITERATION_TEST_PLAN_ITEM itpi
        JOIN ITEM_TEST_PLAN_LIST itpl ON itpi.ITEM_TEST_PLAN_ID = itpl.ITEM_TEST_PLAN_ID
        JOIN ITERATION i ON itpl.ITERATION_ID = i.ITERATION_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-migrate-iteration-test-plan-item', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 42, '9:235da7541a83c7c816a240256043b5be', 'sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-analyze-tables-for-execution-update::jprioux
ANALYZE TABLE TEST_PLAN_ITEM;

ANALYZE TABLE EXECUTION;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-analyze-tables-for-execution-update', 'jprioux', 'tm/tm.changelog-10.0.0.xml', NOW(), 43, '9:9cdd9eff76d6b38892f68f8a6e6fdd99', 'sql; sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-migrate-iteration-executions::pckerneis
UPDATE EXECUTION e
      SET
        TEST_PLAN_ITEM_ID = (
          SELECT tpi.TEST_PLAN_ITEM_ID
          FROM TEST_PLAN_ITEM tpi
          JOIN ITEM_TEST_PLAN_EXECUTION itpe ON tpi.TMP_ITPI_ID = itpe.ITEM_TEST_PLAN_ID
          WHERE itpe.EXECUTION_ID = e.EXECUTION_ID
        ),
        EXECUTION_ORDER = (
          SELECT itpe.EXECUTION_ORDER
          FROM TEST_PLAN_ITEM tpi
          JOIN ITEM_TEST_PLAN_EXECUTION itpe ON tpi.TMP_ITPI_ID = itpe.ITEM_TEST_PLAN_ID
          WHERE itpe.EXECUTION_ID = e.EXECUTION_ID
        )
      WHERE e.TEST_PLAN_ITEM_ID IS NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-migrate-iteration-executions', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 44, '9:850a27a201bf9d8446e10328124b3320', 'sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-unique-constraint-on-execution_order::pckerneis
ALTER TABLE EXECUTION ADD CONSTRAINT uq_execution_execution_order_test_plan_item_id UNIQUE (EXECUTION_ORDER, TEST_PLAN_ITEM_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-unique-constraint-on-execution_order', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 45, '9:ef983d749257e95a585e42be3230b600', 'addUniqueConstraint constraintName=uq_execution_execution_order_test_plan_item_id, tableName=EXECUTION', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-non-nullable-constraint-to-execution-test_plan_item_id-and-execution_order::pckerneis
ALTER TABLE EXECUTION MODIFY TEST_PLAN_ITEM_ID BIGINT NOT NULL;

ALTER TABLE EXECUTION MODIFY EXECUTION_ORDER INT NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-non-nullable-constraint-to-execution-test_plan_item_id-and-execution_order', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 46, '9:b096107ab1c19dad998a54c4a8faa922', 'addNotNullConstraint columnName=TEST_PLAN_ITEM_ID, tableName=EXECUTION; addNotNullConstraint columnName=EXECUTION_ORDER, tableName=EXECUTION', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-drop-test_suite_test_plan_item-fk::pckerneis
ALTER TABLE TEST_SUITE_TEST_PLAN_ITEM DROP FOREIGN KEY fk_test_suite_test_plan_item_test_plan_item;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-drop-test_suite_test_plan_item-fk', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 47, '9:90ca8cb64e72a7fd92a178d6cd3e7424', 'dropForeignKeyConstraint baseTableName=TEST_SUITE_TEST_PLAN_ITEM, constraintName=fk_test_suite_test_plan_item_test_plan_item', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-migrate-test-suite-data::pckerneis
UPDATE TEST_SUITE_TEST_PLAN_ITEM item
      SET TPI_ID = (
        SELECT tpi.TEST_PLAN_ITEM_ID
        FROM TEST_PLAN_ITEM tpi
        JOIN TEST_SUITE_TEST_PLAN_ITEM tstpi ON tpi.TMP_ITPI_ID = tstpi.TPI_ID
        WHERE tstpi.SUITE_ID = item.SUITE_ID AND tstpi.TEST_PLAN_ORDER = item.TEST_PLAN_ORDER
      );

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-migrate-test-suite-data', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 48, '9:fd99b2a4eb9c7e9fef750fc7f94cc737', 'sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-migrate-test-suite-item-fk::pckerneis
ALTER TABLE TEST_SUITE_TEST_PLAN_ITEM ADD CONSTRAINT fk_test_suite_test_plan_item_test_plan_item FOREIGN KEY (TPI_ID) REFERENCES TEST_PLAN_ITEM (TEST_PLAN_ITEM_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-migrate-test-suite-item-fk', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 49, '9:08549324b419e68cf670433c42609a79', 'addForeignKeyConstraint baseTableName=TEST_SUITE_TEST_PLAN_ITEM, constraintName=fk_test_suite_test_plan_item_test_plan_item, referencedTableName=TEST_PLAN_ITEM', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-rename-failure_detail.item_test_plan_id-and-drop-fk::pckerneis
ALTER TABLE FAILURE_DETAIL DROP FOREIGN KEY fk_failure_detail_itpi_id;

ALTER TABLE FAILURE_DETAIL CHANGE ITEM_TEST_PLAN_ID TEST_PLAN_ITEM_ID BIGINT;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-rename-failure_detail.item_test_plan_id-and-drop-fk', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 50, '9:fec6c79158543e0987b769116d89ffb8', 'dropForeignKeyConstraint baseTableName=FAILURE_DETAIL, constraintName=fk_failure_detail_itpi_id; renameColumn newColumnName=TEST_PLAN_ITEM_ID, oldColumnName=ITEM_TEST_PLAN_ID, tableName=FAILURE_DETAIL', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-migrate-failure_detail-data::pckerneis
UPDATE FAILURE_DETAIL fd
      SET TEST_PLAN_ITEM_ID = (
        SELECT tpi.TEST_PLAN_ITEM_ID
        FROM TEST_PLAN_ITEM tpi
        JOIN FAILURE_DETAIL fd2 ON tpi.TMP_ITPI_ID = fd2.TEST_PLAN_ITEM_ID
        WHERE fd2.FAILURE_DETAIL_ID = fd.FAILURE_DETAIL_ID
      );

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-migrate-failure_detail-data', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 51, '9:c36d859a5cb225ab794c39b634d7b500', 'sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-fk-to-failure_detail.test_plan_item_id::pckerneis
ALTER TABLE FAILURE_DETAIL ADD CONSTRAINT fk_failure_detail_test_plan_item FOREIGN KEY (TEST_PLAN_ITEM_ID) REFERENCES TEST_PLAN_ITEM (TEST_PLAN_ITEM_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-fk-to-failure_detail.test_plan_item_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 52, '9:20f178830835abe5f5de2e6c164444a7', 'addForeignKeyConstraint baseTableName=FAILURE_DETAIL, constraintName=fk_failure_detail_test_plan_item, referencedTableName=TEST_PLAN_ITEM', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-create-test_plan_item.overview_id::pckerneis
ALTER TABLE TEST_PLAN_ITEM ADD OVERVIEW_ID BIGINT NULL;

ALTER TABLE TEST_PLAN_ITEM ADD CONSTRAINT fk_test_plan_item_exploratory_session_overview FOREIGN KEY (OVERVIEW_ID) REFERENCES EXPLORATORY_SESSION_OVERVIEW (OVERVIEW_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-create-test_plan_item.overview_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 53, '9:8f21e6422ab33af99a868b82361b89d2', 'addColumn tableName=TEST_PLAN_ITEM', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-index-on-test_plan_item.overview_id::pckerneis
CREATE INDEX idx_test_plan_item_overview_id ON TEST_PLAN_ITEM(OVERVIEW_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-index-on-test_plan_item.overview_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 54, '9:5cff545e6fc4b35926debee5e9c0f804', 'createIndex indexName=idx_test_plan_item_overview_id, tableName=TEST_PLAN_ITEM', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-migrate-session-overview-data::pckerneis
UPDATE TEST_PLAN_ITEM
      SET OVERVIEW_ID = coalesce(
        (
          SELECT OVERVIEW_ID
          FROM EXPLORATORY_SESSION_OVERVIEW eso
          WHERE eso.TEST_PLAN_ITEM_ID = TEST_PLAN_ITEM.TEST_PLAN_ITEM_ID
          LIMIT 1
        ),
        (
          SELECT OVERVIEW_ID
          FROM EXPLORATORY_SESSION_OVERVIEW eso
          WHERE eso.ITEM_TEST_PLAN_ID = TEST_PLAN_ITEM.TMP_ITPI_ID
          LIMIT 1
        )
      );

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-migrate-session-overview-data', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 55, '9:c15a726de90d4c4d0013f163068667f0', 'sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-drop-test_plan_item.tmp_itpi_id::pckerneis
ALTER TABLE TEST_PLAN_ITEM DROP FOREIGN KEY fk_test_plan_item_iteration_test_plan_item;

ALTER TABLE TEST_PLAN_ITEM DROP COLUMN TMP_ITPI_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-drop-test_plan_item.tmp_itpi_id', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 56, '9:4a79a13202717f31c6812b248c33e0f7', 'dropForeignKeyConstraint baseTableName=TEST_PLAN_ITEM, constraintName=fk_test_plan_item_iteration_test_plan_item; dropColumn columnName=TMP_ITPI_ID, tableName=TEST_PLAN_ITEM', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-drop-exploratory_session_overview-test-plan-columns::pckerneis
ALTER TABLE EXPLORATORY_SESSION_OVERVIEW DROP FOREIGN KEY fk_exploratory_session_test_plan_item;

ALTER TABLE EXPLORATORY_SESSION_OVERVIEW DROP FOREIGN KEY fk_exploratory_session_overview;

ALTER TABLE EXPLORATORY_SESSION_OVERVIEW DROP COLUMN ITEM_TEST_PLAN_ID;

ALTER TABLE EXPLORATORY_SESSION_OVERVIEW DROP COLUMN TEST_PLAN_ITEM_ID;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-drop-exploratory_session_overview-test-plan-columns', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 57, '9:7ac87751311f473f2d1fc39b50b90cf7', 'dropForeignKeyConstraint baseTableName=EXPLORATORY_SESSION_OVERVIEW, constraintName=fk_exploratory_session_test_plan_item; dropForeignKeyConstraint baseTableName=EXPLORATORY_SESSION_OVERVIEW, constraintName=fk_exploratory_session_overview; dropCol...', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-drop-item_test_plan_execution-table::pckerneis
DROP TABLE ITEM_TEST_PLAN_EXECUTION;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-drop-item_test_plan_execution-table', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 58, '9:5f0f071058f46a87a2387e30e52acf6c', 'dropTable tableName=ITEM_TEST_PLAN_EXECUTION', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-drop-item_test_plan_list-table::pckerneis
DROP TABLE ITEM_TEST_PLAN_LIST;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-drop-item_test_plan_list-table', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 59, '9:9d00a54dd2b8bc69123bc3c15d25ad43', 'dropTable tableName=ITEM_TEST_PLAN_LIST', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-drop-iteration_test_plan_item-table::pckerneis
DROP TABLE ITERATION_TEST_PLAN_ITEM;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-drop-iteration_test_plan_item-table', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 60, '9:2d204f5a75e9232c7dd63590a47d25d1', 'dropTable tableName=ITERATION_TEST_PLAN_ITEM', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-migrate-query_column_prototype-for-item_test_plan_tester::pckerneis
UPDATE QUERY_COLUMN_PROTOTYPE SET ATTRIBUTE_NAME = 'assignee.login' WHERE LABEL = 'ITEM_TEST_PLAN_TESTER';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-migrate-query_column_prototype-for-item_test_plan_tester', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 61, '9:a097bef0e3b8d918bbd08387754ad46d', 'update tableName=QUERY_COLUMN_PROTOTYPE', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-migrate-query_column_prototype-for-iteration_itemcount::pckerneis
UPDATE QUERY_COLUMN_PROTOTYPE SET ATTRIBUTE_NAME = 'count(testPlanItems)' WHERE LABEL = 'ITERATION_ITEMCOUNT';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-migrate-query_column_prototype-for-iteration_itemcount', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 62, '9:99160695289a1d8e001ccacda21c7adf', 'update tableName=QUERY_COLUMN_PROTOTYPE', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-cache-size-for-sequences::jprioux
ALTER SEQUENCE acl_class_id_seq CACHE 1;

ALTER SEQUENCE acl_group_id_seq CACHE 1;

ALTER SEQUENCE acl_object_identity_id_seq CACHE 1;

ALTER SEQUENCE acl_responsibility_scope_entry_id_seq CACHE 1;

ALTER SEQUENCE action_word_action_word_id_seq CACHE 1;

ALTER SEQUENCE action_word_fragment_action_word_fragment_id_seq CACHE 1;

ALTER SEQUENCE action_word_library_awl_id_seq CACHE 1;

ALTER SEQUENCE action_word_library_node_awln_id_seq CACHE 1;

ALTER SEQUENCE action_word_parameter_value_action_word_parameter_value_id_seq CACHE 1;

ALTER SEQUENCE api_token_token_id_seq CACHE 1;

ALTER SEQUENCE attachment_attachment_id_seq CACHE 1;

ALTER SEQUENCE attachment_content_attachment_content_id_seq CACHE 1;

ALTER SEQUENCE attachment_list_attachment_list_id_seq CACHE 1;

ALTER SEQUENCE automated_execution_extender_extender_id_seq CACHE 1;

ALTER SEQUENCE automated_test_technology_at_technology_id_seq CACHE 1;

ALTER SEQUENCE automated_test_test_id_seq CACHE 1;

ALTER SEQUENCE automation_request_automation_request_id_seq CACHE 1;

ALTER SEQUENCE automation_request_library_arl_id_seq CACHE 1;

ALTER SEQUENCE bugtracker_project_bugtracker_project_id_seq CACHE 1;

ALTER SEQUENCE campaign_library_cl_id_seq CACHE 1;

ALTER SEQUENCE campaign_library_node_cln_id_seq CACHE 1;

ALTER SEQUENCE campaign_test_plan_item_ctpi_id_seq CACHE 1;

ALTER SEQUENCE chart_definition_chart_id_seq CACHE 1;

ALTER SEQUENCE chart_filter_filter_id_seq CACHE 1;

ALTER SEQUENCE chart_project_scope_chart_project_scope_id_seq CACHE 1;

ALTER SEQUENCE connection_attempt_log_attempt_id_seq CACHE 1;

ALTER SEQUENCE core_group_id_seq CACHE 1;

ALTER SEQUENCE core_party_party_id_seq CACHE 1;

ALTER SEQUENCE core_user_id_seq CACHE 1;

ALTER SEQUENCE custom_field_binding_cfb_id_seq CACHE 1;

ALTER SEQUENCE custom_field_cf_id_seq CACHE 1;

ALTER SEQUENCE custom_field_value_cfv_id_seq CACHE 1;

ALTER SEQUENCE custom_report_chart_binding_crcb_id_seq CACHE 1;

ALTER SEQUENCE custom_report_custom_export_crce_id_seq CACHE 1;

ALTER SEQUENCE custom_report_dashboard_crd_id_seq CACHE 1;

ALTER SEQUENCE custom_report_folder_crf_id_seq CACHE 1;

ALTER SEQUENCE custom_report_library_crl_id_seq CACHE 1;

ALTER SEQUENCE custom_report_library_node_crln_id_seq CACHE 1;

ALTER SEQUENCE custom_report_report_binding_crrb_id_seq CACHE 1;

ALTER SEQUENCE dataset_dataset_id_seq CACHE 1;

ALTER SEQUENCE dataset_param_value_dataset_param_value_id_seq CACHE 1;

ALTER SEQUENCE denormalized_environment_tag_det_id_seq CACHE 1;

ALTER SEQUENCE denormalized_environment_variable_dev_id_seq CACHE 1;

ALTER SEQUENCE denormalized_field_value_dfv_id_seq CACHE 1;

ALTER SEQUENCE environment_variable_binding_evb_id_seq CACHE 1;

ALTER SEQUENCE environment_variable_ev_id_seq CACHE 1;

ALTER SEQUENCE execution_execution_id_seq CACHE 1;

ALTER SEQUENCE execution_step_execution_step_id_seq CACHE 1;

ALTER SEQUENCE exploratory_execution_event_event_id_seq CACHE 1;

ALTER SEQUENCE exploratory_session_overview_overview_id_seq CACHE 1;

ALTER SEQUENCE failure_detail_failure_detail_id_seq CACHE 1;

ALTER SEQUENCE grid_column_display_configuration_gcdc_id_seq CACHE 1;

ALTER SEQUENCE grid_column_display_reference_gcdr_id_seq CACHE 1;

ALTER SEQUENCE info_list_info_list_id_seq CACHE 1;

ALTER SEQUENCE info_list_item_item_id_seq CACHE 1;

ALTER SEQUENCE issue_issue_id_seq CACHE 1;

ALTER SEQUENCE issue_list_issue_list_id_seq CACHE 1;

ALTER SEQUENCE item_test_plan_item_test_plan_id_seq CACHE 1;

ALTER SEQUENCE iteration_iteration_id_seq CACHE 1;

ALTER SEQUENCE library_plugin_binding_plugin_binding_id_seq CACHE 1;

ALTER SEQUENCE milestone_binding_milestone_binding_id_seq CACHE 1;

ALTER SEQUENCE milestone_binding_perimeter_milestone_binding_perimeter_id_seq CACHE 1;

ALTER SEQUENCE milestone_milestone_id_seq CACHE 1;

ALTER SEQUENCE parameter_param_id_seq CACHE 1;

ALTER SEQUENCE party_preference_preference_id_seq CACHE 1;

ALTER SEQUENCE pivot_format_import_pfi_id_seq CACHE 1;

ALTER SEQUENCE project_filter_project_filter_id_seq CACHE 1;

ALTER SEQUENCE project_project_id_seq CACHE 1;

ALTER SEQUENCE proto_test_automation_project_ta_project_id_seq CACHE 1;

ALTER SEQUENCE query_column_prototype_query_column_id_seq CACHE 1;

ALTER SEQUENCE query_filter_column_query_filter_id_seq CACHE 1;

ALTER SEQUENCE query_model_query_model_id_seq CACHE 1;

ALTER SEQUENCE remote_automation_request_ext_remote_automation_request_ext_seq CACHE 1;

ALTER SEQUENCE remote_synchronisation_remote_synchronisation_id_seq CACHE 1;

ALTER SEQUENCE report_definition_report_id_seq CACHE 1;

ALTER SEQUENCE requirement_audit_event_event_id_seq CACHE 1;

ALTER SEQUENCE requirement_folder_sync_extender_rf_sync_extender_id_seq CACHE 1;

ALTER SEQUENCE requirement_library_node_rln_id_seq CACHE 1;

ALTER SEQUENCE requirement_library_rl_id_seq CACHE 1;

ALTER SEQUENCE requirement_sync_extender_req_sync_id_seq CACHE 1;

ALTER SEQUENCE requirement_version_coverage_requirement_version_coverage_i_seq CACHE 1;

ALTER SEQUENCE requirement_version_link_link_id_seq CACHE 1;

ALTER SEQUENCE requirement_version_link_type_type_id_seq CACHE 1;

ALTER SEQUENCE resource_res_id_seq CACHE 1;

ALTER SEQUENCE scm_repository_scm_repository_id_seq CACHE 1;

ALTER SEQUENCE session_note_note_id_seq CACHE 1;

ALTER SEQUENCE sprint_req_version_sprint_req_version_id_seq CACHE 1;

ALTER SEQUENCE sprint_requirement_sync_extender_sprint_req_sync_id_seq CACHE 1;

ALTER SEQUENCE stored_credentials_credential_id_seq CACHE 1;

ALTER SEQUENCE template_configurable_plugin_binding_binding_id_seq CACHE 1;

ALTER SEQUENCE test_case_library_node_tcln_id_seq CACHE 1;

ALTER SEQUENCE test_case_library_tcl_id_seq CACHE 1;

ALTER SEQUENCE test_plan_item_test_plan_item_id_seq CACHE 1;

ALTER SEQUENCE test_plan_test_plan_id_seq CACHE 1;

ALTER SEQUENCE test_step_test_step_id_seq CACHE 1;

ALTER SEQUENCE test_suite_id_seq CACHE 1;

ALTER SEQUENCE third_party_server_server_id_seq CACHE 1;

ALTER SEQUENCE automated_suite_suite_id_seq CACHE 1;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-cache-size-for-sequences', 'jprioux', 'tm/tm.changelog-10.0.0.xml', NOW(), 63, '9:4d1092f3263f8b5dbc13f14b61dc79c2', 'sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sql; sq...', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-infrasturucture-admin-group::jprioux
INSERT INTO CORE_GROUP (QUALIFIED_NAME) VALUES ('squashtest.authz.group.tm.InfrastructureAdmin');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-infrasturucture-admin-group', 'jprioux', 'tm/tm.changelog-10.0.0.xml', NOW(), 64, '9:03f884f749dcbb530204672ff5e601a1', 'insert tableName=CORE_GROUP', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-infrasturucture-admin-group-authority::jprioux
INSERT INTO CORE_GROUP_AUTHORITY (GROUP_ID, AUTHORITY) VALUES ((select ID from CORE_GROUP where QUALIFIED_NAME = 'squashtest.authz.group.tm.InfrastructureAdmin'), 'ROLE_INFRASTRUCTURE_ADMIN');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-infrasturucture-admin-group-authority', 'jprioux', 'tm/tm.changelog-10.0.0.xml', NOW(), 65, '9:ab73a79080ca84c86e2208656039ca84', 'insert tableName=CORE_GROUP_AUTHORITY', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-redefine-trigger-requirement-library-node::amarjollet
drop trigger if exists ins_rln_after;

create trigger ins_rln_after after insert on REQUIREMENT_LIBRARY_NODE
      for each row insert into RLN_RELATIONSHIP_CLOSURE SELECT new.rln_id, new.rln_id, 0 FROM DUAL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-redefine-trigger-requirement-library-node', 'amarjollet', 'tm/tm.changelog-10.0.0.xml', NOW(), 66, '9:8b04c0c09755e071abae665b784e3974', 'sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-redefine-trigger-test-case-library-node::amarjollet
drop trigger if exists ins_tcln_after;

create trigger ins_tcln_after after insert on TEST_CASE_LIBRARY_NODE
      for each row insert into TCLN_RELATIONSHIP_CLOSURE SELECT new.tcln_id, new.tcln_id, 0 FROM DUAL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-redefine-trigger-test-case-library-node', 'amarjollet', 'tm/tm.changelog-10.0.0.xml', NOW(), 67, '9:5057168b93c382f2b94a26ee561ebb8a', 'sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-redefine-trigger-campaign-library-node::amarjollet
drop trigger if exists ins_cln_after;

create trigger ins_cln_after after insert on CAMPAIGN_LIBRARY_NODE
      for each row insert into CLN_RELATIONSHIP_CLOSURE SELECT new.cln_id, new.cln_id, 0 FROM DUAL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-redefine-trigger-campaign-library-node', 'amarjollet', 'tm/tm.changelog-10.0.0.xml', NOW(), 68, '9:fc6383e86b6bb9e97a0972d0caabae66', 'sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-redefine-trigger-action-word-library-node::amarjollet
drop trigger if exists ins_awln_after;

create trigger ins_awln_after after insert on ACTION_WORD_LIBRARY_NODE
      for each row insert into AWLN_RELATIONSHIP_CLOSURE SELECT new.awln_id, new.awln_id, 0 FROM DUAL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-redefine-trigger-action-word-library-node', 'amarjollet', 'tm/tm.changelog-10.0.0.xml', NOW(), 69, '9:d7f677889f5d0bfac74a083742f0bac0', 'sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-redefine-trigger-custom-report-library-node::amarjollet
drop trigger if exists ins_crln_after;

create trigger ins_crln_after after insert on CUSTOM_REPORT_LIBRARY_NODE
      for each row insert into CRLN_RELATIONSHIP_CLOSURE SELECT new.crln_id, new.crln_id, 0 FROM DUAL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-redefine-trigger-custom-report-library-node', 'amarjollet', 'tm/tm.changelog-10.0.0.xml', NOW(), 70, '9:1b9dd0163e1c9de08d82eb76726516fb', 'sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-not-null-constraint-on-automated-suite-workflows-suite-id::jprioux
ALTER TABLE AUTOMATED_SUITE_WORKFLOWS MODIFY SUITE_ID BIGINT NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-not-null-constraint-on-automated-suite-workflows-suite-id', 'jprioux', 'tm/tm.changelog-10.0.0.xml', NOW(), 71, '9:3cbfa0e1614ccc5218665ce59bf11617', 'addNotNullConstraint columnName=SUITE_ID, tableName=AUTOMATED_SUITE_WORKFLOWS', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-add-not-null-constraint-on-automated-execution-extender-suite-id::jprioux
ALTER TABLE AUTOMATED_EXECUTION_EXTENDER MODIFY SUITE_ID BIGINT NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-add-not-null-constraint-on-automated-execution-extender-suite-id', 'jprioux', 'tm/tm.changelog-10.0.0.xml', NOW(), 72, '9:fe3bc7bc3baffa37db48781795d0088c', 'addNotNullConstraint columnName=SUITE_ID, tableName=AUTOMATED_EXECUTION_EXTENDER', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-remove-role_ta_api_client-and-role_admin-in-core_party_authority::jprioux
DELETE FROM CORE_PARTY_AUTHORITY WHERE authority in ('ROLE_ADMIN', 'ROLE_TA_API_CLIENT');

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-remove-role_ta_api_client-and-role_admin-in-core_party_authority', 'jprioux', 'tm/tm.changelog-10.0.0.xml', NOW(), 73, '9:26ef93b7d5db31fe7aac3e7dc0a3013e', 'delete tableName=CORE_PARTY_AUTHORITY', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-increase-requirement-sequence-increment::bmsaddek
ALTER SEQUENCE attachment_list_attachment_list_id_seq INCREMENT BY 30;

ALTER SEQUENCE requirement_audit_event_event_id_seq INCREMENT BY 30;

ALTER SEQUENCE requirement_folder_sync_extender_rf_sync_extender_id_seq INCREMENT BY 30;

ALTER SEQUENCE requirement_library_node_rln_id_seq INCREMENT BY 30;

ALTER SEQUENCE requirement_sync_extender_req_sync_id_seq INCREMENT BY 30;

ALTER SEQUENCE requirement_version_coverage_requirement_version_coverage_i_seq INCREMENT BY 30;

ALTER SEQUENCE requirement_version_link_link_id_seq INCREMENT BY 30;

ALTER SEQUENCE requirement_version_link_type_type_id_seq INCREMENT BY 30;

ALTER SEQUENCE resource_res_id_seq INCREMENT BY 30;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-increase-requirement-sequence-increment', 'bmsaddek', 'tm/tm.changelog-10.0.0.xml', NOW(), 74, '9:2e2db0b903cc5ed383b138b6cd8aa867', 'sql; sql; sql; sql; sql; sql; sql; sql; sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0-increase-requirement-sequence-cache::bmsaddek
ALTER SEQUENCE attachment_list_attachment_list_id_seq CACHE 20;

ALTER SEQUENCE requirement_audit_event_event_id_seq CACHE 20;

ALTER SEQUENCE requirement_folder_sync_extender_rf_sync_extender_id_seq CACHE 20;

ALTER SEQUENCE requirement_library_node_rln_id_seq CACHE 20;

ALTER SEQUENCE requirement_sync_extender_req_sync_id_seq CACHE 20;

ALTER SEQUENCE requirement_version_coverage_requirement_version_coverage_i_seq CACHE 20;

ALTER SEQUENCE requirement_version_link_link_id_seq CACHE 20;

ALTER SEQUENCE requirement_version_link_type_type_id_seq CACHE 20;

ALTER SEQUENCE resource_res_id_seq CACHE 20;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0-increase-requirement-sequence-cache', 'bmsaddek', 'tm/tm.changelog-10.0.0.xml', NOW(), 75, '9:aea805d83cebf87c1561b74eac81e6f1', 'sql; sql; sql; sql; sql; sql; sql; sql; sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Changeset tm/tm.changelog-10.0.0.xml::tm-10.0.0::pckerneis
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '10.0.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-10.0.0', 'pckerneis', 'tm/tm.changelog-10.0.0.xml', NOW(), 76, '9:170245afb47a5a4680a5515c84ca9a1e', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, NULL, '4.29.2', '3551889654');

--  Release Database Lock
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 0, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

