/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.service.impl;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.PersistenceContext;
import java.util.Collections;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.plugin.jirasync.controller.model.JiraRemoteSynchronisationModel;
import org.squashtest.tm.plugin.jirasync.controller.model.JiraRemoteSynchronisationModelBuilder;
import org.squashtest.tm.plugin.jirasync.domain.JiraRemoteSynchronisation;
import org.squashtest.tm.plugin.jirasync.service.ConfigurationService;
import org.squashtest.tm.plugin.rest.admin.jackson.model.JiraRemoteSynchronisationModelDto;
import org.squashtest.tm.plugin.rest.admin.service.RestRemoteSynchronisationService;
import org.squashtest.tm.plugin.rest.admin.service.patcher.JiraRemoteSynchronisationPatcher;
import org.squashtest.tm.plugin.rest.repository.RestRemoteSynchronisationRepository;

@Service
@Transactional
public class RestRemoteSynchronisationImpl
implements RestRemoteSynchronisationService {
    private static final String MANAGE_SYNC_OR_ROLE_ADMIN = "hasPermission(#syncId, 'org.squashtest.tm.domain.synchronisation.RemoteSynchronisation', 'MANAGE_PROJECT') or hasRole('ROLE_ADMIN')";
    @Inject
    private ConfigurationService pluginService;
    @Inject
    private Provider<JiraRemoteSynchronisationModelBuilder> syncModelBuilderProvider;
    @Inject
    private JiraRemoteSynchronisationPatcher jiraRemoteSynchronisationPatcher;
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private RestRemoteSynchronisationRepository restRemoteSynchronisationRepository;

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public Page<JiraRemoteSynchronisationModel> findAllSynchronisationByProjectId(Long projectId, Pageable pageable) {
        Page<RemoteSynchronisation> page = this.restRemoteSynchronisationRepository.findAllByProject_Id(projectId, pageable);
        return page.map(synchronisation -> {
            JiraRemoteSynchronisation jiraSynchronisation = new JiraRemoteSynchronisation((RemoteSynchronisation)synchronisation);
            return ((JiraRemoteSynchronisationModelBuilder)this.syncModelBuilderProvider.get()).build(jiraSynchronisation);
        });
    }

    @Override
    @PreAuthorize(value="hasPermission(#syncId, 'org.squashtest.tm.domain.synchronisation.RemoteSynchronisation', 'MANAGE_PROJECT') or hasRole('ROLE_ADMIN')")
    public JiraRemoteSynchronisationModel getSynchronisationById(long syncId) throws EntityNotFoundException {
        RemoteSynchronisation remoteSynchronisation = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)syncId);
        if (remoteSynchronisation == null) {
            throw new EntityNotFoundException();
        }
        JiraRemoteSynchronisation jiraRemoteSynchronisation = new JiraRemoteSynchronisation(remoteSynchronisation);
        return ((JiraRemoteSynchronisationModelBuilder)this.syncModelBuilderProvider.get()).build(jiraRemoteSynchronisation);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public JiraRemoteSynchronisationModel addJiraRemoteSynchronisation(long projectId, JiraRemoteSynchronisationModelDto synchronisationDto) {
        JiraRemoteSynchronisationModel synchronisation = new JiraRemoteSynchronisationModel();
        this.jiraRemoteSynchronisationPatcher.patch(synchronisation, synchronisationDto);
        JiraRemoteSynchronisation newSynchro = this.pluginService.addJiraRemoteSynchronisation(projectId, synchronisation);
        return ((JiraRemoteSynchronisationModelBuilder)this.syncModelBuilderProvider.get()).build(newSynchro);
    }

    @Override
    @PreAuthorize(value="hasPermission(#syncId, 'org.squashtest.tm.domain.synchronisation.RemoteSynchronisation', 'MANAGE_PROJECT') or hasRole('ROLE_ADMIN')")
    public JiraRemoteSynchronisationModel updateSynchronisation(long syncId, JiraRemoteSynchronisationModelDto synchronisationDto) {
        if (synchronisationDto.isHasName()) {
            this.pluginService.changeSyncName(syncId, synchronisationDto.getName());
        }
        if (synchronisationDto.isHasAdditionalJQL()) {
            this.pluginService.changeSyncAdditionalJQL(syncId, synchronisationDto.getAdditionalJQL());
        }
        if (synchronisationDto.isHasSelectValue()) {
            this.pluginService.changeSyncSelectValue(syncId, synchronisationDto.getSelectValue());
        }
        RemoteSynchronisation synchro = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)syncId);
        return ((JiraRemoteSynchronisationModelBuilder)this.syncModelBuilderProvider.get()).build(new JiraRemoteSynchronisation(synchro));
    }

    @Override
    public void deleteSynchronisation(long jiraSynchroId) {
        this.pluginService.deleteJiraRemoteSynchronisations(Collections.singletonList(jiraSynchroId));
    }

    @Override
    public JiraRemoteSynchronisationModel commandFullSynchronisation(long syncId) {
        RemoteSynchronisation synchro = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)syncId);
        if (!synchro.isSynchronisationEnable()) {
            throw new UnsupportedOperationException();
        }
        this.pluginService.commandFullSynchronisation(syncId);
        return ((JiraRemoteSynchronisationModelBuilder)this.syncModelBuilderProvider.get()).build(new JiraRemoteSynchronisation(synchro));
    }

    @Override
    @PreAuthorize(value="hasPermission(#syncId, 'org.squashtest.tm.domain.synchronisation.RemoteSynchronisation', 'MANAGE_PROJECT') or hasRole('ROLE_ADMIN')")
    public JiraRemoteSynchronisationModel changeSync(long syncId, String synchronisationEnable) {
        this.pluginService.changeSync(syncId, synchronisationEnable);
        RemoteSynchronisation synchro = (RemoteSynchronisation)this.entityManager.find(RemoteSynchronisation.class, (Object)syncId);
        return ((JiraRemoteSynchronisationModelBuilder)this.syncModelBuilderProvider.get()).build(new JiraRemoteSynchronisation(synchro));
    }
}

