/*
 * Decompiled with CFR 0.152.
 */
package jirasync.org.apache.http.impl.execchain;

import java.io.IOException;
import java.io.InterruptedIOException;
import jirasync.org.apache.http.Header;
import jirasync.org.apache.http.HttpException;
import jirasync.org.apache.http.annotation.Contract;
import jirasync.org.apache.http.annotation.ThreadingBehavior;
import jirasync.org.apache.http.client.ServiceUnavailableRetryStrategy;
import jirasync.org.apache.http.client.methods.CloseableHttpResponse;
import jirasync.org.apache.http.client.methods.HttpExecutionAware;
import jirasync.org.apache.http.client.methods.HttpRequestWrapper;
import jirasync.org.apache.http.client.protocol.HttpClientContext;
import jirasync.org.apache.http.conn.routing.HttpRoute;
import jirasync.org.apache.http.impl.execchain.ClientExecChain;
import jirasync.org.apache.http.impl.execchain.RequestEntityProxy;
import jirasync.org.apache.http.util.Args;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ServiceUnavailableRetryExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final ServiceUnavailableRetryStrategy retryStrategy;

    public ServiceUnavailableRetryExec(ClientExecChain requestExecutor, ServiceUnavailableRetryStrategy retryStrategy) {
        Args.notNull(requestExecutor, "HTTP request executor");
        Args.notNull(retryStrategy, "Retry strategy");
        this.requestExecutor = requestExecutor;
        this.retryStrategy = retryStrategy;
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        Header[] origheaders = request.getAllHeaders();
        int c = 1;
        while (true) {
            CloseableHttpResponse response = this.requestExecutor.execute(route, request, context, execAware);
            try {
                if (this.retryStrategy.retryRequest(response, c, context) && RequestEntityProxy.isRepeatable(request)) {
                    response.close();
                    long nextInterval = this.retryStrategy.getRetryInterval();
                    if (nextInterval > 0L) {
                        try {
                            this.log.trace((Object)("Wait for " + nextInterval));
                            Thread.sleep(nextInterval);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new InterruptedIOException();
                        }
                    }
                } else {
                    return response;
                }
                request.setHeaders(origheaders);
            }
            catch (RuntimeException ex) {
                response.close();
                throw ex;
            }
            ++c;
        }
    }
}

