/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.service.impl;

import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.tm.domain.campaign.SprintGroup;
import org.squashtest.tm.plugin.rest.jackson.model.ParentEntity;
import org.squashtest.tm.plugin.rest.jackson.model.SprintGroupDto;
import org.squashtest.tm.plugin.rest.repository.RestSprintGroupRepository;
import org.squashtest.tm.plugin.rest.service.RestSprintGroupService;
import org.squashtest.tm.plugin.rest.service.impl.SprintGroupPatcher;
import org.squashtest.tm.plugin.rest.utils.PaginationUtils;
import org.squashtest.tm.service.campaign.CampaignLibraryNavigationService;
import org.squashtest.tm.service.project.ProjectFinder;

@Service
@Transactional
public class RestSprintGroupServiceImpl
implements RestSprintGroupService {
    @Inject
    private RestSprintGroupRepository restSprintGroupRepository;
    @Inject
    private ProjectFinder projectFinder;
    @Inject
    private CampaignLibraryNavigationService campaignLibraryNavigationService;
    @Inject
    private SprintGroupPatcher sprintGroupPatcher;

    @Override
    @Transactional(readOnly=true)
    @PreAuthorize(value="@apiSecurity.hasPermission(#sprintGroupId, 'org.squashtest.tm.domain.campaign.SprintGroup', 'READ')")
    public SprintGroup getOne(Long sprintGroupId) {
        return (SprintGroup)this.restSprintGroupRepository.getReferenceById(sprintGroupId);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<SprintGroup> findAllReadable(Pageable pageable) {
        List projectIds = this.projectFinder.findReadableProjectIdsOnCampaignLibrary();
        return projectIds.isEmpty() ? PaginationUtils.emptyPage(pageable) : this.restSprintGroupRepository.findAllInProjects(projectIds, pageable);
    }

    @Override
    public void deleteSprintGroupsByIds(List<Long> sprintGroupIds) {
        this.campaignLibraryNavigationService.deleteNodes(sprintGroupIds);
    }

    @Override
    public SprintGroup createSprintGroup(SprintGroupDto sprintGroupDto) {
        SprintGroup sprintGroup = new SprintGroup();
        this.sprintGroupPatcher.patch(sprintGroup, sprintGroupDto);
        ParentEntity parent = sprintGroupDto.getParent();
        switch (parent.getRestType()) {
            case PROJECT: {
                this.campaignLibraryNavigationService.addSprintGroupToCampaignLibrary(parent.getId().longValue(), sprintGroup, new HashMap());
                break;
            }
            case CAMPAIGN_FOLDER: {
                this.campaignLibraryNavigationService.addSprintGroupToCampaignFolder(parent.getId().longValue(), sprintGroup, new HashMap());
                break;
            }
            default: {
                throw new IllegalArgumentException("Programmatic error : Rest type " + String.valueOf((Object)parent.getRestType()) + " is not a valid parent. You should validate this before.");
            }
        }
        return sprintGroup;
    }

    @Override
    @PreAuthorize(value="@apiSecurity.hasPermission(#sprintGroupId, 'org.squashtest.tm.domain.campaign.SprintGroup', 'WRITE')")
    public SprintGroup patchSprintGroup(SprintGroupDto sprintGroupDto, long sprintGroupId) {
        SprintGroup sprintGroup = this.getOne(sprintGroupId);
        this.sprintGroupPatcher.patch(sprintGroup, sprintGroupDto);
        return sprintGroup;
    }
}

