/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import jakarta.inject.Inject;
import org.springframework.hateoas.EntityModel;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.campaign.SprintReqVersion;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.service.RestSprintReqVersionService;

@RestApiController(value=SprintReqVersion.class)
public class RestSprintReqVersionController
extends BaseRestController {
    @Inject
    private RestSprintReqVersionService sprintReqVersionService;

    @GetMapping(value={"/sprint-req-versions/{id}"})
    @EntityGetter
    @ResponseBody
    @DynamicFilterExpression(value="*, project[name], requirement_version[name], sprint[name]")
    public ResponseEntity<EntityModel<SprintReqVersion>> findSprintReqVersion(@PathVariable(value="id") long id) {
        SprintReqVersion sprintReqVersion = this.sprintReqVersionService.getOne(id);
        EntityModel entityModel = this.toEntityModel((Identified)sprintReqVersion);
        entityModel.add(this.linkService.createLinkTo((Identified)sprintReqVersion.getSprint()));
        return ResponseEntity.ok((Object)entityModel);
    }
}

