/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import jakarta.inject.Inject;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.execution.ExploratoryExecution;
import org.squashtest.tm.domain.execution.SessionNote;
import org.squashtest.tm.plugin.rest.controller.helper.ResourceLinksHelper;
import org.squashtest.tm.plugin.rest.core.jackson.DynamicFilterExpression;
import org.squashtest.tm.plugin.rest.core.web.BaseRestController;
import org.squashtest.tm.plugin.rest.core.web.EntityGetter;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.IssueDto;
import org.squashtest.tm.plugin.rest.jackson.model.IssueDtoForExecution;
import org.squashtest.tm.plugin.rest.service.RestExploratoryExecutionService;
import org.squashtest.tm.plugin.rest.service.RestIssueService;
import org.squashtest.tm.plugin.rest.service.RestSessionNoteService;

@RestApiController(value=ExploratoryExecution.class)
@UseDefaultRestApiConfiguration
public class RestExploratoryExecutionController
extends BaseRestController {
    public static final String EXPLO_EXECUTION_DYNAMIC_FILTER = "name,reference,execution_mode,progress_status,last_executed_by,last_executed_on,charter,task_division,session_notes[kind,content],reviewed,comment,custom_fields,test_case_custom_fields,attachments";
    @Inject
    private ResourceLinksHelper linksHelper;
    @Inject
    private RestExploratoryExecutionService service;
    @Inject
    private RestIssueService restIssueService;
    @Inject
    private RestSessionNoteService sessionNoteService;

    @GetMapping(value={"/exploratory-executions/{id}"})
    @EntityGetter(value={ExploratoryExecution.class})
    @ResponseBody
    @DynamicFilterExpression(value="name,reference,execution_mode,progress_status,last_executed_by,last_executed_on,charter,task_division,session_notes[kind,content],reviewed,comment,custom_fields,test_case_custom_fields,attachments")
    public ResponseEntity<EntityModel<ExploratoryExecution>> findExploratoryExecution(@PathVariable(value="id") long id) {
        ExploratoryExecution exploratoryExecution = this.service.getOne(id);
        EntityModel res = this.toEntityModel((Identified)exploratoryExecution);
        this.linksHelper.addAllLinksForExploratoryExecution((EntityModel<ExploratoryExecution>)res);
        res.add(this.createRelationTo("issues"));
        return ResponseEntity.ok((Object)res);
    }

    @GetMapping(value={"/exploratory-executions/{id}/issues"})
    @ResponseBody
    @DynamicFilterExpression(value="execution-step[id]")
    public ResponseEntity<PagedModel<EntityModel<IssueDtoForExecution>>> findExecutionsIssues(@PathVariable(value="id") long id, Pageable pageable) {
        ExploratoryExecution exploratoryExecution = this.service.getOne(id);
        Page<IssueDto> pagedIssue = this.restIssueService.getIssuesFromExecutionIds(Collections.singletonList(exploratoryExecution.getId()), pageable);
        for (IssueDto issue : pagedIssue.getContent()) {
            List<SessionNote> sessionNotes = this.sessionNoteService.getSessionNotesFromIssue(issue.getRemoteIssueId(), id);
            issue.setSessionNotes(new HashSet<SessionNote>(sessionNotes));
            issue.getExecutions().clear();
        }
        PagedModel res = this.pageAssembler.toModel(pagedIssue);
        return ResponseEntity.ok((Object)res);
    }
}

