/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.controller;

import jakarta.inject.Inject;
import jakarta.persistence.EntityNotFoundException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;
import org.squashtest.tm.plugin.rest.jackson.model.AttachmentRestDto;
import org.squashtest.tm.service.internal.display.dto.AttachmentDto;
import org.squashtest.tm.service.testautomation.model.Attachment;
import org.squashtest.tm.service.testautomation.model.AutomatedExecutionState;
import org.squashtest.tm.service.testautomation.resultpublisher.AutomatedSuitePublisherService;
import org.squashtest.tm.service.testautomation.resultpublisher.ResultPublicationService;

@UseDefaultRestApiConfiguration
@RestApiController
public class RestAutomatedSuiteUpdateController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestAutomatedSuiteUpdateController.class);
    @Inject
    private ResultPublicationService publicationService;
    @Inject
    private AutomatedSuitePublisherService automatedSuitePublisherService;

    @ResponseBody
    @PostMapping(value={"resultpublisher/{suiteId}/automated-executions/{testId}/test-status"})
    public synchronized void updateITPIState(@PathVariable String suiteId, @PathVariable long testId, @RequestBody AutomatedExecutionState stateChange) {
        this.automatedSuitePublisherService.addItpiLabelAndIdToAttachmentName(testId, stateChange);
        this.publicationService.publishResult(suiteId, testId, stateChange);
    }

    @ResponseBody
    @PostMapping(value={"resultpublisher/{suiteId}/automated-executions/allureReport"})
    public synchronized ResponseEntity<AttachmentRestDto> deprecatedAttachToAutomatedSuite(@PathVariable String suiteId, @RequestBody Attachment allureAttachment) {
        AttachmentDto dto = this.automatedSuitePublisherService.attachReportToAutomatedSuite(suiteId, allureAttachment);
        AttachmentRestDto attachmentRestDto = new AttachmentRestDto(dto.getId(), dto.getName(), dto.getSize(), dto.getAddedOn());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)attachmentRestDto);
    }

    @ResponseBody
    @PostMapping(value={"resultpublisher/{suiteId}/automated-executions/attachments"})
    public synchronized ResponseEntity<AttachmentRestDto> attachToAutomatedSuite(@PathVariable String suiteId, @RequestBody Attachment allureAttachment) {
        AttachmentDto dto = this.automatedSuitePublisherService.attachReportToAutomatedSuite(suiteId, allureAttachment);
        AttachmentRestDto attachmentRestDto = new AttachmentRestDto(dto.getId(), dto.getName(), dto.getSize(), dto.getAddedOn());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)attachmentRestDto);
    }

    @ResponseBody
    @PutMapping(value={"attachments/{id}"})
    public synchronized ResponseEntity<AttachmentRestDto> updateAutomatedSuiteAttachmentContent(@PathVariable Long id, @RequestBody Attachment allureAttachment) {
        try {
            AttachmentDto dto = this.automatedSuitePublisherService.updateAttachmentContent(allureAttachment, id);
            AttachmentRestDto attachmentRestDto = new AttachmentRestDto(dto.getId(), dto.getName(), dto.getSize(), dto.getAddedOn());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)attachmentRestDto);
        }
        catch (EntityNotFoundException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY).body(null);
        }
    }

    @ResponseBody
    @PutMapping(value={"resultpublisher/{suiteId}/automated-executions/suite-status"}, consumes={"application/json"})
    public void updateAutomatedSuiteStatus(@PathVariable String suiteId, HttpServletRequest request) throws IOException {
        String status = this.extractBody(request);
        this.automatedSuitePublisherService.updateAutomatedSuiteExecStatus(suiteId, status);
    }

    private String extractBody(HttpServletRequest request) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));){
            return reader.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

