/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.http.impl.auth;

import org.squashtest.tm.plugin.bugtracker.redmine3.http.annotation.Contract;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.annotation.ThreadingBehavior;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.auth.AuthScheme;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.auth.AuthSchemeFactory;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.auth.AuthSchemeProvider;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.impl.auth.KerberosScheme;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.params.HttpParams;
import org.squashtest.tm.plugin.bugtracker.redmine3.http.protocol.HttpContext;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class KerberosSchemeFactory
implements AuthSchemeFactory,
AuthSchemeProvider {
    private final boolean stripPort;
    private final boolean useCanonicalHostname;

    public KerberosSchemeFactory(boolean stripPort, boolean useCanonicalHostname) {
        this.stripPort = stripPort;
        this.useCanonicalHostname = useCanonicalHostname;
    }

    public KerberosSchemeFactory(boolean stripPort) {
        this.stripPort = stripPort;
        this.useCanonicalHostname = true;
    }

    public KerberosSchemeFactory() {
        this(true, true);
    }

    public boolean isStripPort() {
        return this.stripPort;
    }

    public boolean isUseCanonicalHostname() {
        return this.useCanonicalHostname;
    }

    @Override
    public AuthScheme newInstance(HttpParams params) {
        return new KerberosScheme(this.stripPort, this.useCanonicalHostname);
    }

    @Override
    public AuthScheme create(HttpContext context) {
        return new KerberosScheme(this.stripPort, this.useCanonicalHostname);
    }
}

