/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.jiracloud;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.squashtest.csp.core.bugtracker.core.NamespacedBugtrackerMessageSource;
import org.squashtest.tm.api.config.SquashPathProperties;
import org.squashtest.tm.plugin.bugtracker.jiracloud.licensevalidator.LicenseValidator;
import org.squashtest.tm.plugin.bugtracker.jiracloud.licensevalidator.service.ValidationService;
import org.squashtest.tm.plugin.bugtracker.jiracloud.licensevalidator.service.impl.ValidationServiceImpl;

@Configuration
@ComponentScan(basePackages={"org.squashtest.tm.plugin.bugtracker.jiracloud"})
public class JiraCloudConnectorConfig {
    @Inject
    private SquashPathProperties squashPathProperties;

    @Bean
    public MessageSource jiraCloudConnectorMessageSource() {
        ReloadableResourceBundleMessageSource bean = new ReloadableResourceBundleMessageSource();
        bean.setCacheSeconds(60);
        bean.setBasenames(new String[]{"classpath:/org/squashtest/tm/plugin/bugtracker/jiracloud/messages"});
        return new NamespacedBugtrackerMessageSource((MessageSource)bean, "bugtracker.jiracloud.");
    }

    @Bean(name={"org.squashtest.tm.plugin.bugtracker.jiracloud.ValidationService"})
    public ValidationService validationService() {
        return new ValidationServiceImpl();
    }

    @Bean(name={"org.squashtest.tm.plugin.bugtracker.jiracloud.LicenseValidator"})
    public LicenseValidator licenseValidator(@Named(value="org.squashtest.tm.plugin.bugtracker.jiracloud.ValidationService") ValidationService service) {
        return new LicenseValidator(service);
    }
}

