/*
 * Decompiled with CFR 0.152.
 */
package jiracloud.org.apache.http.protocol;

import java.io.IOException;
import jiracloud.org.apache.http.HttpException;
import jiracloud.org.apache.http.HttpRequest;
import jiracloud.org.apache.http.HttpRequestInterceptor;
import jiracloud.org.apache.http.annotation.Contract;
import jiracloud.org.apache.http.annotation.ThreadingBehavior;
import jiracloud.org.apache.http.protocol.HttpContext;
import jiracloud.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestConnControl
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
    }
}

