/*
 * Decompiled with CFR 0.152.
 */
package jiracloud.com.atlassian.jira.rest.client.internal.json;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jiracloud.com.atlassian.jira.rest.client.api.domain.BasicProject;
import jiracloud.com.atlassian.jira.rest.client.api.domain.CimIssueType;
import jiracloud.com.atlassian.jira.rest.client.api.domain.CimProject;
import jiracloud.com.atlassian.jira.rest.client.internal.json.BasicProjectJsonParser;
import jiracloud.com.atlassian.jira.rest.client.internal.json.CimIssueTypeJsonParser;
import jiracloud.com.atlassian.jira.rest.client.internal.json.GenericJsonArrayParser;
import jiracloud.com.atlassian.jira.rest.client.internal.json.JsonArrayParser;
import jiracloud.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jiracloud.com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import jiracloud.org.codehaus.jettison.json.JSONArray;
import jiracloud.org.codehaus.jettison.json.JSONException;
import jiracloud.org.codehaus.jettison.json.JSONObject;

public class CimProjectJsonParser
implements JsonObjectParser<CimProject> {
    private final JsonArrayParser<Iterable<CimIssueType>> issueTypesParser = GenericJsonArrayParser.create(new CimIssueTypeJsonParser());
    private final BasicProjectJsonParser basicProjectJsonParser = new BasicProjectJsonParser();

    @Override
    public CimProject parse(JSONObject json) throws JSONException {
        BasicProject basicProject = this.basicProjectJsonParser.parse(json);
        JSONArray issueTypesArray = json.optJSONArray("issuetypes");
        List<CimIssueType> issueTypes = issueTypesArray != null ? (Iterable)this.issueTypesParser.parse(issueTypesArray) : Collections.emptyList();
        Map<String, URI> avatarUris = JsonParseUtil.getAvatarUris(json.getJSONObject("avatarUrls"));
        return new CimProject(basicProject.getSelf(), basicProject.getKey(), basicProject.getId(), basicProject.getName(), avatarUris, issueTypes);
    }
}

