/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.gitlab.dao;

import java.io.IOException;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.squashtest.csp.core.bugtracker.core.BugTrackerLocalException;
import org.squashtest.tm.plugin.bugtracker.gitlab.GitLabConfigurablePlugin;
import org.squashtest.tm.plugin.bugtracker.gitlab.configuration.PersistedConfiguration;
import org.squashtest.tm.service.project.GenericProjectManagerService;

@Service
@Transactional
public class ConfigurationDao {
    private final GenericProjectManagerService projectManager;

    public ConfigurationDao(GenericProjectManagerService projectManager) {
        this.projectManager = projectManager;
    }

    public PersistedConfiguration loadOrGetDefaultConfiguration(Long projectId) {
        Map<String, String> rawConfiguration = this.getRawConfiguration(projectId);
        if (rawConfiguration == null || rawConfiguration.isEmpty()) {
            return PersistedConfiguration.withDefaultConfiguration();
        }
        try {
            return PersistedConfiguration.fromRawMap(rawConfiguration);
        }
        catch (IOException e) {
            throw new BugTrackerLocalException("Cannot load configuration for project " + projectId, (Throwable)e);
        }
    }

    public void saveConfiguration(Long projectId, PersistedConfiguration persistedConfiguration) throws IOException {
        if (!persistedConfiguration.isEmpty()) {
            this.projectManager.setPluginConfiguration(projectId.longValue(), GitLabConfigurablePlugin.CONFIGURING_WORKSPACE, "gitlab-bugtracker", persistedConfiguration.asRawMap());
        } else {
            this.projectManager.setPluginConfiguration(projectId.longValue(), GitLabConfigurablePlugin.CONFIGURING_WORKSPACE, "gitlab-bugtracker", null);
        }
    }

    private Map<String, String> getRawConfiguration(Long projectId) {
        return this.projectManager.getPluginConfigurationWithoutCheck(projectId.longValue(), GitLabConfigurablePlugin.CONFIGURING_WORKSPACE, "gitlab-bugtracker");
    }

    public void updateDisplayState(long projectId, boolean newValue) {
        try {
            PersistedConfiguration configuration = this.loadOrGetDefaultConfiguration(projectId);
            configuration.setDisplayState(newValue);
            this.projectManager.setPluginConfiguration(projectId, GitLabConfigurablePlugin.CONFIGURING_WORKSPACE, "gitlab-bugtracker", configuration.asRawMap());
        }
        catch (IOException ex) {
            throw new BugTrackerLocalException("Could not load configuration for project " + projectId, (Throwable)ex);
        }
    }
}

