/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.gitlab4j.api;

import gitlabbt.org.gitlab4j.api.AbstractApi;
import gitlabbt.org.gitlab4j.api.GitLabApi;
import gitlabbt.org.gitlab4j.api.GitLabApiException;
import gitlabbt.org.gitlab4j.api.GitLabApiForm;
import gitlabbt.org.gitlab4j.api.Pager;
import gitlabbt.org.gitlab4j.api.models.Job;
import gitlabbt.org.gitlab4j.api.models.JobStatus;
import gitlabbt.org.gitlab4j.api.models.Runner;
import gitlabbt.org.gitlab4j.api.models.RunnerDetail;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.stream.Stream;

public class RunnersApi
extends AbstractApi {
    public RunnersApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Runner> getRunners() throws GitLabApiException {
        return this.getRunners(null, null, this.getDefaultPerPage()).all();
    }

    public List<Runner> getRunners(int page, int perPage) throws GitLabApiException {
        return this.getRunners(null, null, page, perPage);
    }

    public Pager<Runner> getRunners(int itemsPerPage) throws GitLabApiException {
        return this.getRunners(null, null, itemsPerPage);
    }

    public Stream<Runner> getRunnersStream() throws GitLabApiException {
        return this.getRunners(null, null, this.getDefaultPerPage()).stream();
    }

    public List<Runner> getRunners(Runner.RunnerType type, Runner.RunnerStatus status) throws GitLabApiException {
        return this.getRunners(type, status, this.getDefaultPerPage()).all();
    }

    public List<Runner> getRunners(Runner.RunnerType type, Runner.RunnerStatus status, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm(page, perPage).withParam("type", (Object)type, false).withParam("status", (Object)status, false);
        Response response = this.get(Response.Status.OK, formData.asMap(), "runners");
        return response.readEntity(new GenericType<List<Runner>>(){});
    }

    public Pager<Runner> getRunners(Runner.RunnerType type, Runner.RunnerStatus status, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("type", (Object)type, false).withParam("status", (Object)status, false);
        return new Pager<Runner>(this, Runner.class, itemsPerPage, formData.asMap(), "runners");
    }

    public Stream<Runner> getRunnersStream(Runner.RunnerType type, Runner.RunnerStatus status) throws GitLabApiException {
        return this.getRunners(type, status, this.getDefaultPerPage()).stream();
    }

    public List<Runner> getAllRunners() throws GitLabApiException {
        return this.getAllRunners(null, null, this.getDefaultPerPage()).all();
    }

    public List<Runner> getAllRunners(int page, int perPage) throws GitLabApiException {
        return this.getAllRunners(null, null, page, perPage);
    }

    public Pager<Runner> getAllRunners(int itemsPerPage) throws GitLabApiException {
        return this.getAllRunners(null, null, itemsPerPage);
    }

    public Stream<Runner> getAllRunnersStream() throws GitLabApiException {
        return this.getAllRunners(null, null, this.getDefaultPerPage()).stream();
    }

    public List<Runner> getAllRunners(Runner.RunnerType type, Runner.RunnerStatus status) throws GitLabApiException {
        return this.getAllRunners(type, status, this.getDefaultPerPage()).all();
    }

    public List<Runner> getAllRunners(Runner.RunnerType type, Runner.RunnerStatus status, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm(page, perPage).withParam("type", (Object)type, false).withParam("status", (Object)status, false);
        Response response = this.get(Response.Status.OK, formData.asMap(), "runners", "all");
        return response.readEntity(new GenericType<List<Runner>>(){});
    }

    public Pager<Runner> getAllRunners(Runner.RunnerType type, Runner.RunnerStatus status, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("type", (Object)type, false).withParam("status", (Object)status, false);
        return new Pager<Runner>(this, Runner.class, itemsPerPage, formData.asMap(), "runners", "all");
    }

    public Stream<Runner> getAllRunnersStream(Runner.RunnerType type, Runner.RunnerStatus status) throws GitLabApiException {
        return this.getAllRunners(type, status, this.getDefaultPerPage()).stream();
    }

    public RunnerDetail getRunnerDetail(Long runnerId) throws GitLabApiException {
        if (runnerId == null) {
            throw new RuntimeException("runnerId cannot be null");
        }
        Response response = this.get(Response.Status.OK, null, "runners", runnerId);
        return response.readEntity(RunnerDetail.class);
    }

    public RunnerDetail updateRunner(Long runnerId, String description, Boolean active, List<String> tagList, Boolean runUntagged, Boolean locked, RunnerDetail.RunnerAccessLevel accessLevel) throws GitLabApiException {
        if (runnerId == null) {
            throw new RuntimeException("runnerId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("description", description, false).withParam("active", active, false).withParam("tag_list", tagList, false).withParam("run_untagged", runUntagged, false).withParam("locked", locked, false).withParam("access_level", (Object)accessLevel, false);
        Response response = this.put(Response.Status.OK, formData.asMap(), "runners", runnerId);
        return response.readEntity(RunnerDetail.class);
    }

    public void removeRunner(Long runnerId) throws GitLabApiException {
        if (runnerId == null) {
            throw new RuntimeException("runnerId cannot be null");
        }
        this.delete(Response.Status.NO_CONTENT, null, "runners", runnerId);
    }

    public List<Job> getJobs(Long runnerId) throws GitLabApiException {
        return this.getJobs(runnerId, null, this.getDefaultPerPage()).all();
    }

    public Stream<Job> getJobsStream(Long runnerId) throws GitLabApiException {
        return this.getJobs(runnerId, null, this.getDefaultPerPage()).stream();
    }

    public List<Job> getJobs(Long runnerId, JobStatus status) throws GitLabApiException {
        return this.getJobs(runnerId, status, this.getDefaultPerPage()).all();
    }

    public Stream<Job> getJobsStream(Long runnerId, JobStatus status) throws GitLabApiException {
        return this.getJobs(runnerId, status, this.getDefaultPerPage()).stream();
    }

    public Pager<Job> getJobs(Long runnerId, int itemsPerPage) throws GitLabApiException {
        return this.getJobs(runnerId, null, itemsPerPage);
    }

    public Pager<Job> getJobs(Long runnerId, JobStatus status, int itemsPerPage) throws GitLabApiException {
        if (runnerId == null) {
            throw new RuntimeException("runnerId cannot be null");
        }
        GitLabApiForm formData = new GitLabApiForm().withParam("status", (Object)status, false);
        return new Pager<Job>(this, Job.class, itemsPerPage, formData.asMap(), "runners", runnerId, "jobs");
    }

    public List<Runner> getProjectRunners(Object projectIdOrPath) throws GitLabApiException {
        return this.getProjectRunners(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public Stream<Runner> getProjectRunnersStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getProjectRunners(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public Pager<Runner> getProjectRunners(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Runner>(this, Runner.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "runners");
    }

    public Runner enableRunner(Object projectIdOrPath, Long runnerId) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("runner_id", runnerId, true);
        Response response = this.post(Response.Status.CREATED, formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "runners");
        return response.readEntity(Runner.class);
    }

    public Runner disableRunner(Object projectIdOrPath, Long runnerId) throws GitLabApiException {
        Response response = this.delete(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "runners", runnerId);
        return response.readEntity(Runner.class);
    }

    public RunnerDetail registerRunner(String token, String description, Boolean active, List<String> tagList, Boolean runUntagged, Boolean locked, Integer maximumTimeout) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("token", token, true).withParam("description", description, false).withParam("active", active, false).withParam("locked", locked, false).withParam("run_untagged", runUntagged, false).withParam("tag_list", tagList, false).withParam("maximum_timeout", maximumTimeout, false);
        Response response = this.post(Response.Status.CREATED, (Form)formData, "runners");
        return response.readEntity(RunnerDetail.class);
    }

    public void deleteRunner(String token) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("token", token, true);
        this.delete(Response.Status.NO_CONTENT, formData.asMap(), "runners");
    }
}

