/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.azuredevops.internal.domain;

import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.tm.bugtracker.advanceddomain.CommonConfigurationKey;
import org.squashtest.tm.bugtracker.advanceddomain.Field;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.bugtracker.advanceddomain.InputType;
import org.squashtest.tm.bugtracker.advanceddomain.Rendering;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.caching.AzureDevopsCachedValues;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.caching.AzureDevopsValueCacheManager;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.AzureDevOpsClient;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.AzureField;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.CustomizationType;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.FieldDetails;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.GenericListResponse;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.Layout;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.Nodes;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.Team;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.TeamMember;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.Template;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.client.model.WorkItemType;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.domain.CommonReferenceNames;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.domain.FieldVisibilityStrategy;
import org.squashtest.tm.plugin.bugtracker.azuredevops.internal.domain.ProjectReferentialData;

@Component(value="squash.tm.plugin.bugtracker.azure.devops.SchemeBuilder")
public class SchemeBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemeBuilder.class);
    private static final String ASSIGNEE_ID = CommonReferenceNames.AssignedTo.value;
    private static final String AREA_ID = CommonReferenceNames.Area.value;
    private static final String ITERATION_ID = CommonReferenceNames.Iteration.value;
    private static final String TAG_ID = CommonReferenceNames.Tags.value;
    private static final String WORK_ITEM_TYPE_ID = CommonReferenceNames.WorkItemType.value;
    private static final String DESCRIPTION_FIELD_ID = CommonReferenceNames.Description.value;
    private static final String TITLE_ID = CommonReferenceNames.Title.value;
    public static final String ATTACHMENTS_FIELD_ID = "attachments";
    public static final String TEMPLATE_FIELD_ID = "template";
    public static final String NONE_OPTION_ID = "~squashNone";
    public static final String DEFAULT_TEMPLATE_OPTION_ID = "~defaultSquashTemplate";
    private final MessageSource messageSource;
    private final AzureDevopsValueCacheManager azureDevopsValueCacheManager;
    private Optional<AzureDevopsCachedValues> cachedValues;

    SchemeBuilder(@Named(value="azureDevOpsConnectorMessageSource") MessageSource messageSource, AzureDevopsValueCacheManager azureDevopsValueCacheManager) {
        this.messageSource = messageSource;
        this.azureDevopsValueCacheManager = azureDevopsValueCacheManager;
    }

    public static String getPrefixSeparator() {
        return "~";
    }

    public static String buildPrefixedId(WorkItemType wit, String id) {
        return SchemeBuilder.buildPrefixedId(wit.getName(), id);
    }

    public static String buildPrefixedId(String witName, String id) {
        return String.format("%s%s%s", witName, SchemeBuilder.getPrefixSeparator(), id);
    }

    public static String removeWorkItemTypePrefix(String key, String workItemType) {
        String prefix = workItemType + SchemeBuilder.getPrefixSeparator();
        return key.replaceFirst(prefix, "");
    }

    public static String tryToRemovePrefix(String prefixedFieldId) {
        String[] tokens = prefixedFieldId.split(SchemeBuilder.getPrefixSeparator());
        if (tokens.length == 2) {
            return tokens[1];
        }
        return prefixedFieldId;
    }

    public Map<String, List<Field>> buildSchemes(ProjectReferentialData projectReferentialData, AzureDevOpsClient client, BugTracker bugTracker) {
        FieldValue[] possibleUsers;
        String projectPath = projectReferentialData.getProjectPath();
        this.cachedValues = this.azureDevopsValueCacheManager.isCacheEnabled(bugTracker.getId()) ? this.azureDevopsValueCacheManager.findCachedValues(bugTracker, projectPath) : Optional.empty();
        HashMap<String, List<Field>> scheme = new HashMap<String, List<Field>>();
        GenericListResponse<Team> teams = client.getTeams(projectPath);
        if (this.cachedValues.isPresent()) {
            ArrayList<FieldValue> teamMemberCachedValues = new ArrayList<FieldValue>(this.cachedValues.get().teamMembers().stream().map(this::teamMemberToFieldValue).toList());
            teamMemberCachedValues.add(0, this.buildNoneOption());
            possibleUsers = teamMemberCachedValues.toArray(new FieldValue[0]);
        } else {
            possibleUsers = this.getPossibleTeamMemberValues(client, projectPath, teams).toArray(new FieldValue[0]);
        }
        FieldValue[] possibleTags = this.cachedValues.isPresent() ? (FieldValue[])List.of((FieldValue[])this.cachedValues.get().tags().stream().map(tag -> new FieldValue(tag.getId(), tag.getName())).toArray(FieldValue[]::new)).toArray(FieldValue[]::new) : (FieldValue[])client.findAllTags(projectPath).stream().map(tag -> new FieldValue(tag.getId(), tag.getName())).toArray(FieldValue[]::new);
        Field attachmentsField = this.generateAttachmentsField();
        for (WorkItemType workItemType : projectReferentialData.workItemTypes) {
            Optional<Layout> layout = this.getOptionalLayout(projectReferentialData, client, workItemType);
            String schemeName = CommonReferenceNames.WorkItemType.value + ":" + workItemType.getName();
            ArrayList<Field> fields = new ArrayList<Field>();
            fields.add(this.generateWorkItemTypeField(projectReferentialData.workItemTypes));
            fields.add(this.generateTitleField());
            fields.add(0, this.generateTemplateField(teams, client, workItemType, projectReferentialData));
            fields.add(this.generateAssigneeField(possibleUsers, workItemType));
            fields.add(this.generateAreaField(client, projectPath, workItemType));
            fields.add(this.generateIterationField(client, projectPath, workItemType));
            fields.add(this.generateTagsFields(possibleTags, workItemType));
            fields.add(attachmentsField);
            fields.addAll(this.generateWritableFields(projectReferentialData, workItemType, client, layout, possibleUsers));
            scheme.put(schemeName, fields);
        }
        return scheme;
    }

    private Field generateTemplateField(GenericListResponse<Team> teams, AzureDevOpsClient client, WorkItemType wit, ProjectReferentialData projectReferentialData) {
        String label = this.messageSource.getMessage("interface.report.template.label", null, LocaleContextHolder.getLocale());
        Field templateField = this.createDropdownListField(TEMPLATE_FIELD_ID, label);
        InputType inputType = templateField.getRendering().getInputType();
        ArrayList<FieldValue> possibleTemplates = new ArrayList<FieldValue>();
        teams.getValue().forEach(team -> {
            try {
                GenericListResponse<Template> templates = client.getTemplates(projectReferentialData.organizationName, projectReferentialData.project.getId(), team.getId());
                possibleTemplates.addAll(templates.getValue().stream().filter(template -> template.getWorkItemTypeName().equals(wit.getName())).map(template -> new FieldValue(template.getUrl(), template.getName())).collect(Collectors.toList()));
            }
            catch (BugTrackerRemoteException ex) {
                LOGGER.warn("Could not fetch templates for team " + team.getName(), (Throwable)ex);
            }
        });
        possibleTemplates.add(0, this.buildDefaultTemplateOption());
        templateField.setPossibleValues(possibleTemplates.toArray(new FieldValue[0]));
        String confirmMessage = this.messageSource.getMessage("interface.report.confirm-template-change", null, LocaleContextHolder.getLocale());
        inputType.addConfiguration(CommonConfigurationKey.CONFIRM_MESSAGE.value, confirmMessage);
        inputType.addConfiguration(CommonConfigurationKey.ONCHANGE.value, "set_template");
        return templateField;
    }

    private Field generateTagsFields(FieldValue[] possibleTags, WorkItemType wit) {
        String label = this.messageSource.getMessage("interface.report.tags.label", null, LocaleContextHolder.getLocale());
        Field field = this.createBasicField(SchemeBuilder.buildPrefixedId(wit, TAG_ID), label, InputType.TypeName.TAG_LIST.value);
        field.setPossibleValues(possibleTags);
        return field;
    }

    private Field generateAssigneeField(FieldValue[] possibleTeamMembers, WorkItemType wit) {
        String label = this.messageSource.getMessage("interface.report.assignee.label", null, LocaleContextHolder.getLocale());
        Field field = this.createDropdownListField(SchemeBuilder.buildPrefixedId(wit, ASSIGNEE_ID), label);
        field.setPossibleValues(possibleTeamMembers);
        return field;
    }

    private List<FieldValue> getPossibleTeamMemberValues(AzureDevOpsClient client, String projectPath, GenericListResponse<Team> teams) {
        List<FieldValue> possibleAssignees = client.findTeamMembers(projectPath, teams).stream().map(this::teamMemberToFieldValue).collect(Collectors.toList());
        possibleAssignees.add(0, this.buildNoneOption());
        return possibleAssignees;
    }

    private FieldValue teamMemberToFieldValue(TeamMember teamMember) {
        String fieldId = String.format("%s <%s>", teamMember.getIdentity().getDisplayName(), teamMember.getIdentity().getUniqueName());
        return new FieldValue(fieldId, teamMember.getIdentity().getDisplayName());
    }

    private Field generateAreaField(AzureDevOpsClient client, String projectPath, WorkItemType wit) {
        String label = this.messageSource.getMessage("interface.report.area.label", null, LocaleContextHolder.getLocale());
        Field field = this.createTreeSelectField(SchemeBuilder.buildPrefixedId(wit, AREA_ID), label);
        Nodes rootNode = this.cachedValues.isPresent() ? this.cachedValues.get().areas() : client.getProjectAreas(projectPath);
        rootNode.sortTreeByName();
        FieldValue value = this.nodeToFieldValue(rootNode, "");
        field.setPossibleValues(new FieldValue[]{value});
        return field;
    }

    private Field generateIterationField(AzureDevOpsClient client, String projectPath, WorkItemType wit) {
        String label = this.messageSource.getMessage("interface.report.iteration.label", null, LocaleContextHolder.getLocale());
        Field field = this.createTreeSelectField(SchemeBuilder.buildPrefixedId(wit, ITERATION_ID), label);
        Nodes rootNode = this.cachedValues.isPresent() ? this.cachedValues.get().iterations() : client.getProjectIterations(projectPath);
        rootNode.sortTreeByName();
        FieldValue value = this.nodeToFieldValue(rootNode, "");
        field.setPossibleValues(new FieldValue[]{value});
        return field;
    }

    private FieldValue nodeToFieldValue(Nodes node, String path) {
        String nodePath = path.equals("") ? node.getName() : path + "\\" + node.getName();
        FieldValue fieldValue = new FieldValue(nodePath, node.getName());
        if (node.hasChildren()) {
            fieldValue.setComposite((FieldValue[])node.getChildren().stream().map(childNode -> this.nodeToFieldValue((Nodes)childNode, nodePath)).toArray(FieldValue[]::new));
        }
        return fieldValue;
    }

    private Field generateAttachmentsField() {
        String label = this.messageSource.getMessage("interface.report.attachments.label", null, LocaleContextHolder.getLocale());
        return this.createBasicField(ATTACHMENTS_FIELD_ID, label, InputType.TypeName.FILE_UPLOAD.value);
    }

    private List<Field> generateWritableFields(ProjectReferentialData projectReferentialData, WorkItemType workItemType, AzureDevOpsClient client, Optional<Layout> layout, FieldValue[] possibleUsers) {
        String organizationName = projectReferentialData.organizationName;
        String projectName = projectReferentialData.project.getName();
        String processTemplateTypeId = projectReferentialData.processTemplateTypeId;
        List<AzureField> writableFields = workItemType.getAzureDevOpsFieldList();
        FieldVisibilityStrategy strategy = layout.isPresent() ? new FieldVisibilityStrategy.LayoutBased(layout.get()) : new FieldVisibilityStrategy.Patch();
        String processName = projectReferentialData.rootProcessName;
        return client.getFieldDetails(organizationName, projectName, writableFields).stream().filter(fieldDetails -> !fieldDetails.isReadOnly()).map(fieldDetails -> this.buildWritableField(workItemType, client, organizationName, processTemplateTypeId, (FieldDetails)fieldDetails, possibleUsers, strategy, processName, layout)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Field buildWritableField(WorkItemType workItemType, AzureDevOpsClient client, String organizationName, String processTemplateTypeId, FieldDetails fieldDetails, FieldValue[] possibleUsers, FieldVisibilityStrategy fieldVisibilityStrategy, String rootProcessName, Optional<Layout> optionalLayout) {
        if (!fieldVisibilityStrategy.isFieldVisible(rootProcessName, fieldDetails.getReferenceName(), workItemType)) {
            return null;
        }
        String refName = SchemeBuilder.buildPrefixedId(workItemType, fieldDetails.getReferenceName());
        String label = optionalLayout.isPresent() ? this.findFieldLabelInLayout(fieldDetails.getReferenceName(), optionalLayout.get(), fieldDetails.getName()) : fieldDetails.getName();
        switch (fieldDetails.getType()) {
            case "dateTime": {
                return this.createBasicField(refName, label, InputType.TypeName.DATE_TIME.value);
            }
            case "double": {
                return this.createDropdownOrSimpleField(client, organizationName, processTemplateTypeId, workItemType, refName, fieldDetails, InputType.TypeName.DECIMAL, label);
            }
            case "string": {
                if (fieldDetails.isIdentity()) {
                    Field identity = this.createDropdownListField(refName, label);
                    identity.setPossibleValues(possibleUsers);
                    return identity;
                }
                if (fieldDetails.isPicklist()) {
                    Field pickList = this.createDropdownListField(refName, label);
                    pickList.setPossibleValues(this.getPickListPossibleValues(client, organizationName, processTemplateTypeId, workItemType.getReferenceName(), fieldDetails.getReferenceName()).toArray(new FieldValue[0]));
                    return pickList;
                }
                return this.createDropdownOrSimpleField(client, organizationName, processTemplateTypeId, workItemType, refName, fieldDetails, InputType.TypeName.TEXT_FIELD, label);
            }
            case "boolean": {
                return this.createBasicField(refName, label, InputType.TypeName.CHECKBOX.value);
            }
            case "integer": {
                if (fieldDetails.isPicklist()) {
                    Field pickList = this.createDropdownListField(refName, label);
                    pickList.setPossibleValues(this.getPickListPossibleValues(client, organizationName, processTemplateTypeId, workItemType.getReferenceName(), fieldDetails.getReferenceName()).toArray(new FieldValue[0]));
                    return pickList;
                }
                return this.createDropdownOrSimpleField(client, organizationName, processTemplateTypeId, workItemType, refName, fieldDetails, InputType.TypeName.INTEGER, label);
            }
            case "html": {
                return this.createBasicField(refName, label, InputType.TypeName.RICH_TEXT.value);
            }
        }
        return null;
    }

    private String findFieldLabelInLayout(String refName, Layout layout, String defaultName) {
        for (Layout.Page page : layout.getPages()) {
            for (Layout.Section section : page.getSections()) {
                for (Layout.Group group : section.getGroups()) {
                    for (Layout.Control control : group.getControls()) {
                        if (!refName.equals(control.getId())) continue;
                        return control.getLabel();
                    }
                }
            }
        }
        return defaultName;
    }

    private Field createDropdownOrSimpleField(AzureDevOpsClient client, String organizationName, String processTemplateTypeId, WorkItemType workItemType, String fieldRefName, FieldDetails fieldDetails, InputType.TypeName typeName, String label) {
        List<FieldValue> maybePossibleValues = this.getPickListPossibleValues(client, organizationName, processTemplateTypeId, workItemType.getReferenceName(), fieldDetails.getReferenceName());
        if (maybePossibleValues.size() > 0) {
            Field pickList = this.createDropdownListField(fieldRefName, label);
            pickList.setPossibleValues(maybePossibleValues.toArray(new FieldValue[0]));
            return pickList;
        }
        return this.createBasicField(fieldRefName, label, typeName.value);
    }

    private List<FieldValue> getPickListPossibleValues(AzureDevOpsClient client, String organizationName, String processTemplateTypeId, String workItemType, String fieldRefName) {
        try {
            return client.findPickListValues(organizationName, processTemplateTypeId, workItemType, fieldRefName).stream().map(value -> new FieldValue(value, value)).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return Collections.emptyList();
        }
    }

    private Field createTreeSelectField(String id, String label) {
        return this.createBasicField(id, label, InputType.TypeName.TREE_SELECT.value);
    }

    private FieldValue buildNoneOption() {
        String label = this.messageSource.getMessage("interface.report.option.none", null, LocaleContextHolder.getLocale());
        return new FieldValue(NONE_OPTION_ID, label);
    }

    private FieldValue buildDefaultTemplateOption() {
        String label = this.messageSource.getMessage("interface.report.option.default", null, LocaleContextHolder.getLocale());
        return new FieldValue(DEFAULT_TEMPLATE_OPTION_ID, label);
    }

    protected Field generateTitleField() {
        String label = this.messageSource.getMessage("interface.report.title.label", null, LocaleContextHolder.getLocale());
        Field field = this.generateTextField(TITLE_ID, label);
        field.getRendering().setRequired(true);
        return field;
    }

    private Field generateTextField(String id, String label) {
        return this.createBasicField(id, label, InputType.TypeName.TEXT_FIELD.value);
    }

    protected Field generateWorkItemTypeField(List<WorkItemType> workItemTypes) {
        String label = this.messageSource.getMessage("interface.report.work-item-type.label", null, LocaleContextHolder.getLocale());
        Field field = this.createDropdownListField(WORK_ITEM_TYPE_ID, label);
        field.getRendering().setRequired(true);
        field.getRendering().getInputType().setFieldSchemeSelector(true);
        FieldValue[] possibleTypes = (FieldValue[])workItemTypes.stream().map(type -> new FieldValue(type.getName(), type.getName())).toArray(FieldValue[]::new);
        field.setPossibleValues(possibleTypes);
        return field;
    }

    private Field createDropdownListField(String id, String label) {
        return this.createBasicField(id, label, InputType.TypeName.DROPDOWN_LIST.value);
    }

    private Field createBasicField(String id, String label, String type) {
        Field field = new Field(id, label);
        Rendering rendering = new Rendering();
        InputType inputType = new InputType(type, InputType.TypeName.UNKNOWN.value);
        rendering.setInputType(inputType);
        field.setRendering(rendering);
        if (InputType.TypeName.RICH_TEXT.value.equals(type)) {
            inputType.addConfiguration(CommonConfigurationKey.RENDER_AS_HTML.value, "true");
        }
        return field;
    }

    public Optional<Layout> getOptionalLayout(ProjectReferentialData projectReferentialData, AzureDevOpsClient client, WorkItemType workItemType) {
        if (projectReferentialData.isSystemProcess || CustomizationType.SYSTEM.value.equals(workItemType.getCustomization())) {
            return Optional.empty();
        }
        Layout layout = client.getLayout(projectReferentialData.organizationName, projectReferentialData.processTemplateTypeId, workItemType.getReferenceName());
        return Optional.of(layout);
    }
}

