/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.campaignassessment.data;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import jakarta.persistence.EntityManager;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.jooq.DSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.squashtest.tm.api.report.criteria.Criteria;
import org.squashtest.tm.api.report.exception.PerimeterNotAvailableException;
import org.squashtest.tm.api.utils.AttachmentImageHelper;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.plugin.report.campaignassessment.data.AbstractReportDataBuilder;
import org.squashtest.tm.plugin.report.campaignassessment.dto.AbstractTupleTemplate;
import org.squashtest.tm.plugin.report.campaignassessment.dto.I18nHelper;
import org.squashtest.tm.plugin.report.campaignassessment.dto.IterationInfo;
import org.squashtest.tm.plugin.report.campaignassessment.dto.IterationTupleTemplate;
import org.squashtest.tm.plugin.report.campaignassessment.dto.Queries;
import org.squashtest.tm.plugin.report.campaignassessment.form.IterationFormParameter;
import org.squashtest.tm.service.bugtracker.BugTrackersLocalService;
import org.squashtest.tm.service.bugtracker.BugTrackersService;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.AbstractDefaultLocalKnownIssueFinder;
import org.squashtest.tm.service.internal.bugtracker.knownissues.local.IterationKnownIssueFinder;
import org.squashtest.tm.service.internal.repository.display.EntityPathHeaderDao;
import org.squashtest.tm.service.project.CustomProjectFinder;

@Component
public class IterationReportDataBuilder
extends AbstractReportDataBuilder {
    private static final Logger LOGGER;
    private static final String ITERATION_FILE_NAME_I18N_KEY = "report.iteration.file.name";
    private static final String ITERATIONS = "iterations";
    private final IterationKnownIssueFinder iterationKnownIssueFinder;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public IterationReportDataBuilder(I18nHelper i18nHelper, EntityManager entityManager, EntityPathHeaderDao entityPathHeaderDao, BugTrackersLocalService bugTrackersLocalService, BugTrackersService bugTrackersService, AttachmentImageHelper attachmentImageHelper, DSLContext dslContext, CustomProjectFinder customProjectFinder, IterationKnownIssueFinder iterationKnownIssueFinder) {
        super(i18nHelper, entityManager, entityPathHeaderDao, bugTrackersLocalService, bugTrackersService, attachmentImageHelper, dslContext, customProjectFinder);
        IterationKnownIssueFinder iterationKnownIssueFinder2;
        this.iterationKnownIssueFinder = iterationKnownIssueFinder2 = iterationKnownIssueFinder;
    }

    @Override
    public Map<String, Object> build(Map<String, Criteria> formParameters, Map<String, Object> results) {
        IndyInterface.bootstrap("invoke", "debug", 0, LOGGER, "Starting iteration report data generation.");
        CallSite iterations = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "fetchIterationsInfo", 2, this, formParameters));
        IndyInterface.bootstrap("invoke", "debug", 0, LOGGER, "Readable iteration count: {}", IndyInterface.bootstrap("invoke", "size", 0, iterations));
        CallSite reportData = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "buildIterationDataMap", 2, this, formParameters, iterations, results));
        IndyInterface.bootstrap("invoke", "addReportMetadata", 2, this, formParameters, reportData);
        IndyInterface.bootstrap("invoke", "debug", 0, LOGGER, "Iteration report data generation completed.");
        return reportData;
    }

    private void addReportMetadata(Map<String, Criteria> formParameters, Map<String, Object> reportData) {
        IndyInterface.bootstrap("invoke", "addCommonReportMetadata", 2, this, formParameters, reportData, ITERATION_FILE_NAME_I18N_KEY, IndyInterface.bootstrap("invoke", "getKey", 0, IndyInterface.bootstrap("getProperty", "TEMPLATE_FILE_NAME", 0, IterationFormParameter.class)));
        IndyInterface.bootstrap("invoke", "putAll", 0, reportData, IndyInterface.bootstrap("invoke", "getIterationI18nLabels", 0, IndyInterface.bootstrap("getProperty", "i18nStringProvider", 12, this)));
    }

    private List<IterationInfo> fetchIterationsInfo(Map<String, Object> formParameters) {
        CallSite iterations = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "fetchIterationsFromDb", 2, this, formParameters));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, iterations)) != false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, PerimeterNotAvailableException.class));
        }
        return iterations;
    }

    private List<IterationInfo> fetchIterationsFromDb(Map<String, Object> formParameters) {
        CallSite iterationIds = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "extractIterationIds", 0, IterationReportDataBuilder.class, formParameters));
        CallSite readableProjectIds = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findReadableProjectIdsOnCampaignLibrary", 0, IndyInterface.bootstrap("getProperty", "customProjectFinder", 12, this)));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "fetchInto", 0, IndyInterface.bootstrap("invoke", "where", 0, IndyInterface.bootstrap("invoke", "buildBaseIterationQuery", 2, this), IndyInterface.bootstrap("invoke", "and", 0, IndyInterface.bootstrap("invoke", "in", 0, IndyInterface.bootstrap("getProperty", "ITERATION_ID", 0, IndyInterface.bootstrap("getProperty", "ITERATION", 0, Tables.class)), iterationIds), IndyInterface.bootstrap("invoke", "in", 0, IndyInterface.bootstrap("getProperty", "PROJECT_ID", 0, IndyInterface.bootstrap("getProperty", "PROJECT", 0, Tables.class)), readableProjectIds))), IterationInfo.class));
    }

    private static List<Long> extractIterationIds(Map<String, Object> formParameters) {
        Criteria param = (Criteria)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "get", 0, formParameters, IndyInterface.bootstrap("invoke", "getKey", 0, IndyInterface.bootstrap("getProperty", "ITERATION_IDS", 0, IterationFormParameter.class))), Criteria.class);
        if (!(IndyInterface.bootstrap("invoke", "getValue", 1, param) instanceof Map)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, "Invalid iteration parameter format"));
        }
        Map idsData = (Map)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getValue", 0, param), Map.class));
        List idList = (List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "get", 0, idsData, ITERATIONS), List.class));
        public final class _extractIterationIds_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _extractIterationIds_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "toLong", 0, IndyInterface.bootstrap("invoke", "toString", 0, it));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractIterationIds_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, idList, new _extractIterationIds_closure1(IterationReportDataBuilder.class, IterationReportDataBuilder.class)));
    }

    public Map<String, Object> buildIterationDataMap(Map<String, Criteria> formParameters, List<IterationInfo> iterations, Map<String, Object> results) {
        CallSite iterationDataMap = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
        CallSite iterationList = IndyInterface.bootstrap("invoke", "buildTemplateFriendlyIterationData", 2, this, iterations, results);
        IndyInterface.bootstrap("invoke", "put", 0, iterationDataMap, ITERATIONS, IndyInterface.bootstrap("invoke", "buildIterationsBasicData", 0, IterationReportDataBuilder.class, iterationList));
        IndyInterface.bootstrap("invoke", "put", 0, iterationDataMap, "iterationsByCampaign", IndyInterface.bootstrap("invoke", "buildCampaignIterationsData", 0, IterationReportDataBuilder.class, iterationList));
        IndyInterface.bootstrap("invoke", "addLegacyIterationFields", 0, IterationReportDataBuilder.class, IndyInterface.bootstrap("invoke", "get", 0, iterationList, false), iterationDataMap);
        boolean includeAnnex = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "getValue", 0, IndyInterface.bootstrap("invoke", "get", 0, formParameters, IndyInterface.bootstrap("invoke", "getKey", 0, IndyInterface.bootstrap("getProperty", "INCLUDE_ANNEX", 0, IterationFormParameter.class)))));
        boolean includeTestSuiteDetail = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "getValue", 0, IndyInterface.bootstrap("invoke", "get", 0, formParameters, IndyInterface.bootstrap("invoke", "getKey", 0, IndyInterface.bootstrap("getProperty", "INCLUDE_TEST_SUITE_DETAIL", 0, IterationFormParameter.class)))));
        IndyInterface.bootstrap("invoke", "put", 0, iterationDataMap, "includeAnnex", includeAnnex);
        IndyInterface.bootstrap("invoke", "put", 0, iterationDataMap, "includeTestSuiteDetail", includeTestSuiteDetail);
        IndyInterface.bootstrap("invoke", "putAll", 0, iterationDataMap, IndyInterface.bootstrap("invoke", "getComputedData", 2, this, iterationList, includeAnnex, includeTestSuiteDetail));
        IndyInterface.bootstrap("invoke", "putAll", 0, iterationDataMap, IndyInterface.bootstrap("invoke", "getIssuesData", 2, this, formParameters, iterationList));
        return iterationDataMap;
    }

    private static void addLegacyIterationFields(Map<String, Object> iteration, Map<String, Object> iterationDataMap) {
        IndyInterface.bootstrap("invoke", "put", 0, iterationDataMap, "iterationName", IndyInterface.bootstrap("invoke", "get", 0, iteration, "name"));
        IndyInterface.bootstrap("invoke", "put", 0, iterationDataMap, "iterationDescription", IndyInterface.bootstrap("invoke", "get", 0, iteration, "description"));
        IndyInterface.bootstrap("invoke", "put", 0, iterationDataMap, "iterationReference", IndyInterface.bootstrap("invoke", "get", 0, iteration, "reference"));
        IndyInterface.bootstrap("invoke", "put", 0, iterationDataMap, "estimatedStartDate", IndyInterface.bootstrap("invoke", "get", 0, iteration, "estimatedStartDate"));
        IndyInterface.bootstrap("invoke", "put", 0, iterationDataMap, "estimatedEndDate", IndyInterface.bootstrap("invoke", "get", 0, iteration, "estimatedEndDate"));
        IndyInterface.bootstrap("invoke", "put", 0, iterationDataMap, "realizedStartDate", IndyInterface.bootstrap("invoke", "get", 0, iteration, "realizedStartDate"));
        IndyInterface.bootstrap("invoke", "put", 0, iterationDataMap, "realizedEndDate", IndyInterface.bootstrap("invoke", "get", 0, iteration, "realizedEndDate"));
        IndyInterface.bootstrap("invoke", "put", 0, iterationDataMap, "noEstimatedStartDate", IndyInterface.bootstrap("invoke", "get", 0, iteration, "noEstimatedStartDate"));
        IndyInterface.bootstrap("invoke", "put", 0, iterationDataMap, "noEstimatedEndDate", IndyInterface.bootstrap("invoke", "get", 0, iteration, "noEstimatedEndDate"));
        IndyInterface.bootstrap("invoke", "put", 0, iterationDataMap, "noRealizedStartDate", IndyInterface.bootstrap("invoke", "get", 0, iteration, "noRealizedStartDate"));
        IndyInterface.bootstrap("invoke", "put", 0, iterationDataMap, "noRealizedEndDate", IndyInterface.bootstrap("invoke", "get", 0, iteration, "noRealizedEndDate"));
    }

    public static List<Map<String, Object>> buildIterationsBasicData(List<Map<String, Object>> iterations) {
        CallSite iterationBasicData = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class));
        CallSite iteration = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, iterations));
        if (callSite != null) {
            while (callSite.hasNext()) {
                iteration = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                CallSite iterationValues = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "parentPath", IndyInterface.bootstrap("invoke", "get", 0, iteration, "parentPath"));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "path", IndyInterface.bootstrap("invoke", "get", 0, iteration, "path"));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "fullName", IndyInterface.bootstrap("invoke", "get", 0, iteration, "fullName"));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "reference", IndyInterface.bootstrap("invoke", "get", 0, iteration, "reference"));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "description", IndyInterface.bootstrap("invoke", "get", 0, iteration, "description"));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "noDescription", IndyInterface.bootstrap("invoke", "get", 0, iteration, "noDescription"));
                IndyInterface.bootstrap("invoke", "add", 0, iterationBasicData, iterationValues);
            }
        }
        return iterationBasicData;
    }

    public static List<Map<String, Object>> buildCampaignIterationsData(List<Map<String, Object>> iterations) {
        public final class _buildCampaignIterationsData_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildCampaignIterationsData_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "getAt", 0, it, "parentPath");
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildCampaignIterationsData_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite iterationsGroupedByCampaign = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "groupBy", 0, iterations, ScriptBytecodeAdapter.createGroovyObjectWrapper((GroovyObject)new _buildCampaignIterationsData_closure2(IterationReportDataBuilder.class, IterationReportDataBuilder.class), Closure.class)));
        CallSite campaignIterations = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class));
        CallSite entry = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("invoke", "entrySet", 0, iterationsGroupedByCampaign)));
        if (callSite != null) {
            while (callSite.hasNext()) {
                entry = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                CallSite campaignPath = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getKey", 0, entry));
                CallSite iterationsForCampaign = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getValue", 0, entry));
                CallSite iterationViews = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class));
                CallSite iteration = null;
                CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, iterationsForCampaign));
                if (callSite2 != null) {
                    while (callSite2.hasNext()) {
                        iteration = IndyInterface.bootstrap("cast", "()", 0, callSite2.next());
                        CallSite iterMap = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
                        IndyInterface.bootstrap("invoke", "put", 0, iterMap, "name", IndyInterface.bootstrap("invoke", "get", 0, iteration, "name"));
                        IndyInterface.bootstrap("invoke", "put", 0, iterMap, "reference", IndyInterface.bootstrap("invoke", "get", 0, iteration, "reference"));
                        IndyInterface.bootstrap("invoke", "put", 0, iterMap, "estimatedStartDate", IndyInterface.bootstrap("invoke", "get", 0, iteration, "estimatedStartDate"));
                        IndyInterface.bootstrap("invoke", "put", 0, iterMap, "estimatedEndDate", IndyInterface.bootstrap("invoke", "get", 0, iteration, "estimatedEndDate"));
                        IndyInterface.bootstrap("invoke", "put", 0, iterMap, "realizedStartDate", IndyInterface.bootstrap("invoke", "get", 0, iteration, "realizedStartDate"));
                        IndyInterface.bootstrap("invoke", "put", 0, iterMap, "realizedEndDate", IndyInterface.bootstrap("invoke", "get", 0, iteration, "realizedEndDate"));
                        IndyInterface.bootstrap("invoke", "put", 0, iterMap, "noEstimatedStartDate", IndyInterface.bootstrap("invoke", "get", 0, iteration, "noEstimatedStartDate"));
                        IndyInterface.bootstrap("invoke", "put", 0, iterMap, "noEstimatedEndDate", IndyInterface.bootstrap("invoke", "get", 0, iteration, "noEstimatedEndDate"));
                        IndyInterface.bootstrap("invoke", "put", 0, iterMap, "noRealizedStartDate", IndyInterface.bootstrap("invoke", "get", 0, iteration, "noRealizedStartDate"));
                        IndyInterface.bootstrap("invoke", "put", 0, iterMap, "noRealizedEndDate", IndyInterface.bootstrap("invoke", "get", 0, iteration, "noRealizedEndDate"));
                        IndyInterface.bootstrap("invoke", "add", 0, iterationViews, iterMap);
                    }
                }
                CallSite campaignMap = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
                IndyInterface.bootstrap("invoke", "put", 0, campaignMap, "campaignPath", campaignPath);
                IndyInterface.bootstrap("invoke", "put", 0, campaignMap, ITERATIONS, iterationViews);
                IndyInterface.bootstrap("invoke", "add", 0, campaignIterations, campaignMap);
            }
        }
        return campaignIterations;
    }

    public Map<String, Object> getComputedData(List<Map<String, Object>> iterationList, boolean includeAnnex, boolean includeTestSuiteDetail) {
        CallSite result = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
        public final class _getComputedData_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getComputedData_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return (Long)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, "id"), Long.class));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getComputedData_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite iterationIds = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, iterationList, new _getComputedData_closure3(this, this)));
        CallSite rawData = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getRawData", 2, this, iterationIds));
        public final class _getComputedData_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getComputedData_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "suiteId", 0, it), null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getComputedData_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _getComputedData_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getComputedData_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "suiteId", 0, it), IndyInterface.bootstrap("getProperty", "suiteName", 0, it)});
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getComputedData_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _getComputedData_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getComputedData_closure6(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "getAt", 0, it, false);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getComputedData_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _getComputedData_closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getComputedData_closure7(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object a, Object b) {
                return ScriptBytecodeAdapter.compareTo((Object)IndyInterface.bootstrap("invoke", "getAt", 0, a, true), (Object)IndyInterface.bootstrap("invoke", "getAt", 0, b, true));
            }

            @Generated
            public Object call(Object a, Object b) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, a, b);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getComputedData_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _getComputedData_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getComputedData_closure8(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, it, false), IndyInterface.bootstrap("invoke", "getAt", 0, it, true)});
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getComputedData_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite testSuiteMap = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, IndyInterface.bootstrap("invoke", "sort", 0, IndyInterface.bootstrap("invoke", "unique", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "findAll", 0, rawData, new _getComputedData_closure4(this, this)), new _getComputedData_closure5(this, this)), new _getComputedData_closure6(this, this)), new _getComputedData_closure7(this, this)), new _getComputedData_closure8(this, this)));
        public final class _getComputedData_closure9
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getComputedData_closure9(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object tuple) {
                return IndyInterface.bootstrap("invoke", "getItpiId", 0, tuple);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getComputedData_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite dedupRawData = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "unique", 0, rawData, false, new _getComputedData_closure9(this, this)));
        public final class _getComputedData_closure10
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getComputedData_closure10(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object tuple) {
                return ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "getSuiteId", 0, tuple), null) ? IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "multiply", 0, IndyInterface.bootstrap("invoke", "getItpiId", 0, tuple), 17), IndyInterface.bootstrap("invoke", "multiply", 0, IndyInterface.bootstrap("invoke", "getSuiteId", 0, tuple), 31)) : IndyInterface.bootstrap("invoke", "multiply", 0, IndyInterface.bootstrap("invoke", "getItpiId", 0, tuple), 17);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getComputedData_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite dedupRawDataOnSuite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "unique", 0, rawData, false, new _getComputedData_closure10(this, this)));
        IndyInterface.bootstrap("invoke", "putAll", 0, result, IndyInterface.bootstrap("invoke", "calculateTcExecutionByImportance", 2, this, dedupRawData));
        public final class _getComputedData_closure11
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getComputedData_closure11(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, it, "id"), IndyInterface.bootstrap("invoke", "getAt", 0, it, "path")});
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getComputedData_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite iterationIdToParentPath = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, iterationList, new _getComputedData_closure11(this, this)));
        CallSite executionStatusData = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "calculateTestSuiteExecutionStatusData", 2, this, testSuiteMap, dedupRawDataOnSuite, iterationIdToParentPath));
        IndyInterface.bootstrap("invoke", "put", 0, result, "iterationsExecutionStatusData", executionStatusData);
        IndyInterface.bootstrap("invoke", "put", 0, result, "iterationExecutionStatusData", IndyInterface.bootstrap("invoke", "getLegacyExecutionStatusData", 0, IterationReportDataBuilder.class, executionStatusData));
        IndyInterface.bootstrap("invoke", "put", 0, result, "iterationReqDatas", IndyInterface.bootstrap("invoke", "calculateRequirementRates", 2, this, iterationList, rawData));
        if (includeTestSuiteDetail) {
            IndyInterface.bootstrap("invoke", "put", 0, result, "testSuiteReqDatas", IndyInterface.bootstrap("invoke", "calculateRequirementRatesOnTestSuites", 2, this, testSuiteMap, rawData, iterationList));
        }
        if (includeAnnex) {
            IndyInterface.bootstrap("invoke", "put", 0, result, "iterationTcDatas", IndyInterface.bootstrap("invoke", "calculateTcRates", 2, this, iterationList, dedupRawData));
        }
        CallSite lastExecData = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findTuplesForLastExec", 2, this, dedupRawDataOnSuite));
        IndyInterface.bootstrap("invoke", "put", 0, result, "lastExecData", IndyInterface.bootstrap("invoke", "doAllExecutionStatusCount", 2, this, lastExecData));
        IndyInterface.bootstrap("invoke", "put", 0, result, "lastExecRequirementData", IndyInterface.bootstrap("invoke", "calculateLastExecutionRequirementRate", 2, this, rawData));
        return result;
    }

    private static List<Map<String, Object>> getLegacyExecutionStatusData(Map<String, Object> executionStatusData) {
        List result = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        CallSite groupedRows = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, executionStatusData, ITERATIONS));
        if (DefaultTypeTransformation.booleanUnbox((Object)groupedRows) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, groupedRows)) == false) {
            CallSite firstEntry = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, groupedRows, false));
            CallSite rows = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, firstEntry, "testSuites"));
            IndyInterface.bootstrap("invoke", "addAll", 0, result, rows);
        }
        IndyInterface.bootstrap("invoke", "add", 0, result, ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, executionStatusData, "noTestSuite")), Map.class));
        IndyInterface.bootstrap("invoke", "add", 0, result, ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, executionStatusData, "total")), Map.class));
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public List<Map<String, Object>> calculateRequirementRatesOnTestSuites(Map<Long, String> testSuiteMap, List<IterationTupleTemplate> rawData, List<Map<String, Object>> iterationList) {
        void var3_3;
        Reference rawData2 = new Reference(rawData);
        Reference iterationList2 = new Reference((Object)var3_3);
        public final class _calculateRequirementRatesOnTestSuites_closure12
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference rawData;
            private /* synthetic */ Reference iterationList;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _calculateRequirementRatesOnTestSuites_closure12(Object _outerInstance, Object _thisObject, Reference rawData, Reference iterationList) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.rawData = reference2 = rawData;
                this.iterationList = reference = iterationList;
            }

            public Object doCall(List coll, Object entry) {
                Reference suiteId = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "key", 0, entry)));
                CallSite suiteName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "value", 0, entry));
                public final class _closure27
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference suiteId;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure27(Object _outerInstance, Object _thisObject, Reference suiteId) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.suiteId = reference = suiteId;
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getSuiteId", 0, it), (Object)IndyInterface.bootstrap("cast", "()", 0, this.suiteId.get()));
                    }

                    @Generated
                    public Long getSuiteId() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.suiteId.get());
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure27.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite rawDataForOneTestSuite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("cast", "()", 0, this.rawData.get()), new _closure27((Object)this, this.getThisObject(), suiteId)));
                IndyInterface.bootstrap("invoke", "add", 0, coll, IndyInterface.bootstrap("invoke", "calculateRequirementRatesForOneTestSuite", 2, this, rawDataForOneTestSuite, suiteName, IndyInterface.bootstrap("cast", "()", 0, this.iterationList.get())));
                return coll;
            }

            @Generated
            public Object call(List coll, Object entry) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, coll, entry);
            }

            @Generated
            public List getRawData() {
                return IndyInterface.bootstrap("cast", "()", 0, this.rawData.get());
            }

            @Generated
            public List getIterationList() {
                return IndyInterface.bootstrap("cast", "()", 0, this.iterationList.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _calculateRequirementRatesOnTestSuites_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite requirementRates = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "inject", 0, testSuiteMap, ScriptBytecodeAdapter.createList((Object[])new Object[0]), new _calculateRequirementRatesOnTestSuites_closure12(this, this, rawData2, iterationList2)));
        public final class _calculateRequirementRatesOnTestSuites_closure13
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _calculateRequirementRatesOnTestSuites_closure13(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getSuiteId", 0, it), null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _calculateRequirementRatesOnTestSuites_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite rawDataWithoutTestSuite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, (List)rawData2.get(), new _calculateRequirementRatesOnTestSuites_closure13(this, this)));
        IndyInterface.bootstrap("invoke", "add", 0, requirementRates, IndyInterface.bootstrap("invoke", "calculateRequirementRatesForTuplesWithoutTestSuite", 2, this, rawDataWithoutTestSuite));
        return requirementRates;
    }

    public Map<String, Object> calculateRequirementRatesForOneTestSuite(List<IterationTupleTemplate> rawData, String testSuiteName, List<Map<String, Object>> iterationList) {
        Reference rawData2 = new Reference(rawData);
        Map initialValues = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"testSuiteName", testSuiteName, "itCritAggregatedData", ScriptBytecodeAdapter.createList((Object[])new Object[0])});
        public final class _calculateRequirementRatesForOneTestSuite_closure14
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference rawData;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _calculateRequirementRatesForOneTestSuite_closure14(Object _outerInstance, Object _thisObject, Reference rawData) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.rawData = reference = rawData;
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getAt", 0, it, "id"), (Object)IndyInterface.bootstrap("getProperty", "iterationId", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.rawData.get()), false)));
            }

            @Generated
            public List getRawData() {
                return IndyInterface.bootstrap("cast", "()", 0, this.rawData.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _calculateRequirementRatesForOneTestSuite_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite iterationPath = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "find", 0, iterationList, new _calculateRequirementRatesForOneTestSuite_closure14(this, this, rawData2)), "path"));
        IndyInterface.bootstrap("invoke", "put", 0, initialValues, "testSuitePath", IndyInterface.bootstrap("invoke", "buildEntityPath", 0, IterationReportDataBuilder.class, iterationPath, testSuiteName));
        CallSite reqDatas = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "calculateRequirementRatesForReq", 2, this, (List)rawData2.get()));
        IndyInterface.bootstrap("invoke", "putAll", 0, initialValues, IndyInterface.bootstrap("invoke", "sortRequirementRates", 2, this, reqDatas));
        IndyInterface.bootstrap("invoke", "put", 0, initialValues, "itCritAggregatedData", IndyInterface.bootstrap("invoke", "calculateRequirementRatesByCriticality", 2, this, reqDatas));
        return initialValues;
    }

    public Map<String, Object> calculateRequirementRatesForTuplesWithoutTestSuite(List<IterationTupleTemplate> rawData) {
        CallSite noTestSuiteName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "translate", 0, IndyInterface.bootstrap("getProperty", "i18nHelper", 12, this), "report.iteration.nosuite.name"));
        Map initialValues = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"testSuiteName", noTestSuiteName, "testSuitePath", noTestSuiteName, "itCritAggregatedData", ScriptBytecodeAdapter.createList((Object[])new Object[0])});
        CallSite reqDatas = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "calculateRequirementRatesForReq", 2, this, rawData));
        IndyInterface.bootstrap("invoke", "putAll", 0, initialValues, IndyInterface.bootstrap("invoke", "sortRequirementRates", 2, this, reqDatas));
        IndyInterface.bootstrap("invoke", "put", 0, initialValues, "itCritAggregatedData", IndyInterface.bootstrap("invoke", "calculateRequirementRatesByCriticality", 2, this, reqDatas));
        return initialValues;
    }

    public List<Map<String, Object>> calculateRequirementRates(List<Map<String, Object>> iterationList, List<AbstractTupleTemplate> rawData) {
        CallSite requirementRates = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class));
        Reference iteration = new Reference(null);
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, iterationList));
        if (callSite != null) {
            while (callSite.hasNext()) {
                iteration.set((Object)IndyInterface.bootstrap("cast", "()", 0, callSite.next()));
                public final class _calculateRequirementRates_closure15
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference iteration;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _calculateRequirementRates_closure15(Object _outerInstance, Object _thisObject, Reference iteration) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.iteration = reference = iteration;
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getIterationId", 0, it), (Object)IndyInterface.bootstrap("getProperty", "id", 0, IndyInterface.bootstrap("cast", "()", 0, this.iteration.get())));
                    }

                    @Generated
                    public Map getIteration() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.iteration.get());
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _calculateRequirementRates_closure15.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite rawDataForOneIt = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, rawData, new _calculateRequirementRates_closure15(this, this, iteration)));
                CallSite rate = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "calculateRequirementRatesForOneIt", 2, this, rawDataForOneIt, (Map)iteration.get()));
                IndyInterface.bootstrap("invoke", "add", 0, requirementRates, rate);
            }
        }
        return requirementRates;
    }

    public List<Map<String, Object>> calculateTcRates(List<Map<String, Object>> iterations, List<IterationTupleTemplate> rawData) {
        Reference rawData2 = new Reference(rawData);
        public final class _calculateTcRates_closure16
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference rawData;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _calculateTcRates_closure16(Object _outerInstance, Object _thisObject, Reference rawData) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.rawData = reference = rawData;
            }

            public Object doCall(List coll, Map<String, Object> iteration) {
                Reference iteration2 = new Reference(iteration);
                public final class _closure28
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference iteration;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure28(Object _outerInstance, Object _thisObject, Reference iteration) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.iteration = reference = iteration;
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getIterationId", 0, it), (Object)IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.iteration.get()), "id"));
                    }

                    @Generated
                    public Map getIteration() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.iteration.get());
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure28.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite rawDataForOneIt = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("cast", "()", 0, this.rawData.get()), new _closure28((Object)this, this.getThisObject(), iteration2)));
                IndyInterface.bootstrap("invoke", "add", 0, coll, IndyInterface.bootstrap("invoke", "calculateTestCaseRatesForOneIt", 2, this, rawDataForOneIt, (Map)iteration2.get()));
                return coll;
            }

            @Generated
            public Object call(List coll, Map<String, Object> iteration) {
                Reference iteration2 = new Reference(iteration);
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, coll, (Map)iteration2.get());
            }

            @Generated
            public List getRawData() {
                return IndyInterface.bootstrap("cast", "()", 0, this.rawData.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _calculateTcRates_closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite tcRates = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "inject", 0, iterations, ScriptBytecodeAdapter.createList((Object[])new Object[0]), new _calculateTcRates_closure16(this, this, rawData2)));
        return tcRates;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> calculateTestSuiteExecutionStatusData(Map<Long, String> testSuiteMap, List<IterationTupleTemplate> rawData, Map<Long, String> iterationIdToParentPath) {
        void var3_3;
        Reference testSuiteMap2 = new Reference(testSuiteMap);
        Reference iterationIdToParentPath2 = new Reference((Object)var3_3);
        public final class _calculateTestSuiteExecutionStatusData_closure17
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _calculateTestSuiteExecutionStatusData_closure17(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "getSuiteId", 0, it), null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _calculateTestSuiteExecutionStatusData_closure17.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite filteredRawData = IndyInterface.bootstrap("invoke", "findAll", 0, rawData, new _calculateTestSuiteExecutionStatusData_closure17(this, this));
        public final class _calculateTestSuiteExecutionStatusData_closure18
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference iterationIdToParentPath;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _calculateTestSuiteExecutionStatusData_closure18(Object _outerInstance, Object _thisObject, Reference iterationIdToParentPath) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.iterationIdToParentPath = reference = iterationIdToParentPath;
            }

            public Object doCall(Object tuple) {
                return IndyInterface.bootstrap("invoke", "toString", 1, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.iterationIdToParentPath.get()), IndyInterface.bootstrap("invoke", "getIterationId", 0, tuple)));
            }

            @Generated
            public Map getIterationIdToParentPath() {
                return IndyInterface.bootstrap("cast", "()", 0, this.iterationIdToParentPath.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _calculateTestSuiteExecutionStatusData_closure18.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _calculateTestSuiteExecutionStatusData_closure19
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _calculateTestSuiteExecutionStatusData_closure19(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object key, Object group) {
                public final class _closure29
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure29(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return IndyInterface.bootstrap("getProperty", "suiteName", 0, it);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure29.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                return ScriptBytecodeAdapter.createList((Object[])new Object[]{key, IndyInterface.bootstrap("invoke", "sort", 0, group, new _closure29((Object)this, this.getThisObject()))});
            }

            @Generated
            public Object call(Object key, Object group) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, key, group);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _calculateTestSuiteExecutionStatusData_closure19.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite dataGroupedByParentPath = IndyInterface.bootstrap("invoke", "collectEntries", 0, IndyInterface.bootstrap("invoke", "groupBy", 0, filteredRawData, new _calculateTestSuiteExecutionStatusData_closure18(this, this, iterationIdToParentPath2)), new _calculateTestSuiteExecutionStatusData_closure19(this, this));
        public final class _calculateTestSuiteExecutionStatusData_closure20
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference testSuiteMap;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _calculateTestSuiteExecutionStatusData_closure20(Object _outerInstance, Object _thisObject, Reference testSuiteMap) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.testSuiteMap = reference = testSuiteMap;
            }

            public Object doCall(Object parentPath, Object tuples) {
                Reference parentPath2 = new Reference(parentPath);
                public final class _closure30
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure30(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return IndyInterface.bootstrap("invoke", "getSuiteId", 0, it);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure30.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                public final class _closure31
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference testSuiteMap;
                    private /* synthetic */ Reference parentPath;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure31(Object _outerInstance, Object _thisObject, Reference testSuiteMap, Reference parentPath) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.testSuiteMap = reference2 = testSuiteMap;
                        this.parentPath = reference = parentPath;
                    }

                    public Object doCall(Object suiteId, Object suiteTuples) {
                        CallSite suiteName = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.testSuiteMap.get()), suiteId);
                        return IndyInterface.bootstrap("invoke", "computeOneTestSuiteExecutionStatus", 2, this, suiteTuples, suiteName, this.parentPath.get());
                    }

                    @Generated
                    public Object call(Object suiteId, Object suiteTuples) {
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, suiteId, suiteTuples);
                    }

                    @Generated
                    public Map getTestSuiteMap() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.testSuiteMap.get());
                    }

                    @Generated
                    public Object getParentPath() {
                        return this.parentPath.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure31.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite testSuites = IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "groupBy", 0, tuples, new _closure30((Object)this, this.getThisObject())), new _closure31((Object)this, this.getThisObject(), this.testSuiteMap, parentPath2));
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"path", parentPath2.get(), "testSuites", testSuites});
            }

            @Generated
            public Object call(Object parentPath, Object tuples) {
                Reference parentPath2 = new Reference(parentPath);
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, parentPath2.get(), tuples);
            }

            @Generated
            public Map getTestSuiteMap() {
                return IndyInterface.bootstrap("cast", "()", 0, this.testSuiteMap.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _calculateTestSuiteExecutionStatusData_closure20.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite groupedByIterationPath = IndyInterface.bootstrap("invoke", "collect", 0, dataGroupedByParentPath, new _calculateTestSuiteExecutionStatusData_closure20(this, this, testSuiteMap2));
        CallSite noTestSuiteLine = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "calculateNoTestSuiteExecutionStatusData", 2, this, rawData));
        CallSite totalLine = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "calculateSummaryExecutionStatusData", 2, this, rawData));
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{ITERATIONS, groupedByIterationPath, "noTestSuite", noTestSuiteLine, "total", totalLine});
    }

    public Map<String, Object> calculateNoTestSuiteExecutionStatusData(List<IterationTupleTemplate> rawData) {
        CallSite result = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
        public final class _calculateNoTestSuiteExecutionStatusData_closure21
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _calculateNoTestSuiteExecutionStatusData_closure21(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getSuiteId", 0, it), null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _calculateNoTestSuiteExecutionStatusData_closure21.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite noSuiteRawData = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, rawData, new _calculateNoTestSuiteExecutionStatusData_closure21(this, this)));
        IndyInterface.bootstrap("invoke", "putAll", 0, result, IndyInterface.bootstrap("invoke", "doAllExecutionStatusCount", 2, this, noSuiteRawData));
        IndyInterface.bootstrap("invoke", "put", 0, result, "name", IndyInterface.bootstrap("invoke", "translate", 0, IndyInterface.bootstrap("getProperty", "i18nHelper", 12, this), "report.iteration.nosuite.name"));
        return result;
    }

    public Map<String, Object> computeOneTestSuiteExecutionStatus(List<IterationTupleTemplate> rawData, String testSuiteName, String iterationPath) {
        CallSite result = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
        IndyInterface.bootstrap("invoke", "putAll", 0, result, IndyInterface.bootstrap("invoke", "doAllExecutionStatusCount", 2, this, rawData));
        IndyInterface.bootstrap("invoke", "put", 0, result, "name", testSuiteName);
        return result;
    }

    public Map<String, Object> calculateSummaryExecutionStatusData(List<IterationTupleTemplate> rawData) {
        public final class _calculateSummaryExecutionStatusData_closure22
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _calculateSummaryExecutionStatusData_closure22(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "getItpiId", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _calculateSummaryExecutionStatusData_closure22.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "unique", 0, rawData, new _calculateSummaryExecutionStatusData_closure22(this, this));
        CallSite result = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
        IndyInterface.bootstrap("invoke", "putAll", 0, result, IndyInterface.bootstrap("invoke", "doAllExecutionStatusCount", 2, this, rawData));
        IndyInterface.bootstrap("invoke", "put", 0, result, "name", IndyInterface.bootstrap("invoke", "translate", 0, IndyInterface.bootstrap("getProperty", "i18nHelper", 12, this), "report.iteration.label.sum"));
        return result;
    }

    public List<Map<String, Object>> buildTemplateFriendlyIterationData(List<IterationInfo> iterations, Map<String, Object> results) {
        Reference results2 = new Reference(results);
        public final class _buildTemplateFriendlyIterationData_closure23
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildTemplateFriendlyIterationData_closure23(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "campaignId", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildTemplateFriendlyIterationData_closure23.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Reference campaignPathMap = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getCampaignBreadcrumbNodes", 0, IndyInterface.bootstrap("getProperty", "entityPathHeaderDao", 12, this), IndyInterface.bootstrap("invoke", "unique", 0, IndyInterface.bootstrap("invoke", "collect", 0, iterations, new _buildTemplateFriendlyIterationData_closure23(this, this))), false)));
        public final class _buildTemplateFriendlyIterationData_closure24
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference campaignPathMap;
            private /* synthetic */ Reference results;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildTemplateFriendlyIterationData_closure24(Object _outerInstance, Object _thisObject, Reference campaignPathMap, Reference results) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.campaignPathMap = reference2 = campaignPathMap;
                this.results = reference = results;
            }

            public Object doCall(List coll, IterationInfo iteration) {
                CallSite iterationValues = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "id", IndyInterface.bootstrap("invoke", "getId", 0, iteration));
                CallSite parentPath = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "buildParentPath", 2, this, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.campaignPathMap.get()), IndyInterface.bootstrap("invoke", "getCampaignId", 0, iteration))));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "parentPath", parentPath);
                CallSite fullName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "buildFullName", 2, this, IndyInterface.bootstrap("invoke", "getReference", 0, iteration), IndyInterface.bootstrap("invoke", "getName", 0, iteration)));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "path", IndyInterface.bootstrap("invoke", "buildEntityPath", 2, this, parentPath, fullName));
                CallSite description = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, StringUtils.class, IndyInterface.bootstrap("invoke", "getDescription", 0, iteration))) != false ? IndyInterface.bootstrap("getProperty", "EMPTY", 0, StringUtils.class) : IndyInterface.bootstrap("invoke", "getDescription", 0, iteration));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "noDescription", IndyInterface.bootstrap("invoke", "hasNoDescription", 2, this, description));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "description", IndyInterface.bootstrap("invoke", "richTextReplace", 2, this, description, IndyInterface.bootstrap("cast", "()", 0, this.results.get())));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "reference", IndyInterface.bootstrap("invoke", "getReference", 0, iteration));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "name", IndyInterface.bootstrap("invoke", "getName", 0, iteration));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "fullName", fullName);
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "nameWithProject", IndyInterface.bootstrap("invoke", "buildEntityNameWithProjectName", 2, this, IndyInterface.bootstrap("invoke", "getProjectName", 0, iteration), IndyInterface.bootstrap("invoke", "getName", 0, iteration)));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "projectId", IndyInterface.bootstrap("invoke", "getProjectId", 0, iteration));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "projectName", IndyInterface.bootstrap("invoke", "getProjectName", 0, iteration));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "bugtrackerId", IndyInterface.bootstrap("invoke", "getBugtrackerId", 0, iteration));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "estimatedStartDate", IndyInterface.bootstrap("invoke", "translateDateShort", 0, IndyInterface.bootstrap("getProperty", "i18nHelper", 8, this), IndyInterface.bootstrap("invoke", "getScheduledStartDate", 0, iteration)));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "estimatedEndDate", IndyInterface.bootstrap("invoke", "translateDateShort", 0, IndyInterface.bootstrap("getProperty", "i18nHelper", 8, this), IndyInterface.bootstrap("invoke", "getScheduledEndDate", 0, iteration)));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "realizedStartDate", IndyInterface.bootstrap("invoke", "translateDateShort", 0, IndyInterface.bootstrap("getProperty", "i18nHelper", 8, this), IndyInterface.bootstrap("invoke", "getActualStartDate", 0, iteration)));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "realizedEndDate", IndyInterface.bootstrap("invoke", "translateDateShort", 0, IndyInterface.bootstrap("getProperty", "i18nHelper", 8, this), IndyInterface.bootstrap("invoke", "getActualEndDate", 0, iteration)));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "noEstimatedStartDate", ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getScheduledStartDate", 0, iteration), null));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "noEstimatedEndDate", ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getScheduledEndDate", 0, iteration), null));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "noRealizedStartDate", ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getActualStartDate", 0, iteration), null));
                IndyInterface.bootstrap("invoke", "put", 0, iterationValues, "noRealizedEndDate", ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getActualEndDate", 0, iteration), null));
                IndyInterface.bootstrap("invoke", "add", 0, coll, iterationValues);
                return coll;
            }

            @Generated
            public Object call(List coll, IterationInfo iteration) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, coll, iteration);
            }

            @Generated
            public Map getCampaignPathMap() {
                return IndyInterface.bootstrap("cast", "()", 0, this.campaignPathMap.get());
            }

            @Generated
            public Map getResults() {
                return IndyInterface.bootstrap("cast", "()", 0, this.results.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildTemplateFriendlyIterationData_closure24.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite result = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "inject", 0, iterations, ScriptBytecodeAdapter.createList((Object[])new Object[0]), new _buildTemplateFriendlyIterationData_closure24(this, this, campaignPathMap, results2)));
        public final class _buildTemplateFriendlyIterationData_closure25
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildTemplateFriendlyIterationData_closure25(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return (String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, "path"), String.class));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildTemplateFriendlyIterationData_closure25.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "sort", 0, result, new _buildTemplateFriendlyIterationData_closure25(this, this));
        return result;
    }

    public List<IterationTupleTemplate> getRawData(List<Long> iterationIds) {
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, iterationIds)) != false) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "EMPTY_LIST", 0, ListUtils.class));
        }
        CallSite q = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createNativeQuery", 0, IndyInterface.bootstrap("getProperty", "em", 12, this), IndyInterface.bootstrap("getProperty", "REQUEST_ITERATION_TEST_SUITE_REQUIREMENT", 0, Queries.class)));
        IndyInterface.bootstrap("invoke", "setParameter", 0, q, "iterationIds", iterationIds);
        CallSite result = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getResultList", 0, q));
        public final class _getRawData_closure26
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getRawData_closure26(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite template = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, IterationTupleTemplate.class));
                IndyInterface.bootstrap("invoke", "setIterationId", 0, template, ScriptBytecodeAdapter.createPojoWrapper((Object)((Long)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, false), Long.class))), Long.class));
                IndyInterface.bootstrap("invoke", "setSuiteId", 0, template, ScriptBytecodeAdapter.createPojoWrapper((Object)((Long)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, true), Long.class))), Long.class));
                IndyInterface.bootstrap("invoke", "setSuiteName", 0, template, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, 2)));
                IndyInterface.bootstrap("invoke", "setItpiId", 0, template, ScriptBytecodeAdapter.createPojoWrapper((Object)((Long)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, 3), Long.class))), Long.class));
                IndyInterface.bootstrap("invoke", "setExecutionStatus", 0, template, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, 4)));
                IndyInterface.bootstrap("invoke", "setExecutionDate", 0, template, ScriptBytecodeAdapter.createPojoWrapper((Object)((Date)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, 5), Date.class))), Date.class));
                IndyInterface.bootstrap("invoke", "setDatasetId", 0, template, ScriptBytecodeAdapter.createPojoWrapper((Object)((Long)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, 6), Long.class))), Long.class));
                IndyInterface.bootstrap("invoke", "setTcId", 0, template, ScriptBytecodeAdapter.createPojoWrapper((Object)((Long)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, 7), Long.class))), Long.class));
                IndyInterface.bootstrap("invoke", "setTcName", 0, template, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, 8)));
                IndyInterface.bootstrap("invoke", "setTcImportance", 0, template, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, 9)));
                IndyInterface.bootstrap("invoke", "setTcReference", 0, template, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, 10)));
                IndyInterface.bootstrap("invoke", "setCovId", 0, template, ScriptBytecodeAdapter.createPojoWrapper((Object)((Long)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, 11), Long.class))), Long.class));
                IndyInterface.bootstrap("invoke", "setReqVersionId", 0, template, ScriptBytecodeAdapter.createPojoWrapper((Object)((Long)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, 12), Long.class))), Long.class));
                IndyInterface.bootstrap("invoke", "setReqVersionName", 0, template, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, 13)));
                IndyInterface.bootstrap("invoke", "setReqVersionCriticality", 0, template, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, 14)));
                IndyInterface.bootstrap("invoke", "setReqVersionReference", 0, template, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, 15)));
                return template;
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getRawData_closure26.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, result, new _getRawData_closure26(this, this)));
    }

    @Override
    public AbstractDefaultLocalKnownIssueFinder getKnownIssueFinder() {
        return this.iterationKnownIssueFinder;
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != IterationReportDataBuilder.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, IterationReportDataBuilder.class);
        LOGGER = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }
}

