/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.jirarest.internal;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import jirarest.com.atlassian.jira.rest.client.api.domain.BasicIssue;
import jirarest.com.atlassian.jira.rest.client.api.domain.BasicUser;
import jirarest.com.atlassian.jira.rest.client.api.domain.CimIssueType;
import jirarest.com.atlassian.jira.rest.client.api.domain.CimProject;
import jirarest.com.atlassian.jira.rest.client.api.domain.Issue;
import jirarest.com.atlassian.jira.rest.client.api.domain.input.AttachmentInput;
import jirarest.com.atlassian.jira.rest.client.api.domain.input.IssueInput;
import jirarest.com.atlassian.jira.rest.client.api.domain.input.LinkIssuesInput;
import org.apache.commons.lang.NullArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.core.BugTrackerLocalException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.csp.core.bugtracker.core.ProjectNotFoundException;
import org.squashtest.csp.core.bugtracker.core.UnsupportedAuthenticationModeException;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssue;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedProject;
import org.squashtest.tm.bugtracker.advanceddomain.DelegateCommand;
import org.squashtest.tm.bugtracker.advanceddomain.Field;
import org.squashtest.tm.bugtracker.advanceddomain.FieldValue;
import org.squashtest.tm.bugtracker.advanceddomain.RemoteIssueSearchForm;
import org.squashtest.tm.bugtracker.definition.Attachment;
import org.squashtest.tm.bugtracker.definition.RemoteIssue;
import org.squashtest.tm.bugtracker.definition.context.BugTrackerBindingInfo;
import org.squashtest.tm.bugtracker.definition.context.RemoteIssueContext;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.JiraAdvancedIssue;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.JiraClient;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.conversion.EntityConverter;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.exceptions.ExceptionHandler;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.exceptions.NumberConversionException;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.extension.DelegateCommands;
import org.squashtest.tm.plugin.bugtracker.jirarest.internal.json.BasicEntity;
import org.squashtest.tm.service.spi.AdvancedBugTrackerConnector;

@Component
@Scope(value="prototype")
public class JiraConnector
implements AdvancedBugTrackerConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraConnector.class);
    private static final AuthenticationProtocol[] PROTOCOLS = new AuthenticationProtocol[]{AuthenticationProtocol.BASIC_AUTH, AuthenticationProtocol.OAUTH_2};
    private static final String ISSUE_URL_SUFFIX = "/browse/";
    @Inject
    @Named(value="jiraBugTrackerInterfaceDescriptor")
    private BugTrackerInterfaceDescriptor descriptor;
    @Inject
    private EntityConverter converter;
    @Inject
    private JiraClient client;
    @Inject
    private ExceptionHandler handler;
    private BugTracker bugTracker;

    @PostConstruct
    public void init() {
        this.converter.setJiraClient(this.client);
    }

    public void setBugTracker(BugTracker bugTracker) {
        this.bugTracker = bugTracker;
    }

    public AuthenticationProtocol[] getSupportedAuthProtocols() {
        return PROTOCOLS;
    }

    public void authenticate(Credentials credentials) throws UnsupportedAuthenticationModeException {
        LOGGER.debug("BEGIN : authentication");
        if (credentials == null) {
            throw new NullArgumentException("credentials");
        }
        this.client.init(this.bugTracker, credentials);
        LOGGER.debug("END : authentication");
    }

    public void checkCredentials(Credentials credentials) throws BugTrackerNoCredentialsException, BugTrackerRemoteException {
        LOGGER.debug("BEGIN : checking credentials");
        try {
            this.authenticate(credentials);
            this.checkCredentials();
        }
        finally {
            this.close();
            LOGGER.debug("END : checking credentials");
        }
    }

    private void checkCredentials() throws BugTrackerRemoteException {
        this.client.getAllPriorities();
    }

    public AdvancedProject findProject(String projectName) throws ProjectNotFoundException, BugTrackerRemoteException {
        LOGGER.debug("BEGIN : fetching project informations (by name)");
        try {
            CimProject jiraProject = this.client.findProjectForCreateByKey(projectName);
            AdvancedProject advancedProject = this.converter.jira2SquashProject(jiraProject);
            return advancedProject;
        }
        finally {
            this.close();
            LOGGER.debug("END : fetching project informations (by name)");
        }
    }

    public AdvancedProject findProjectById(String projectId) throws ProjectNotFoundException, BugTrackerRemoteException {
        LOGGER.debug("BEGIN : fetching project informations (by id)");
        try {
            Long projectIdAsLong = Long.valueOf(projectId);
            CimProject jiraProject = this.client.findProjectForCreateById(projectIdAsLong);
            AdvancedProject advancedProject = this.converter.jira2SquashProject(jiraProject);
            return advancedProject;
        }
        finally {
            this.close();
            LOGGER.debug("END : fetching project informations (by id)");
        }
    }

    public AdvancedIssue createIssue(RemoteIssue issue) throws BugTrackerRemoteException {
        LOGGER.debug("BEGIN : creating issue");
        try {
            AdvancedIssue advancedIssue = (AdvancedIssue)issue;
            String projectKey = advancedIssue.getProject().getId();
            String issueTypeName = advancedIssue.getCurrentScheme().split(":")[1];
            IssueInput input = this.converter.squash2jiraIssue(advancedIssue, this.getIssueTypeId(projectKey, issueTypeName));
            BasicIssue basicIssue = this.client.createIssue(input);
            Issue jiraIssue = this.client.findIssue(basicIssue.getKey());
            AdvancedIssue advancedIssue2 = this.converter.jira2SquashIssue(jiraIssue);
            return advancedIssue2;
        }
        catch (NumberConversionException ex) {
            throw this.handler.numberConversionFailure(ex);
        }
        finally {
            this.close();
            LOGGER.debug("END : creating issue");
        }
    }

    public RemoteIssueSearchForm createIssueSearchForm(BugTrackerBindingInfo bugTrackerBindingInfo) {
        RemoteIssueSearchForm form = super.createIssueSearchForm(bugTrackerBindingInfo);
        this.close();
        return form;
    }

    public AdvancedIssue findIssue(String key) {
        LOGGER.debug("BEGIN : fetching issue");
        try {
            Issue issue = this.client.findIssue(key);
            AdvancedIssue advancedIssue = this.converter.jira2SquashIssue(issue);
            String schemeName = advancedIssue.getCurrentScheme();
            AdvancedProject project = this.converter.createReadOnlyProjectStub(schemeName, this.descriptor);
            project.setId(issue.getProject().getKey());
            project.setName(issue.getProject().getName());
            advancedIssue.setProject(project);
            AdvancedIssue advancedIssue2 = advancedIssue;
            return advancedIssue2;
        }
        finally {
            this.close();
            LOGGER.debug("END : fetching issue");
        }
    }

    public List<AdvancedIssue> findIssues(List<String> issueKeyList) {
        LOGGER.debug("BEGIN : fetching batch of issues");
        try {
            Iterable<Issue> issueList = this.client.findIssues(issueKeyList);
            List<AdvancedIssue> list = this.converter.jira2SquashIssues(issueList);
            return list;
        }
        finally {
            this.close();
            LOGGER.debug("END : fetching batch of issues");
        }
    }

    private Long getIssueTypeId(String projectKey, String issueTypeName) {
        Long result = null;
        CimProject project = this.client.findProjectForCreateByKey(projectKey);
        for (CimIssueType issueType : project.getIssueTypes()) {
            if (!issueType.getName().equals(issueTypeName)) continue;
            result = issueType.getId();
        }
        return result;
    }

    public URL makeViewIssueUrl(String issueId) {
        LOGGER.debug("BEGIN : finding issue URL");
        try {
            String strUrl = this.bugTracker.getUrl().replaceAll("\\/$", "") + ISSUE_URL_SUFFIX + issueId;
            URL uRL = new URL(strUrl);
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            URL uRL = this.client.findIssueURL(issueId);
            return uRL;
        }
        finally {
            this.close();
            LOGGER.debug("END : finding issue URL");
        }
    }

    public void forwardAttachments(String remoteIssueKey, List<Attachment> attachments) {
        LOGGER.debug("BEGIN : forwarding attachments");
        try {
            Collection<AttachmentInput> jiraAttachments = this.converter.convertToJiraAttachments(attachments);
            this.client.forwardAttachments(remoteIssueKey, jiraAttachments);
        }
        finally {
            this.close();
            LOGGER.debug("END : forwarding attachments");
        }
    }

    public Object executeDelegateCommand(DelegateCommand command) {
        LOGGER.debug("BEGIN : execute delegate command");
        try {
            FieldValue fieldValue = null;
            if (DelegateCommands.isSearchAssignableCommand(command)) {
                String projectKey = DelegateCommands.getSearchAssignableProject(command);
                Iterable<BasicUser> users = this.client.searchAssignableUsers(projectKey, (String)command.getArgument());
                fieldValue = this.converter.convertToUserCompositeFieldValue(users);
            } else if (DelegateCommands.isSearchReporterCommand(command)) {
                Iterable<BasicUser> users = this.client.searchPossisbleReporter((String)command.getArgument());
                fieldValue = this.converter.convertToUserCompositeFieldValue(users);
            } else if (DelegateCommands.isSearchEpicsCommand(command)) {
                String projectKey = DelegateCommands.getSearchEpicProject(command);
                Iterable<BasicEntity> epics = this.client.searchAvailableEpics(projectKey, (String)command.getArgument());
                fieldValue = this.converter.convertToEpicCompositeFieldValue(epics, "epic");
            } else {
                fieldValue = new FieldValue();
            }
            FieldValue fieldValue2 = fieldValue;
            return fieldValue2;
        }
        finally {
            this.close();
            LOGGER.debug("END : execute delegate command");
        }
    }

    public void linkIssues(String remoteIssueKey, List<String> remoteReqIds) {
        LOGGER.debug("BEGIN : link issue to requirements");
        try {
            for (String remoteReqId : remoteReqIds) {
                try {
                    LinkIssuesInput input = new LinkIssuesInput(remoteIssueKey, remoteReqId, "Blocks");
                    this.client.linkIssue(input);
                }
                catch (BugTrackerRemoteException bugTrackerRemoteException) {
                    LOGGER.debug("Failed to link " + remoteIssueKey + " with " + remoteReqId);
                }
            }
        }
        finally {
            this.close();
            LOGGER.debug("END : link issue to requirements");
        }
    }

    public BugTrackerInterfaceDescriptor getInterfaceDescriptor() {
        LOGGER.debug("BEGIN : retrieve the interface descriptor");
        try {
            BugTrackerInterfaceDescriptor bugTrackerInterfaceDescriptor = this.descriptor;
            return bugTrackerInterfaceDescriptor;
        }
        finally {
            this.close();
            LOGGER.debug("END : retrieve the interface descriptor");
        }
    }

    public RemoteIssue createReportIssueTemplate(String projectName, RemoteIssueContext context) {
        LOGGER.debug("BEGIN : issue creation metadata");
        try {
            AdvancedProject project = this.getProjectForCreate(projectName);
            Object object = project.getSchemeMap().keySet().iterator().next();
            String key = object.toString();
            Collection fields = project.getFieldScheme(key);
            JiraAdvancedIssue issue = new JiraAdvancedIssue();
            issue.setProject(project);
            issue.setBugtracker(this.bugTracker.getName());
            issue.setCurrentScheme(key);
            for (Field field : fields) {
                if ("reporter".equals(field.getId())) {
                    issue.setFieldValue(field.getId(), new FieldValue(field.getId(), this.client.getReporter()));
                    continue;
                }
                issue.setFieldValue(field.getId(), null);
            }
            JiraAdvancedIssue jiraAdvancedIssue = issue;
            return jiraAdvancedIssue;
        }
        finally {
            this.close();
            LOGGER.debug("END : issue creation metadata");
        }
    }

    private void close() {
        try {
            if (this.client != null) {
                LOGGER.debug("attempting to close the client...");
                this.client.close();
                LOGGER.debug("client closed");
            } else {
                LOGGER.debug("client was null, nothing to close");
            }
        }
        catch (IOException ex) {
            throw new BugTrackerLocalException((Throwable)ex);
        }
    }

    private AdvancedProject getProjectForCreate(String projectName) {
        String pKey = this.client.findProjectKeyByName(projectName);
        CimProject jiraProject = this.client.findProjectForCreateByKey(pKey);
        return this.converter.jira2SquashProject(jiraProject);
    }
}

