/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.core.jackson;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.CreatorProperty;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.ValueInstantiators;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityNotFoundException;
import java.io.IOException;
import org.springframework.core.annotation.AnnotationUtils;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.plugin.rest.core.jackson.DeserializationDynamicFilter;
import org.squashtest.tm.plugin.rest.core.jackson.DeserializationHints;
import org.squashtest.tm.plugin.rest.core.jackson.EntityManagerWrapper;

public class PersistentValueInstantiators
extends ValueInstantiators.Base {
    private EntityManagerWrapper em;

    public PersistentValueInstantiators(EntityManagerWrapper emw) {
        this.em = emw;
    }

    private boolean canApply(DeserializationConfig config, Class<?> beanClass) {
        return Identified.class.isAssignableFrom(beanClass) && AnnotationUtils.findAnnotation(beanClass, Entity.class) != null;
    }

    public ValueInstantiator findValueInstantiator(DeserializationConfig config, BeanDescription beanDesc, ValueInstantiator defaultInstantiator) {
        Class beanClass = beanDesc.getBeanClass();
        if (this.canApply(config, beanClass)) {
            return new PersistentValueInstantiator(this.em, beanClass, defaultInstantiator);
        }
        return defaultInstantiator;
    }

    private static final class PersistentValueInstantiator
    extends ValueInstantiator {
        private EntityManagerWrapper em;
        private ValueInstantiator defaultInstantiator;
        private Class<?> beanClass;

        public PersistentValueInstantiator(EntityManagerWrapper em, Class<?> beanClass, ValueInstantiator defaultInstantiator) {
            this.em = em;
            this.defaultInstantiator = defaultInstantiator;
            this.beanClass = beanClass;
        }

        public boolean canInstantiate() {
            return true;
        }

        public boolean canCreateFromObjectWith() {
            return true;
        }

        public Object createFromObjectWith(DeserializationContext ctxt, SettableBeanProperty[] props, PropertyValueBuffer buffer) throws IOException {
            DeserializationHints hints = (DeserializationHints)ctxt.getAttribute((Object)"deserialization_hints");
            if (hints == null) {
                return this.defaultInstantiator.createUsingDefault(ctxt);
            }
            Object instance = null;
            SettableBeanProperty idProp = props[0];
            hints.getMode();
            DeserializationDynamicFilter filter = hints.getFilter();
            boolean isRoot = filter.isRoot();
            if (buffer.hasParameter(idProp) && filter.include("id")) {
                Long id = (Long)buffer.getParameter(idProp);
                instance = this.em.find(this.beanClass, id);
                if (instance == null) {
                    throw new EntityNotFoundException("No entity " + this.beanClass.getName() + " found with id : " + String.valueOf(id));
                }
            } else {
                instance = hints.getMode() == DeserializationHints.Mode.DESERIALIZE_UPDATE && isRoot ? hints.getTargetEntity() : this.defaultInstantiator.createUsingDefault(ctxt);
            }
            return instance;
        }

        public Class<?> getValueClass() {
            return this.beanClass;
        }

        public SettableBeanProperty[] getFromObjectArguments(DeserializationConfig config) {
            SettableBeanProperty[] properties = new SettableBeanProperty[]{new CreatorProperty(PropertyName.construct((String)"id"), config.constructType(Long.TYPE), null, null, null, null, 0, null, PropertyMetadata.STD_OPTIONAL)};
            return properties;
        }
    }
}

