-- Lock Database
UPDATE databasechangeloglock SET LOCKED = TRUE, LOCKEDBY = 'runner-yfpexrfv8-project-33554404-concurrent-0-yb8hs38o (100.64.14.145)', LOCKGRANTED = NOW() WHERE ID = 1 AND LOCKED = FALSE;

-- *********************************************************************
-- Update Database Script
-- *********************************************************************
-- Change Log: upgrade.changelog-up-to-7.1.0.xml
-- Ran at: 19/11/2025 12:31
-- Against: squashtm@jdbc:postgresql://postgres/squashtest
-- Liquibase version: 4.29.2
-- *********************************************************************

-- Changeset ../tm/tm.changelog-7.1.0.xml::tm-7.1.0::mbrugniere
-- Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '7.1.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.1.0', 'mbrugniere', '../tm/tm.changelog-7.1.0.xml', NOW(), 1, '9:9d10a2bc2b201964c73a7e7032b900dc', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, NULL, '4.29.2', '3551893333');

-- Changeset ../tm/tm.changelog-7.1.0.xml::tm-7.1.0-create-api-token-table::mbrugniere
-- Create table API_TOKEN
CREATE TABLE API_TOKEN (TOKEN_ID BIGINT GENERATED BY DEFAULT AS IDENTITY NOT NULL, USER_ID BIGINT NOT NULL, UUID VARCHAR(36) NOT NULL, NAME VARCHAR(255) NOT NULL, PERMISSIONS VARCHAR(50) NOT NULL, CREATED_ON TIMESTAMP WITHOUT TIME ZONE NOT NULL, EXPIRY_DATE VARCHAR(10) NOT NULL, LAST_USAGE TIMESTAMP WITHOUT TIME ZONE, CONSTRAINT pk_api_token PRIMARY KEY (TOKEN_ID), UNIQUE (UUID));

COMMENT ON COLUMN API_TOKEN.TOKEN_ID IS 'primary key for API_TOKEN';

COMMENT ON COLUMN API_TOKEN.USER_ID IS 'foreign key to CORE_USER.PARTY_ID';

COMMENT ON COLUMN API_TOKEN.UUID IS 'Unique UUID to identify a token in database';

COMMENT ON COLUMN API_TOKEN.PERMISSIONS IS 'READ for GET and READ_WRITE for all methods';

CREATE INDEX idx_fk_api_token_user_id ON API_TOKEN(USER_ID);

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.1.0-create-api-token-table', 'mbrugniere', '../tm/tm.changelog-7.1.0.xml', NOW(), 2, '9:c4cab334b1277b733508ddbf4c4cad22', 'createTable tableName=API_TOKEN; createIndex indexName=idx_fk_api_token_user_id, tableName=API_TOKEN', 'Create table API_TOKEN', 'EXECUTED', NULL, NULL, '4.29.2', '3551893333');

-- Changeset ../tm/tm.changelog-7.1.0.xml::tm-7.1.0-fix-description-default-value-in-third-party-server::jprioux
ALTER TABLE THIRD_PARTY_SERVER ALTER COLUMN  DESCRIPTION SET DEFAULT '';

UPDATE THIRD_PARTY_SERVER SET DESCRIPTION = '' WHERE DESCRIPTION IS NULL;

INSERT INTO databasechangelog (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, DESCRIPTION, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-7.1.0-fix-description-default-value-in-third-party-server', 'jprioux', '../tm/tm.changelog-7.1.0.xml', NOW(), 3, '9:d0526bba58ae7a065e3b71c8990eb3b3', 'addDefaultValue columnName=DESCRIPTION, tableName=THIRD_PARTY_SERVER; update tableName=THIRD_PARTY_SERVER', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551893333');

-- Release Database Lock
UPDATE databasechangeloglock SET LOCKED = FALSE, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

