--  Lock Database
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 1, LOCKEDBY = 'runner-yfpexrfv8-project-33554404-concurrent-0-yb8hs38o (100.64.14.145)', LOCKGRANTED = NOW() WHERE ID = 1 AND `LOCKED` = 0;

--  *********************************************************************
--  Update Database Script
--  *********************************************************************
--  Change Log: upgrade.changelog-up-to-4.0.0.xml
--  Ran at: 19/11/2025 12:31
--  Against: root@jdbc:mariadb://mariadb/squashtest
--  Liquibase version: 4.29.2
--  *********************************************************************

--  Changeset ../tm/tm.changelog-4.0.0.xml::tm-4.0.0-SQUASH-5232-add-databasechangelog-new-columns::jprioux
--  Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table
ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS CONTEXTS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS LABELS VARCHAR(255) DEFAULT NULL;

ALTER TABLE DATABASECHANGELOG ADD COLUMN IF NOT EXISTS DEPLOYMENT_ID VARCHAR(10) DEFAULT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-SQUASH-5232-add-databasechangelog-new-columns', 'jprioux', '../tm/tm.changelog-4.0.0.xml', NOW(), 1, '9:cde83df4e75664bbf3e2380e695ae8ed', 'sql', 'Add Contexts, labels and deployment_id columns to DATABASECHANGELOG Table', 'EXECUTED', NULL, NULL, '4.29.2', '3551889099');

--  Changeset ../tm/tm.changelog-4.0.0.xml::tm-4.0.0::jlor
--  Update TM database version number
UPDATE CORE_CONFIG SET VALUE = '4.0.0' WHERE STR_KEY = 'squashtest.tm.database.version';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0', 'jlor', '../tm/tm.changelog-4.0.0.xml', NOW(), 2, '9:f8b68dd1970b66d3b2f865f9c4f7dcb9', 'update tableName=CORE_CONFIG', 'Update TM database version number', 'EXECUTED', NULL, NULL, '4.29.2', '3551889099');

--  Changeset ../tm/tm.changelog-4.0.0.xml::tm-4.0.0-squash-4931-projects-data-migration::jlor
--  Migrate PROJECT.BDD_IMPLEMENTATION_TECHNOLOGY from value 'CUCUMBER' to 'CUCUMBER_4'
UPDATE PROJECT SET BDD_IMPLEMENTATION_TECHNOLOGY = 'CUCUMBER_4' WHERE BDD_IMPLEMENTATION_TECHNOLOGY = 'CUCUMBER';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-squash-4931-projects-data-migration', 'jlor', '../tm/tm.changelog-4.0.0.xml', NOW(), 3, '9:e17a6086b361dd3fa3293e75863bb919', 'update tableName=PROJECT', 'Migrate PROJECT.BDD_IMPLEMENTATION_TECHNOLOGY from value ''CUCUMBER'' to ''CUCUMBER_4''', 'EXECUTED', NULL, NULL, '4.29.2', '3551889099');

--  Changeset ../tm/tm.changelog-4.0.0.xml::tm-4.0.0-squash-4931-projects-default-value-modification::jlor
--  Modify default value of PROJECT.BDD_IMPLEMENTATION_TECHNOLOGY from value 'CUCUMBER' to 'CUCUMBER_5_PLUS'
ALTER TABLE PROJECT ALTER BDD_IMPLEMENTATION_TECHNOLOGY SET DEFAULT 'CUCUMBER_5_PLUS';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-squash-4931-projects-default-value-modification', 'jlor', '../tm/tm.changelog-4.0.0.xml', NOW(), 4, '9:e36a3c11a1bfde73ed29f239dbb9382b', 'addDefaultValue columnName=BDD_IMPLEMENTATION_TECHNOLOGY, tableName=PROJECT', 'Modify default value of PROJECT.BDD_IMPLEMENTATION_TECHNOLOGY from value ''CUCUMBER'' to ''CUCUMBER_5_PLUS''', 'EXECUTED', NULL, NULL, '4.29.2', '3551889099');

--  Changeset ../tm/tm.changelog-4.0.0.xml::tm-4.0.0-squash-4931-action-words-data-migration::jlor
--  Migrate ACTION_WORD.LAST_IMPLEMENTATION_TECHNOLOGY from value 'CUCUMBER' to 'CUCUMBER_4'
UPDATE ACTION_WORD SET LAST_IMPLEMENTATION_TECHNOLOGY = 'CUCUMBER_4' WHERE LAST_IMPLEMENTATION_TECHNOLOGY = 'CUCUMBER';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-squash-4931-action-words-data-migration', 'jlor', '../tm/tm.changelog-4.0.0.xml', NOW(), 5, '9:96e1d8eba8bdd88a64043979b80775fc', 'update tableName=ACTION_WORD', 'Migrate ACTION_WORD.LAST_IMPLEMENTATION_TECHNOLOGY from value ''CUCUMBER'' to ''CUCUMBER_4''', 'EXECUTED', NULL, NULL, '4.29.2', '3551889099');

--  Changeset ../tm/tm.changelog-4.0.0.xml::tm-4.0.0-squash-5025-token-auth-migration-for-mantis::bms
--  Migrate BASIC_AUTH TO TOKEN_AUTH in third_party_server table
UPDATE THIRD_PARTY_SERVER server
        INNER JOIN BUGTRACKER bt ON server.SERVER_ID = bt.BUGTRACKER_ID
        SET AUTH_PROTOCOL = 'TOKEN_AUTH'
        WHERE bt.KIND = 'mantis';

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-squash-5025-token-auth-migration-for-mantis', 'bms', '../tm/tm.changelog-4.0.0.xml', NOW(), 6, '9:6b0dcd60307d45ea479996c96c3f365a', 'sql', 'Migrate BASIC_AUTH TO TOKEN_AUTH in third_party_server table', 'EXECUTED', NULL, NULL, '4.29.2', '3551889099');

--  Changeset ../tm/tm.changelog-4.0.0.xml::tm-4.0.0-squash-5035-add-owner-column-to-remote-synchronisation::cduvigneau
--  Add Owner Column to REMOTE_SYNCHRONISATION Table
ALTER TABLE REMOTE_SYNCHRONISATION ADD OWNER_ID BIGINT NULL;

ALTER TABLE REMOTE_SYNCHRONISATION ADD CONSTRAINT fk_remote_sync_owner FOREIGN KEY (OWNER_ID) REFERENCES CORE_USER (PARTY_ID);

CREATE INDEX idx_fk_remote_sync_owner ON REMOTE_SYNCHRONISATION(OWNER_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-squash-5035-add-owner-column-to-remote-synchronisation', 'cduvigneau', '../tm/tm.changelog-4.0.0.xml', NOW(), 7, '9:f4f36b2514985fece0ece386985f3b09', 'addColumn tableName=REMOTE_SYNCHRONISATION; createIndex indexName=idx_fk_remote_sync_owner, tableName=REMOTE_SYNCHRONISATION', 'Add Owner Column to REMOTE_SYNCHRONISATION Table', 'EXECUTED', NULL, NULL, '4.29.2', '3551889099');

--  Changeset ../tm/tm.changelog-4.0.0.xml::tm-4.0.0-delete-column-test-case-version::jlor
--  Delete TEST_CASE.VERSION which is not and was never used
ALTER TABLE TEST_CASE DROP COLUMN VERSION;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-delete-column-test-case-version', 'jlor', '../tm/tm.changelog-4.0.0.xml', NOW(), 8, '9:16fe1e7fbb013f4e30c70df6bb17513f', 'dropColumn columnName=VERSION, tableName=TEST_CASE', 'Delete TEST_CASE.VERSION which is not and was never used', 'EXECUTED', NULL, NULL, '4.29.2', '3551889099');

--  Changeset ../tm/tm.changelog-4.0.0.xml::tm-4.0.0-sqmap-879-automation-environment-tag::jlor
--  Create table AUTOMATION_ENVIRONMENT_TAG
CREATE TABLE AUTOMATION_ENVIRONMENT_TAG (VALUE VARCHAR(255) NULL, ENTITY_TYPE VARCHAR(50) NOT NULL, ENTITY_ID BIGINT NOT NULL);

ALTER TABLE AUTOMATION_ENVIRONMENT_TAG ADD CONSTRAINT uniq_value_entity_type_entity_id UNIQUE (VALUE, ENTITY_TYPE, ENTITY_ID);

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-sqmap-879-automation-environment-tag', 'jlor', '../tm/tm.changelog-4.0.0.xml', NOW(), 9, '9:8f894aa035dce5752e03d498817ce924', 'createTable tableName=AUTOMATION_ENVIRONMENT_TAG; addUniqueConstraint constraintName=uniq_value_entity_type_entity_id, tableName=AUTOMATION_ENVIRONMENT_TAG', 'Create table AUTOMATION_ENVIRONMENT_TAG', 'EXECUTED', NULL, NULL, '4.29.2', '3551889099');

--  Changeset ../tm/tm.changelog-4.0.0.xml::tm-4.0.0-sqmap-879-add-project-inherits-env-tag-column::pckerneis
ALTER TABLE PROJECT ADD INHERITS_ENVIRONMENT_TAGS TINYINT(1) DEFAULT 1 NOT NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-sqmap-879-add-project-inherits-env-tag-column', 'pckerneis', '../tm/tm.changelog-4.0.0.xml', NOW(), 10, '9:33380b19b42f47a9d977bed3d3e455d1', 'addColumn tableName=PROJECT', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889099');

--  Changeset ../tm/tm.changelog-4.0.0.xml::tm-4.0.0-sqmap-879-add-project-level-credentials::pckerneis
ALTER TABLE STORED_CREDENTIALS ADD PROJECT_ID BIGINT DEFAULT null NULL COMMENT 'Foreign key to the project bound to these credentials. NULL for app-level and user-level credentials.';

ALTER TABLE STORED_CREDENTIALS ADD CONSTRAINT fk_stored_credentials_project FOREIGN KEY (PROJECT_ID) REFERENCES PROJECT (PROJECT_ID) ON DELETE CASCADE;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-sqmap-879-add-project-level-credentials', 'pckerneis', '../tm/tm.changelog-4.0.0.xml', NOW(), 11, '9:e76e77e7bd3521e2ea7406e05355c385', 'addColumn tableName=STORED_CREDENTIALS', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889099');

--  Changeset ../tm/tm.changelog-4.0.0.xml::tm-4.0.0-SQUASH-4923-remove-orphan-project-filters::dclaerhout
DELETE FROM PROJECT_FILTER_ENTRY
      WHERE FILTER_ID in(
          SELECT pf.PROJECT_FILTER_ID
          FROM PROJECT_FILTER AS pf
          LEFT JOIN CORE_USER AS cu ON cu.LOGIN = pf.USER_LOGIN
          WHERE cu.LOGIN IS NULL
      );

DELETE FROM PROJECT_FILTER
      WHERE USER_LOGIN in(
        SELECT * FROM (
                        SELECT pf.USER_LOGIN
                        FROM PROJECT_FILTER AS pf
                               LEFT JOIN CORE_USER AS cu ON cu.LOGIN = pf.USER_LOGIN
                        WHERE cu.LOGIN IS NULL
                      ) AS user_logins
      );

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-SQUASH-4923-remove-orphan-project-filters', 'dclaerhout', '../tm/tm.changelog-4.0.0.xml', NOW(), 12, '9:766ed1873b5eaccc38bdb17a073713e4', 'sql', '', 'EXECUTED', NULL, NULL, '4.29.2', '3551889099');

--  Changeset ../tm/tm.changelog-4.0.0.xml::tm-4.0.0-squash-5384-taserver-observer-url-column::pckerneis
--  Add OBSERVER_URL column to TEST_AUTOMATION_SERVER
ALTER TABLE TEST_AUTOMATION_SERVER ADD OBSERVER_URL VARCHAR(255) DEFAULT null NULL;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('tm-4.0.0-squash-5384-taserver-observer-url-column', 'pckerneis', '../tm/tm.changelog-4.0.0.xml', NOW(), 13, '9:20f43d1b12eff9da986c09bd8075d726', 'addColumn tableName=TEST_AUTOMATION_SERVER', 'Add OBSERVER_URL column to TEST_AUTOMATION_SERVER', 'EXECUTED', NULL, NULL, '4.29.2', '3551889099');

--  Release Database Lock
UPDATE DATABASECHANGELOGLOCK SET `LOCKED` = 0, LOCKEDBY = NULL, LOCKGRANTED = NULL WHERE ID = 1;

