/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.openid.connect.service;

import jakarta.inject.Inject;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.client.authentication.OAuth2LoginAuthenticationToken;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.provisioning.UserDetailsManager;
import org.springframework.stereotype.Service;
import org.squashtest.tm.exception.user.LoginAlreadyExistsException;
import org.squashtest.tm.service.security.OidcUserCreatorService;
import org.squashtest.tm.service.user.UserAccountService;
import org.squashtest.tm.service.user.UserAdministrationService;

@Service
public class OidcUserCreatorServiceImpl
implements OidcUserCreatorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcUserCreatorServiceImpl.class);
    @Inject
    @Lazy
    private UserAccountService userAccountService;
    @Inject
    @Lazy
    private UserAdministrationService userAdministrationService;
    @Inject
    private UserDetailsManager userDetailsManager;

    public void createMissingSquashUser(Authentication principal) {
        try {
            this.userAccountService.checkLoginAvailability(principal.getName());
        }
        catch (LoginAlreadyExistsException ex) {
            LOGGER.info("Authenticated principal matches an existing User, no new user will be created.", (Throwable)ex);
            return;
        }
        this.createUserFromPrincipal(principal);
    }

    private void createUserFromPrincipal(Authentication principal) {
        try {
            this.createUserAccount(principal);
            this.createSpringSecAccount(principal);
        }
        catch (LoginAlreadyExistsException e) {
            LOGGER.warn("Something went wrong while trying to create missing authenticated user", (Throwable)e);
        }
    }

    private void createUserAccount(Authentication principal) {
        String username = principal.getName().trim();
        org.squashtest.tm.domain.users.User user = org.squashtest.tm.domain.users.User.createFromLogin((String)username);
        if (principal instanceof OAuth2LoginAuthenticationToken) {
            OAuth2LoginAuthenticationToken loginToken = (OAuth2LoginAuthenticationToken)principal;
            this.populateExtraAccountInformationFromOAuth2Token(loginToken, user);
        }
        this.userAdministrationService.createUserWithoutCredentials(user, "squashtest.authz.group.tm.User");
    }

    private void populateExtraAccountInformationFromOAuth2Token(OAuth2LoginAuthenticationToken authentication, org.squashtest.tm.domain.users.User newUser) {
        String lastName;
        DefaultOidcUser oauthUser = (DefaultOidcUser)authentication.getPrincipal();
        if (oauthUser.hasClaim("email") && oauthUser.getEmail() != null && !oauthUser.getEmail().isBlank()) {
            newUser.setEmail(oauthUser.getEmail());
        }
        if ((lastName = (String)oauthUser.getAttribute("name")) != null && !lastName.isBlank()) {
            newUser.setLastName(lastName);
        }
    }

    private void createSpringSecAccount(Authentication principal) {
        String username = principal.getName().trim();
        ArrayList authorities = new ArrayList();
        User springUser = new User(username, "", authorities);
        this.userDetailsManager.createUser((UserDetails)springUser);
    }
}

