/*
 * Decompiled with CFR 0.152.
 */
package jirarest.com.atlassian.jira.rest.client.internal.json;

import jirarest.com.atlassian.jira.rest.client.api.domain.Field;
import jirarest.com.atlassian.jira.rest.client.api.domain.FieldSchema;
import jirarest.com.atlassian.jira.rest.client.api.domain.FieldType;
import jirarest.com.atlassian.jira.rest.client.internal.json.FieldSchemaJsonParser;
import jirarest.com.atlassian.jira.rest.client.internal.json.GenericJsonArrayParser;
import jirarest.com.atlassian.jira.rest.client.internal.json.JsonArrayParser;
import jirarest.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import jirarest.org.codehaus.jettison.json.JSONException;
import jirarest.org.codehaus.jettison.json.JSONObject;

public class FieldJsonParser
implements JsonObjectParser<Field> {
    private final FieldSchemaJsonParser schemaJsonParser = new FieldSchemaJsonParser();

    @Override
    public Field parse(JSONObject jsonObject) throws JSONException {
        String id = jsonObject.getString("id");
        String name = jsonObject.getString("name");
        Boolean orderable = jsonObject.getBoolean("orderable");
        Boolean navigable = jsonObject.getBoolean("navigable");
        Boolean searchable = jsonObject.getBoolean("searchable");
        FieldType custom = jsonObject.getBoolean("custom") ? FieldType.CUSTOM : FieldType.JIRA;
        FieldSchema schema = jsonObject.has("schema") ? this.schemaJsonParser.parse(jsonObject.getJSONObject("schema")) : null;
        return new Field(id, name, custom, orderable, navigable, searchable, schema);
    }

    public static JsonArrayParser<Iterable<Field>> createFieldsArrayParser() {
        return GenericJsonArrayParser.create(new FieldJsonParser());
    }
}

