/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import org.springframework.stereotype.Service;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.plugin.bugtracker.redmine3.Redmine3Connector;
import org.squashtest.tm.service.spi.AdvancedBugTrackerConnector;
import org.squashtest.tm.service.spi.AdvancedBugTrackerConnectorProvider;

@Service(value="squashtest.core.bugtracker.Redmine3RestConnectorProvider")
public class Redmine3RestConnectorProvider
implements AdvancedBugTrackerConnectorProvider {
    private static final String KIND = "redmine3.rest";
    private static final String LABEL = "Redmine 3 REST connector";
    @Inject
    private Provider<Redmine3Connector> connectorProvider;

    public String getBugTrackerKind() {
        return KIND;
    }

    public String getLabel() {
        return LABEL;
    }

    public AdvancedBugTrackerConnector createConnector(BugTracker bugTracker) {
        if (bugTracker == null) {
            throw new NullPointerException("bugTracker");
        }
        Redmine3Connector connector = (Redmine3Connector)this.connectorProvider.get();
        connector.setBugTracker(bugTracker);
        return connector;
    }
}

