/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3;

import com.taskadapter.redmineapi.NotAuthorizedException;
import com.taskadapter.redmineapi.RedmineAuthenticationException;
import com.taskadapter.redmineapi.bean.Attachment;
import com.taskadapter.redmineapi.bean.CustomField;
import com.taskadapter.redmineapi.bean.Issue;
import com.taskadapter.redmineapi.bean.IssueCategory;
import com.taskadapter.redmineapi.bean.IssuePriority;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.User;
import com.taskadapter.redmineapi.bean.Version;
import jakarta.inject.Inject;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.core.BugTrackerLocalException;
import org.squashtest.csp.core.bugtracker.core.UnsupportedAuthenticationModeException;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.BasicAuthenticationCredentials;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.TokenAuthCredentials;
import org.squashtest.tm.plugin.bugtracker.redmine3.Redmine3Client;
import org.squashtest.tm.plugin.bugtracker.redmine3.exception.ExceptionHandler;
import org.squashtest.tm.plugin.bugtracker.redmine3.exception.Redmine3IssueNotFound;
import org.squashtest.tm.plugin.bugtracker.redmine3.exception.Redmine3ProjectNotFound;
import org.squashtest.tm.plugin.bugtracker.redmine3.exception.Redmine3UploadFailed;
import org.squashtest.tm.plugin.bugtracker.redmine3.operations.CreateIssue;
import org.squashtest.tm.plugin.bugtracker.redmine3.operations.FindProjectKeyByName;
import org.squashtest.tm.plugin.bugtracker.redmine3.operations.ForwardAttachments;
import org.squashtest.tm.plugin.bugtracker.redmine3.operations.GetAllUserForProject;
import org.squashtest.tm.plugin.bugtracker.redmine3.operations.GetCategoryForProject;
import org.squashtest.tm.plugin.bugtracker.redmine3.operations.GetCurrentUser;
import org.squashtest.tm.plugin.bugtracker.redmine3.operations.GetCustomFields;
import org.squashtest.tm.plugin.bugtracker.redmine3.operations.GetExtendedTrackerForProject;
import org.squashtest.tm.plugin.bugtracker.redmine3.operations.GetIssue;
import org.squashtest.tm.plugin.bugtracker.redmine3.operations.GetIssues;
import org.squashtest.tm.plugin.bugtracker.redmine3.operations.GetPriorities;
import org.squashtest.tm.plugin.bugtracker.redmine3.operations.GetProjectForCreateById;
import org.squashtest.tm.plugin.bugtracker.redmine3.operations.GetProjectForCreateByKey;
import org.squashtest.tm.plugin.bugtracker.redmine3.operations.GetVersionForProject;
import org.squashtest.tm.plugin.bugtracker.redmine3.operations.Redmine3RestClientOperation;
import org.squashtest.tm.plugin.bugtracker.redmine3.operations.SearchAssignableUsers;
import org.squashtest.tm.plugin.bugtracker.redmine3.operations.SearchPossibleReporter;
import org.squashtest.tm.plugin.bugtracker.redmine3.operations.UploadAttachment;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.Redmine3ExtendedManager;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedCustomField;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.bean.ExtendedTracker;
import org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.converter.FieldNameTranslator;
import org.squashtest.tm.plugin.bugtracker.redmine3.utils.BaseCommunicatorFactory;
import org.squashtest.tm.service.spi.BugTrackerConnector;

@Component
@Scope(value="prototype")
public class Redmine3ClientImpl
implements Redmine3Client {
    private static final Logger LOGGER = LoggerFactory.getLogger(BugTrackerConnector.class);
    private static final String LOG_HEADER = "Redmine REST client : ";
    private static final String AN_ERROR_OCCURED = "an error occured during operation : ";
    @Inject
    private ExceptionHandler exceptionHandler;
    @Inject
    private FieldNameTranslator translator;
    private Redmine3ExtendedManager manager;

    @Override
    public void init(BugTracker bugTracker, Credentials credentials, BaseCommunicatorFactory baseCommunicatorFactory) {
        if (AuthenticationProtocol.BASIC_AUTH.equals((Object)credentials.getImplementedProtocol())) {
            this.initBasicAuthentication(bugTracker, credentials, baseCommunicatorFactory);
        } else if (AuthenticationProtocol.TOKEN_AUTH.equals((Object)credentials.getImplementedProtocol())) {
            this.initTokenAuthentication(bugTracker, credentials, baseCommunicatorFactory);
        } else {
            throw new UnsupportedAuthenticationModeException(credentials.getImplementedProtocol().name());
        }
    }

    @Override
    public Iterable<User> searchAssignableUsers(String projectKey, String namePrefix) {
        SearchAssignableUsers operation = new SearchAssignableUsers(this.manager, projectKey, namePrefix);
        return this.doInCatchBlock(operation);
    }

    @Override
    public Iterable<User> searchPossisbleReporter(String projectKey, String namePrefix) {
        SearchPossibleReporter operation = new SearchPossibleReporter(this.manager, projectKey, namePrefix);
        return this.doInCatchBlock(operation);
    }

    @Override
    public Iterable<IssuePriority> getAllPriorities() {
        GetPriorities operation = new GetPriorities(this.manager);
        return this.doInCatchBlock(operation);
    }

    @Override
    public Issue getIssue(String issueKey) {
        GetIssue operation = new GetIssue(this.manager, issueKey);
        return this.doInCatchBlock(operation);
    }

    @Override
    public Issue createIssue(Issue inputIssue) {
        CreateIssue operation = new CreateIssue(this.manager, inputIssue);
        return this.doInCatchBlock(operation);
    }

    @Override
    public Project findProjectForCreateByKey(String projectKey) {
        GetProjectForCreateByKey operation = new GetProjectForCreateByKey(this.manager, projectKey, this);
        return this.doInCatchBlock(operation);
    }

    @Override
    public Project findProjectForCreateById(Integer id) {
        GetProjectForCreateById operation = new GetProjectForCreateById(this.manager, id, this);
        return this.doInCatchBlock(operation);
    }

    @Override
    public void forwardAttachments(String issueKey, Collection<Attachment> attachments) {
        ForwardAttachments operation = new ForwardAttachments(this.manager, issueKey, attachments);
        this.doInCatchBlock(operation);
    }

    @Override
    public List<Issue> getIssues(List<String> issueKeys) {
        GetIssues operation = new GetIssues(this.manager, issueKeys, this.translator.getFakeIssueSubject());
        return this.doInCatchBlock(operation);
    }

    @Override
    public String findProjectKeyByName(String projectName) {
        FindProjectKeyByName operation = new FindProjectKeyByName(this.manager, projectName);
        return this.doInCatchBlock(operation);
    }

    @Override
    public Attachment uploadAttachment(String fileName, InputStream in) {
        UploadAttachment operation = new UploadAttachment(this.manager, fileName, in);
        return this.doInCatchBlock(operation);
    }

    private BugTrackerLocalException logAndThrowLocalException(String message, Exception cause) {
        LOGGER.error(message);
        return new BugTrackerLocalException(message, (Throwable)cause);
    }

    private <ANY> ANY doInCatchBlock(Redmine3RestClientOperation<? extends ANY> operation) {
        try {
            return operation.doIt();
        }
        catch (Redmine3ProjectNotFound ex) {
            LOGGER.error("Redmine REST client : project indentified by " + ex.getMessage(), (Throwable)ex);
            throw this.exceptionHandler.projectNotFound(ex);
        }
        catch (NotAuthorizedException ex) {
            LOGGER.error("Redmine REST client : an error occured during operation : " + operation.getName(), (Throwable)ex);
            throw this.exceptionHandler.notAuthorizedException(ex);
        }
        catch (RedmineAuthenticationException ex) {
            throw this.exceptionHandler.redmineAuthenticationException(ex);
        }
        catch (NumberFormatException ex) {
            LOGGER.error("Redmine REST client : an error occured during operation : " + operation.getName(), (Throwable)ex);
            throw this.exceptionHandler.numberConversionFailure(ex);
        }
        catch (Redmine3UploadFailed ex) {
            LOGGER.error("Redmine REST client : an error occured during operation : " + operation.getName(), (Throwable)ex);
            throw this.exceptionHandler.genericError(ex, "Upload failed");
        }
        catch (Redmine3IssueNotFound ex) {
            LOGGER.error("Redmine REST client : an error occured during operation : " + operation.getName(), (Throwable)ex);
            throw this.exceptionHandler.issueNotFound(ex);
        }
        catch (Exception ex) {
            LOGGER.error("Redmine REST client : an error occured during operation : " + operation.getName(), (Throwable)ex);
            throw this.exceptionHandler.genericError(ex);
        }
    }

    @Override
    public User getCurrentUser() {
        GetCurrentUser operation = new GetCurrentUser(this.manager);
        return this.doInCatchBlock(operation);
    }

    @Override
    public void insertIdForCustomFields(Issue inputIssue) {
        GetCustomFields operation = new GetCustomFields(this.manager);
        List<ExtendedCustomField> customFields = this.doInCatchBlock(operation);
        Map<String, Integer> map = this.mapCustomFieldsNameToId(customFields);
        for (CustomField c : inputIssue.getCustomFields()) {
            c.setId(map.get(c.getName()));
        }
    }

    private Map<String, Integer> mapCustomFieldsNameToId(List<ExtendedCustomField> customFields) {
        HashMap<String, Integer> map = new HashMap<String, Integer>(customFields.size());
        for (CustomField customField : customFields) {
            map.put(customField.getName(), customField.getId());
        }
        return map;
    }

    @Override
    public void insertIdForAssignee(Issue inputIssue) {
        SearchAssignableUsers operation = new SearchAssignableUsers(this.manager, inputIssue.getProject().getIdentifier(), "");
        User assigne = inputIssue.getAssignee();
        if (assigne != null && !"".equals(assigne.getFirstName())) {
            List<User> users = this.doInCatchBlock(operation);
            Map<String, Integer> map = this.mapUserFullNameToId(users);
            int id = map.get(assigne.getFullName());
            assigne.setId(id);
        }
    }

    private Map<String, Integer> mapUserFullNameToId(List<User> users) {
        HashMap<String, Integer> map = new HashMap<String, Integer>(users.size());
        for (User u : users) {
            map.put(u.getFullName(), u.getId());
        }
        return map;
    }

    @Override
    public List<User> getUserForProject(Project project) {
        GetAllUserForProject operation = new GetAllUserForProject(this.manager, project);
        return this.doInCatchBlock(operation);
    }

    @Override
    public List<ExtendedTracker> getExtendedTrackersForProject(Project project) {
        GetExtendedTrackerForProject operation = new GetExtendedTrackerForProject(this.manager, project);
        return this.doInCatchBlock(operation);
    }

    @Override
    public List<Version> getVersionForProject(Project project) {
        GetVersionForProject operation = new GetVersionForProject(this.manager, project);
        return this.doInCatchBlock(operation);
    }

    @Override
    public List<IssueCategory> getCategoryForProject(Project project) {
        GetCategoryForProject operation = new GetCategoryForProject(this.manager, project);
        return this.doInCatchBlock(operation);
    }

    @Override
    public void verifyAssigneAssignable(Issue inputIssue) {
        SearchAssignableUsers operation = new SearchAssignableUsers(this.manager, inputIssue.getProject().getIdentifier(), "");
        User assigne = inputIssue.getAssignee();
        List<User> users = this.doInCatchBlock(operation);
        boolean assignable = false;
        if (assigne == null || "".equals(assigne.getFirstName())) {
            assignable = true;
        } else {
            for (User u : users) {
                if (!u.getFullName().equals(assigne.getFullName())) continue;
                assignable = true;
                break;
            }
            if (!assignable) {
                throw this.exceptionHandler.userNotAssignable(new Exception());
            }
        }
    }

    private void initBasicAuthentication(BugTracker bugTracker, Credentials credentials, BaseCommunicatorFactory baseCommunicatorFactory) {
        BasicAuthenticationCredentials basicAuthCredentials = (BasicAuthenticationCredentials)credentials;
        try {
            this.manager = new Redmine3ExtendedManager(bugTracker.getUrl(), basicAuthCredentials.getUsername(), String.valueOf(basicAuthCredentials.getPassword()), baseCommunicatorFactory);
        }
        catch (IllegalArgumentException exception) {
            this.logAndThrowLocalExceptionForAuthentication(bugTracker.getUrl(), exception);
        }
    }

    private void initTokenAuthentication(BugTracker bugTracker, Credentials credentials, BaseCommunicatorFactory baseCommunicatorFactory) {
        TokenAuthCredentials tokenAuthCredentials = (TokenAuthCredentials)credentials;
        try {
            this.manager = new Redmine3ExtendedManager(bugTracker.getUrl(), tokenAuthCredentials.getToken(), baseCommunicatorFactory);
        }
        catch (IllegalArgumentException exception) {
            this.logAndThrowLocalExceptionForAuthentication(bugTracker.getUrl(), exception);
        }
    }

    private void logAndThrowLocalExceptionForAuthentication(String url, Exception exception) {
        throw this.logAndThrowLocalException(String.format("%surl %s is invalid", LOG_HEADER, url), exception);
    }
}

