/*
 * Decompiled with CFR 0.152.
 */
package workflowautomjira.com.atlassian.jira.rest.client.internal.json;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.CimFieldInfo;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.FieldSchema;
import workflowautomjira.com.atlassian.jira.rest.client.api.domain.StandardOperation;
import workflowautomjira.com.atlassian.jira.rest.client.internal.json.BasicComponentJsonParser;
import workflowautomjira.com.atlassian.jira.rest.client.internal.json.BasicPriorityJsonParser;
import workflowautomjira.com.atlassian.jira.rest.client.internal.json.BasicProjectJsonParser;
import workflowautomjira.com.atlassian.jira.rest.client.internal.json.CustomFieldOptionJsonParser;
import workflowautomjira.com.atlassian.jira.rest.client.internal.json.FieldSchemaJsonParser;
import workflowautomjira.com.atlassian.jira.rest.client.internal.json.GenericJsonArrayParser;
import workflowautomjira.com.atlassian.jira.rest.client.internal.json.IssueTypeJsonParser;
import workflowautomjira.com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import workflowautomjira.com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import workflowautomjira.com.atlassian.jira.rest.client.internal.json.ResolutionJsonParser;
import workflowautomjira.com.atlassian.jira.rest.client.internal.json.SecurityLevelJsonParser;
import workflowautomjira.com.atlassian.jira.rest.client.internal.json.VersionJsonParser;
import workflowautomjira.javax.annotation.Nullable;
import workflowautomjira.org.codehaus.jettison.json.JSONArray;
import workflowautomjira.org.codehaus.jettison.json.JSONException;
import workflowautomjira.org.codehaus.jettison.json.JSONObject;

public class CimFieldsInfoJsonParser
implements JsonObjectParser<CimFieldInfo> {
    private final FieldSchemaJsonParser fieldSchemaJsonParser = new FieldSchemaJsonParser();
    protected final Map<String, JsonObjectParser> registeredAllowedValueParsers = new HashMap<String, JsonObjectParser>(){
        {
            this.put("project", new BasicProjectJsonParser());
            this.put("version", new VersionJsonParser());
            this.put("issuetype", new IssueTypeJsonParser());
            this.put("priority", new BasicPriorityJsonParser());
            this.put("customFieldOption", new CustomFieldOptionJsonParser());
            this.put("component", new BasicComponentJsonParser());
            this.put("resolution", new ResolutionJsonParser());
            this.put("securitylevel", new SecurityLevelJsonParser());
        }
    };

    @Override
    public CimFieldInfo parse(JSONObject json) throws JSONException {
        String id = JsonParseUtil.getOptionalString(json, "id");
        return this.parse(json, id);
    }

    public CimFieldInfo parse(JSONObject json, String id) throws JSONException {
        boolean required = json.getBoolean("required");
        String name = JsonParseUtil.getOptionalString(json, "name");
        FieldSchema schema = this.fieldSchemaJsonParser.parse(json.getJSONObject("schema"));
        Set<StandardOperation> operations = this.parseOperations(json.getJSONArray("operations"));
        Iterable<Object> allowedValues = this.parseAllowedValues(json.optJSONArray("allowedValues"), schema);
        URI autoCompleteUri = JsonParseUtil.parseOptionalURI(json, "autoCompleteUrl");
        return new CimFieldInfo(id, required, name, schema, operations, allowedValues, autoCompleteUri);
    }

    private Iterable<Object> parseAllowedValues(@Nullable JSONArray allowedValues, FieldSchema fieldSchema) throws JSONException {
        if (allowedValues == null || allowedValues.equals(JSONObject.NULL)) {
            return null;
        }
        if (allowedValues.length() == 0) {
            return Collections.emptyList();
        }
        JsonObjectParser<Object> allowedValuesJsonParser = this.getParserFor(fieldSchema);
        if (allowedValuesJsonParser != null) {
            boolean isProjectCF = "project".equals(fieldSchema.getType()) && "workflowautomjira.com.atlassian.jira.plugin.system.customfieldtypes:project".equals(fieldSchema.getCustom());
            boolean isVersionCF = "version".equals(fieldSchema.getType()) && "workflowautomjira.com.atlassian.jira.plugin.system.customfieldtypes:version".equals(fieldSchema.getCustom());
            boolean isMultiVersionCF = "array".equals(fieldSchema.getType()) && "version".equals(fieldSchema.getItems()) && "workflowautomjira.com.atlassian.jira.plugin.system.customfieldtypes:multiversion".equals(fieldSchema.getCustom());
            JSONArray valuesToParse = (isProjectCF || isVersionCF || isMultiVersionCF) && allowedValues.get(0) instanceof JSONArray ? allowedValues.getJSONArray(0) : allowedValues;
            return GenericJsonArrayParser.create(allowedValuesJsonParser).parse(valuesToParse);
        }
        int itemsLength = allowedValues.length();
        ArrayList res = Lists.newArrayListWithExpectedSize((int)itemsLength);
        for (int i = 0; i < itemsLength; ++i) {
            res.add(allowedValues.get(i));
        }
        return res;
    }

    private Set<StandardOperation> parseOperations(JSONArray operations) throws JSONException {
        int operationsCount = operations.length();
        HashSet res = Sets.newHashSetWithExpectedSize((int)operationsCount);
        for (int i = 0; i < operationsCount; ++i) {
            String opName = operations.getString(i);
            StandardOperation op = StandardOperation.valueOf(opName.toUpperCase());
            res.add(op);
        }
        return res;
    }

    @Nullable
    private JsonObjectParser<Object> getParserFor(FieldSchema fieldSchema) throws JSONException {
        JsonObjectParser jsonParser;
        ImmutableSet customFieldsTypesWithFieldOption = ImmutableSet.of((Object)"workflowautomjira.com.atlassian.jira.plugin.system.customfieldtypes:multicheckboxes", (Object)"workflowautomjira.com.atlassian.jira.plugin.system.customfieldtypes:radiobuttons", (Object)"workflowautomjira.com.atlassian.jira.plugin.system.customfieldtypes:select", (Object)"workflowautomjira.com.atlassian.jira.plugin.system.customfieldtypes:cascadingselect", (Object)"workflowautomjira.com.atlassian.jira.plugin.system.customfieldtypes:multiselect");
        String type = "array".equals(fieldSchema.getType()) ? fieldSchema.getItems() : fieldSchema.getType();
        String custom = fieldSchema.getCustom();
        if (custom != null && customFieldsTypesWithFieldOption.contains(custom)) {
            type = "customFieldOption";
        }
        if ((jsonParser = this.registeredAllowedValueParsers.get(type)) == null) {
            return null;
        }
        return jsonParser;
    }
}

