/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.gitlab.dao;

import java.util.Collections;
import java.util.List;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.plugin.bugtracker.gitlab.domain.GitLabIssueKey;

@Repository
public class GitLabIssueKeyDao {
    private final DSLContext dslContext;

    public GitLabIssueKeyDao(DSLContext dslContext) {
        this.dslContext = dslContext;
    }

    public GitLabIssueKey fetchGitLabIssueKey(Long bugtrackerId, String remoteIssueKey) {
        return this.fetchGitLabIssueKeys(bugtrackerId, Collections.singletonList(remoteIssueKey)).getFirst();
    }

    public List<GitLabIssueKey> fetchGitLabIssueKeys(Long bugtrackerId, List<String> remoteIssueKeys) {
        return this.dslContext.select((SelectField)Tables.ISSUE.ADDITIONAL_DATA).from((TableLike)Tables.ISSUE).innerJoin((TableLike)Tables.BUGTRACKER).using(new Field[]{Tables.BUGTRACKER.BUGTRACKER_ID}).where(Tables.ISSUE.REMOTE_ISSUE_ID.in(remoteIssueKeys)).and(Tables.BUGTRACKER.BUGTRACKER_ID.eq((Object)bugtrackerId)).fetch(record -> GitLabIssueKey.fromJsonString((String)record.get((Field)Tables.ISSUE.ADDITIONAL_DATA)));
    }

    public GitLabIssueKey fetchGitLabIssueKey(String remoteIssueKey) {
        return this.fetchGitLabIssueKeys(Collections.singletonList(remoteIssueKey)).getFirst();
    }

    public List<GitLabIssueKey> fetchGitLabIssueKeys(List<String> remoteIssueKeys) {
        return this.dslContext.select((SelectField)Tables.ISSUE.ADDITIONAL_DATA).from((TableLike)Tables.ISSUE).innerJoin((TableLike)Tables.BUGTRACKER).using(new Field[]{Tables.BUGTRACKER.BUGTRACKER_ID}).where(Tables.ISSUE.REMOTE_ISSUE_ID.in(remoteIssueKeys)).fetch(record -> GitLabIssueKey.fromJsonString((String)record.get((Field)Tables.ISSUE.ADDITIONAL_DATA)));
    }
}

