/*
 * Decompiled with CFR 0.152.
 */
package gitlabbt.org.glassfish.jersey.jackson.internal;

import gitlabbt.com.fasterxml.jackson.core.JsonGenerator;
import gitlabbt.com.fasterxml.jackson.databind.AnnotationIntrospector;
import gitlabbt.com.fasterxml.jackson.databind.ObjectMapper;
import gitlabbt.com.fasterxml.jackson.databind.ObjectWriter;
import gitlabbt.com.fasterxml.jackson.databind.introspect.Annotated;
import gitlabbt.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import gitlabbt.com.fasterxml.jackson.databind.introspect.AnnotatedField;
import gitlabbt.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import gitlabbt.com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import gitlabbt.com.fasterxml.jackson.databind.ser.BeanPropertyFilter;
import gitlabbt.com.fasterxml.jackson.databind.ser.FilterProvider;
import gitlabbt.com.fasterxml.jackson.databind.ser.PropertyFilter;
import gitlabbt.org.glassfish.jersey.internal.util.ReflectionHelper;
import gitlabbt.org.glassfish.jersey.jackson.internal.DefaultJacksonJaxbJsonProvider;
import gitlabbt.org.glassfish.jersey.jackson.internal.jackson.jaxrs.cfg.EndpointConfigBase;
import gitlabbt.org.glassfish.jersey.jackson.internal.jackson.jaxrs.cfg.ObjectWriterInjector;
import gitlabbt.org.glassfish.jersey.jackson.internal.jackson.jaxrs.cfg.ObjectWriterModifier;
import gitlabbt.org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JsonEndpointConfig;
import gitlabbt.org.glassfish.jersey.message.filtering.spi.ObjectProvider;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

@Singleton
public final class FilteringJacksonJaxbJsonProvider
extends DefaultJacksonJaxbJsonProvider {
    private final Provider<ObjectProvider<FilterProvider>> provider;

    @Inject
    public FilteringJacksonJaxbJsonProvider(@Context Provider<ObjectProvider<FilterProvider>> provider, @Context Providers providers, @Context Configuration config) {
        super(providers, config);
        this.provider = provider;
    }

    @Override
    protected JsonEndpointConfig _configForWriting(ObjectMapper mapper, Annotation[] annotations, Class<?> defaultView) {
        AnnotationIntrospector customIntrospector = mapper.getSerializationConfig().getAnnotationIntrospector();
        ObjectMapper filteringMapper = mapper.setAnnotationIntrospector(AnnotationIntrospector.pair(customIntrospector, new JacksonAnnotationIntrospector(){

            @Override
            public Object findFilterId(Annotated a) {
                Method method;
                Object filterId = super.findFilterId(a);
                if (filterId != null) {
                    return filterId;
                }
                if (a instanceof AnnotatedMethod && ReflectionHelper.isGetter(method = ((AnnotatedMethod)a).getAnnotated())) {
                    return ReflectionHelper.getPropertyName(method);
                }
                if (a instanceof AnnotatedField || a instanceof AnnotatedClass) {
                    return a.getName();
                }
                return null;
            }
        }));
        return (JsonEndpointConfig)super._configForWriting(filteringMapper, annotations, defaultView);
    }

    @Override
    public void writeTo(Object value, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        FilterProvider filterProvider = (FilterProvider)((ObjectProvider)this.provider.get()).getFilteringObject(genericType, true, annotations);
        if (filterProvider != null) {
            ObjectWriterInjector.set(new FilteringObjectWriterModifier(filterProvider, ObjectWriterInjector.getAndClear()));
        }
        super.writeTo(value, type, genericType, annotations, mediaType, httpHeaders, entityStream);
    }

    private static final class FilteringObjectWriterModifier
    extends ObjectWriterModifier {
        private final ObjectWriterModifier original;
        private final FilterProvider filterProvider;

        private FilteringObjectWriterModifier(FilterProvider filterProvider, ObjectWriterModifier original) {
            this.original = original;
            this.filterProvider = filterProvider;
        }

        @Override
        public ObjectWriter modify(EndpointConfigBase<?> endpoint, MultivaluedMap<String, Object> responseHeaders, Object valueToWrite, ObjectWriter w, JsonGenerator g) throws IOException {
            ObjectWriter writer = this.original == null ? w : this.original.modify(endpoint, responseHeaders, valueToWrite, w, g);
            final FilterProvider customFilterProvider = writer.getConfig().getFilterProvider();
            return customFilterProvider == null ? writer.with(this.filterProvider) : writer.with(new FilterProvider(){

                @Override
                public BeanPropertyFilter findFilter(Object filterId) {
                    return customFilterProvider.findFilter(filterId);
                }

                @Override
                public PropertyFilter findPropertyFilter(Object filterId, Object valueToFilter) {
                    PropertyFilter filter = customFilterProvider.findPropertyFilter(filterId, valueToFilter);
                    if (filter != null) {
                        return filter;
                    }
                    return filterProvider.findPropertyFilter(filterId, valueToFilter);
                }
            });
        }
    }
}

