/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.validators;

import jakarta.inject.Inject;
import java.util.List;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.plugin.rest.core.jackson.DeserializationHints;
import org.squashtest.tm.plugin.rest.core.validation.HintedValidator;
import org.squashtest.tm.plugin.rest.jackson.model.CustomFieldValueDto;
import org.squashtest.tm.plugin.rest.jackson.model.WrappedDtoWithCustomFields;
import org.squashtest.tm.plugin.rest.validators.helper.CustomFieldValueValidationHelper;
import org.squashtest.tm.service.customfield.CustomFieldBindingFinderService;
import org.squashtest.tm.service.customfield.CustomFieldValueChangerService;
import org.squashtest.tm.service.customfield.CustomFieldValueFinderService;

@Component
public class CustomFieldValueHintedValidator
implements HintedValidator {
    @Inject
    private CustomFieldValueFinderService cufService;
    @Inject
    private CustomFieldBindingFinderService bindingService;
    @Inject
    @Lazy
    private CustomFieldValueChangerService customFieldValueChangerService;

    public boolean supports(Class<?> clazz) {
        return WrappedDtoWithCustomFields.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
    }

    public void validateWithHints(Object target, Errors errors, DeserializationHints hints) {
        WrappedDtoWithCustomFields wrapped = (WrappedDtoWithCustomFields)((Object)target);
        GenericProject project = hints.getProject();
        Object entity = wrapped.getWrapped();
        List<CustomFieldValueDto> dtos = wrapped.getCustomFields();
        List customFields = this.bindingService.findBoundCustomFields(project.getId().longValue(), entity.getBoundEntityType());
        CustomFieldValueValidationHelper helper = new CustomFieldValueValidationHelper(this.customFieldValueChangerService, entity.getBoundEntityType(), project.getId(), customFields, dtos, errors);
        helper.validate();
    }
}

