/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.controller;

import jakarta.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.LinkBuilder;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.squashtest.tm.plugin.rest.admin.jackson.model.ReportingFieldDto;
import org.squashtest.tm.plugin.rest.admin.service.RestReportingFieldService;
import org.squashtest.tm.plugin.rest.admin.validators.ReportingFieldValidator;
import org.squashtest.tm.plugin.rest.core.web.BasePathAwareLinkBuildingService;
import org.squashtest.tm.plugin.rest.core.web.RestApiController;
import org.squashtest.tm.plugin.rest.core.web.UseDefaultRestApiConfiguration;

@RestApiController
@UseDefaultRestApiConfiguration
@ConditionalOnClass(name={"org.squashtest.tm.plugin.rest.admin.SquashAdminApiConditionalInterface"})
public class RestReportingFieldController {
    @Inject
    private RestReportingFieldService restReportingFieldService;
    @Inject
    private ReportingFieldValidator reportingFieldValidator;
    @Inject
    private BasePathAwareLinkBuildingService linkService;

    @GetMapping(value={"/projects/{id}/reporting-fields/{squashField}"})
    public ResponseEntity<EntityModel<ReportingFieldDto>> getReportingFieldBySquashFieldForProject(@PathVariable(value="id") Long projectId, @PathVariable(value="squashField") String squashField) {
        ReportingFieldDto reportingField = this.restReportingFieldService.getReportingFieldBySquashFieldForProject(projectId, squashField);
        EntityModel<ReportingFieldDto> resource = this.toReportingFieldResource(projectId, reportingField);
        return ResponseEntity.ok(resource);
    }

    private EntityModel<ReportingFieldDto> toReportingFieldResource(long projectId, ReportingFieldDto entity) {
        EntityModel resource = EntityModel.of((Object)entity);
        LinkBuilder linkBuilder = this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestReportingFieldController)WebMvcLinkBuilder.methodOn(RestReportingFieldController.class, (Object[])new Object[0])).getReportingFieldBySquashFieldForProject(projectId, entity.getSquashField())));
        resource.add(linkBuilder.withSelfRel());
        return resource;
    }

    @GetMapping(value={"/projects/{id}/reporting-fields"})
    public ResponseEntity<PagedModel<EntityModel>> getAllReportingFieldsByProject(@PathVariable(value="id") Long projectId) {
        List<ReportingFieldDto> reportingFieldDtoList = this.restReportingFieldService.getAllReportingFieldsByProject(projectId);
        PagedModel<EntityModel> resource = this.toReportingFieldPagedResources(reportingFieldDtoList, projectId);
        return ResponseEntity.ok(resource);
    }

    private PagedModel<EntityModel> toReportingFieldPagedResources(Collection<ReportingFieldDto> content, long projectId) {
        Collection resourceCollection = content.stream().map(reportingField -> this.toReportingFieldResource(projectId, (ReportingFieldDto)reportingField)).collect(Collectors.toList());
        PagedModel.PageMetadata metadata = new PagedModel.PageMetadata((long)resourceCollection.size(), 0L, (long)resourceCollection.size());
        LinkBuilder linkBuilder = this.linkService.fromBasePath(WebMvcLinkBuilder.linkTo(((RestReportingFieldController)WebMvcLinkBuilder.methodOn(RestReportingFieldController.class, (Object[])new Object[0])).getAllReportingFieldsByProject(projectId)));
        return PagedModel.of((Collection)resourceCollection, (PagedModel.PageMetadata)metadata, (Link[])new Link[]{linkBuilder.withSelfRel()});
    }

    @PatchMapping(value={"/projects/{id}/reporting-fields/{squashField}"})
    public ResponseEntity<EntityModel<ReportingFieldDto>> updateReportingFieldBySquashFieldForProject(@PathVariable(value="id") Long projectId, @PathVariable(value="squashField") String squashField, @RequestBody ReportingFieldDto reportingFieldDto) throws BindException {
        this.reportingFieldValidator.validatePatchReportingField(projectId, squashField, reportingFieldDto);
        ReportingFieldDto reportingField = this.restReportingFieldService.updateReportingField(projectId, squashField, reportingFieldDto);
        EntityModel<ReportingFieldDto> resource = this.toReportingFieldResource(projectId, reportingField);
        return ResponseEntity.ok(resource);
    }
}

