/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.controller;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.squashtest.tm.service.feature.experimental.ExperimentalFeatureManager;

@Controller
public class JiraSyncIndexController {
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraSyncIndexController.class);
    private final ExperimentalFeatureManager experimentalFeatureManager;

    public JiraSyncIndexController(ExperimentalFeatureManager experimentalFeatureManager) {
        this.experimentalFeatureManager = experimentalFeatureManager;
    }

    @GetMapping(value={"/plugin/jirasync/index"})
    public String index(Model model) {
        List<String> flags = this.experimentalFeatureManager.getEnabledFeatures().stream().map(Enum::name).toList();
        model.addAttribute("experimentalFeatureFlags", flags);
        LOGGER.debug("Page request forwarded to jirasync index controller. Single page app will be served with current context path.");
        LOGGER.debug("Experimental feature flags: {}", flags);
        return "plugin/jirasync/index.html";
    }
}

