/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.jirasync.client;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import jirasync.com.atlassian.httpclient.api.HttpStatus;
import jirasync.com.atlassian.httpclient.api.Request;
import jirasync.com.atlassian.jira.rest.client.api.AuthenticationHandler;
import jirasync.com.atlassian.jira.rest.client.api.IssueRestClient;
import jirasync.com.atlassian.jira.rest.client.api.JiraRestClient;
import jirasync.com.atlassian.jira.rest.client.api.MetadataRestClient;
import jirasync.com.atlassian.jira.rest.client.api.RestClientException;
import jirasync.com.atlassian.jira.rest.client.api.SearchRestClient;
import jirasync.com.atlassian.jira.rest.client.api.domain.BasicIssue;
import jirasync.com.atlassian.jira.rest.client.api.domain.Field;
import jirasync.com.atlassian.jira.rest.client.api.domain.FieldSchema;
import jirasync.com.atlassian.jira.rest.client.api.domain.FieldType;
import jirasync.com.atlassian.jira.rest.client.api.domain.Issue;
import jirasync.com.atlassian.jira.rest.client.api.domain.IssueLink;
import jirasync.com.atlassian.jira.rest.client.api.domain.SearchResult;
import jirasync.com.atlassian.jira.rest.client.api.domain.Version;
import jirasync.com.atlassian.jira.rest.client.api.domain.input.FieldInput;
import jirasync.com.atlassian.jira.rest.client.api.domain.input.IssueInput;
import jirasync.com.atlassian.jira.rest.client.internal.json.VersionJsonParser;
import jirasync.io.atlassian.util.concurrent.Promise;
import jirasync.org.apache.http.util.EncodingUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsException;
import org.squashtest.csp.core.bugtracker.core.BugTrackerRemoteException;
import org.squashtest.csp.core.bugtracker.core.UnsupportedAuthenticationModeException;
import org.squashtest.tm.domain.bugtracker.BugTracker;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.BasicAuthenticationCredentials;
import org.squashtest.tm.domain.servers.Credentials;
import org.squashtest.tm.domain.servers.OAuth2Credentials;
import org.squashtest.tm.plugin.jirasync.LocaleWithFallback;
import org.squashtest.tm.plugin.jirasync.client.AsynchronousPluginRestClient;
import org.squashtest.tm.plugin.jirasync.client.ExtendedAsynchronousJiraRestClient;
import org.squashtest.tm.plugin.jirasync.client.ExtendedJiraClientFactory;
import org.squashtest.tm.plugin.jirasync.client.JiraReport;
import org.squashtest.tm.plugin.jirasync.domain.Configuration;
import org.squashtest.tm.plugin.jirasync.domain.FieldMapping;
import org.squashtest.tm.plugin.jirasync.domain.JiraSprintState;
import org.squashtest.tm.plugin.jirasync.domain.execplan.ExecplanIssue;
import org.squashtest.tm.plugin.jirasync.helpers.JiraHelper;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraAgileIssue;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraBoard;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraHtmlIssueDescription;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraPagedResource;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraPaginatedResourceParser;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraSearchResult;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraSearchResultParser;
import org.squashtest.tm.plugin.jirasync.jsonext.JiraSprint;
import org.squashtest.tm.plugin.jirasync.service.JiraReportingEffectiveConfiguration;
import org.squashtest.tm.plugin.jirasync.service.SynchronisationEffectiveConfiguration;
import org.squashtest.tm.plugin.jirasync.service.ValueMappings;
import org.squashtest.tm.web.i18n.InternationalizationHelper;
import org.yaml.snakeyaml.Yaml;

@Component(value="squash.tm.plugin.jirasync.jiraClient")
@Scope(value="prototype")
public class JiraClient
implements Closeable {
    public static final Set<AuthenticationProtocol> PROTOCOLS = ImmutableSet.builder().add((Object[])new AuthenticationProtocol[]{AuthenticationProtocol.BASIC_AUTH, AuthenticationProtocol.OAUTH_2}).build();
    private static final Set<String> REQUIRED_SEARCHED_FIELDS = new HashSet<String>();
    public static final String SPRINT_FIELD_IDENTIFIER = "com.pyxis.greenhopper.jira:gh-sprint";
    private static final String HTTP_AUTHORIZATION = "Authorization";
    private static final String ATLASSIAN_OAUTH2_REST_API_ENDPOINT_STARTER = "https://api.atlassian.com/ex/jira/";
    private static final String PARENT_JQL = "\"parent\" = ";
    public static final String MAX_RESULTS = "maxResults";
    public static final int DEFAULT_MAX_RESULTS = 100;
    public static final String START_AT = "startAt";
    public static final String JQL = "jql";
    public static final String FIELDS = "fields";
    public static final String NEXT_PAGE_TOKEN = "nextPageToken";
    public static final String ORDER_BY = "orderBy";
    public static final String TOTAL = "total";
    private static final Logger LOGGER;
    @Inject
    private InternationalizationHelper langHelper;
    @Inject
    private JiraHelper jiraHelper;
    private JiraRestClient client;
    private final Locale locale = LocaleWithFallback.getLocaleWithFallback();
    private String jiraInstanceType;

    static {
        REQUIRED_SEARCHED_FIELDS.add("summary");
        REQUIRED_SEARCHED_FIELDS.add("issuetype");
        REQUIRED_SEARCHED_FIELDS.add("created");
        REQUIRED_SEARCHED_FIELDS.add("updated");
        REQUIRED_SEARCHED_FIELDS.add("project");
        REQUIRED_SEARCHED_FIELDS.add("status");
        REQUIRED_SEARCHED_FIELDS.add("attachments");
        REQUIRED_SEARCHED_FIELDS.add("attachment");
        REQUIRED_SEARCHED_FIELDS.add(FIELDS);
        LOGGER = LoggerFactory.getLogger(JiraClient.class);
    }

    public void initialize(BugTracker server, Credentials credentials) {
        URI uri;
        this.jiraInstanceType = this.jiraHelper.getJiraInstanceType(server.getUrl());
        String baseUrl = this.serverKindIsJiraCloudWithOauth2(server) ? this.generateJiraCloudApiBaseUrl(server, credentials) : (this.serverKindIsXSquashTypeWithOauth2(server) && this.isJiraCloudServer() ? this.generateJiraCloudApiBaseUrl(server, credentials) : server.getUrl());
        try {
            uri = new URI(baseUrl);
        }
        catch (URISyntaxException uRISyntaxException) {
            String msg = this.langHelper.getMessage("henix.jirasync.validation.invalidurl", new Object[]{baseUrl}, "wrong url", this.locale);
            LOGGER.error(msg);
            throw new RuntimeException(msg);
        }
        AuthenticationHandler handler = JiraClient.createAuthHandler(credentials);
        LOGGER.trace("attempting to create the client using custom factory");
        this.client = new ExtendedJiraClientFactory().create(uri, handler);
        LOGGER.trace("client created successfully");
    }

    public boolean isJiraCloudServer() {
        return "cloud".equalsIgnoreCase(this.jiraInstanceType);
    }

    private String generateJiraCloudApiBaseUrl(BugTracker bugTracker, Credentials credentials) {
        String cloudId = this.jiraHelper.getCloudIdForOauth2ApiRequest(bugTracker, (OAuth2Credentials)credentials);
        return ATLASSIAN_OAUTH2_REST_API_ENDPOINT_STARTER + cloudId;
    }

    private boolean serverKindIsJiraCloudWithOauth2(BugTracker server) {
        return "jira.cloud".equalsIgnoreCase(server.getKind()) && server.getAuthenticationProtocol() == AuthenticationProtocol.OAUTH_2;
    }

    private boolean serverKindIsXSquashTypeWithOauth2(BugTracker server) {
        return "jira.xsquash".equalsIgnoreCase(server.getKind()) && server.getAuthenticationProtocol() == AuthenticationProtocol.OAUTH_2;
    }

    @Override
    public void close() {
        try {
            this.client.close();
        }
        catch (IOException ex) {
            LOGGER.error("could not close client : ", (Throwable)ex);
        }
    }

    public void checkCredentials() {
        try {
            this.client.getMetadataClient().getPriorities().claim();
        }
        catch (RestClientException ex) {
            if (ex.getStatusCode().isPresent() && ((Integer)ex.getStatusCode().get()).equals(HttpStatus.UNAUTHORIZED.code)) {
                String msg = this.langHelper.getMessage("henix.jirasync.dummyconnector.accessdenied", null, "authentication failed", this.locale);
                throw new BugTrackerNoCredentialsException(msg, (Throwable)ex);
            }
            LOGGER.error("Error occured while checking the credentials", (Throwable)ex);
            Object[] erArgs = new Object[]{ex.getMessage()};
            String msg = this.langHelper.getMessage("henix.jirasync.dummyconnector.unexpectederror", erArgs, "an error occured", this.locale);
            throw new BugTrackerRemoteException(msg, (Throwable)ex);
        }
    }

    public SynchronisationEffectiveConfiguration createEffectiveConfiguration(Configuration userConf) {
        SynchronisationEffectiveConfiguration eff = new SynchronisationEffectiveConfiguration();
        eff.setSprintFieldId(this.findSprintFieldIdentifier());
        Map<String, SynchronisationEffectiveConfiguration.EffectiveMapping> mappings = this.createEffectiveFieldMap(userConf);
        eff.setFieldMappings(mappings);
        if (mappings.containsKey("(internal - Epic link)")) {
            eff.setEpicLinkId(mappings.get("(internal - Epic link)").getJiraField());
            mappings.remove("(internal - Epic link)");
        }
        eff.setValueMappings(this.getValueMappings(userConf));
        return eff;
    }

    public JiraReportingEffectiveConfiguration createJiraReportingEffectiveConfiguration(Configuration configuration) {
        JiraReportingEffectiveConfiguration effectiveConfiguration = new JiraReportingEffectiveConfiguration();
        MetadataRestClient metadataClient = this.client.getMetadataClient();
        Iterable<Field> fields = metadataClient.getFields().claim();
        Map fieldByName = StreamSupport.stream(fields.spliterator(), false).filter(field -> field.getFieldType().equals((Object)FieldType.CUSTOM)).collect(Collectors.toMap(Field::getName, Function.identity(), (u, v) -> {
            LOGGER.debug(String.format("Duplicate custom field key %s", u));
            return v;
        }, LinkedHashMap::new));
        this.configureRedactionProgressField(configuration, effectiveConfiguration, fieldByName);
        this.configureVerificationProgressField(configuration, effectiveConfiguration, fieldByName);
        this.configureValidationProgressField(configuration, effectiveConfiguration, fieldByName);
        this.configureRedactionRatioField(configuration, effectiveConfiguration, fieldByName);
        this.configureVerificationRatioField(configuration, effectiveConfiguration, fieldByName);
        this.configureValidationRatioField(configuration, effectiveConfiguration, fieldByName);
        this.configureStatusField(configuration, effectiveConfiguration, fieldByName);
        return effectiveConfiguration;
    }

    private void configureStatusField(Configuration configuration, JiraReportingEffectiveConfiguration effectiveConfiguration, Map<String, Field> fieldByName) {
        String statusField = configuration.getStatusField();
        if (fieldByName.containsKey(statusField)) {
            String id = fieldByName.get(statusField).getId();
            effectiveConfiguration.setJiraStatusFieldId(id);
            LOGGER.debug("[JIRA-SYNC] Found reporting field for Testing Status : {}", (Object)id);
        } else {
            LOGGER.debug("[JIRA-SYNC] Not found reporting field for Testing Status. No reporting will be done to JIRA for Testing Status. Conf was : {}", (Object)statusField);
        }
    }

    private void configureValidationProgressField(Configuration configuration, JiraReportingEffectiveConfiguration effectiveConfiguration, Map<String, Field> fieldByName) {
        String validationProgressField = configuration.getValidationProgressField();
        if (fieldByName.containsKey(validationProgressField)) {
            String id = fieldByName.get(validationProgressField).getId();
            effectiveConfiguration.setJiraValidationProgressFieldId(id);
            LOGGER.debug("[JIRA-SYNC] Found reporting field for Validation Progress rate : {}", (Object)id);
        } else {
            LOGGER.debug("[JIRA-SYNC] Not found reporting field for Validation Progress rate. No reporting will be done to JIRA for Validation Progress.  Conf was : {}", (Object)validationProgressField);
        }
    }

    private void configureValidationRatioField(Configuration configuration, JiraReportingEffectiveConfiguration effectiveConfiguration, Map<String, Field> fieldByName) {
        String validationRatioField = configuration.getValidationRatioField();
        if (fieldByName.containsKey(validationRatioField)) {
            String id = fieldByName.get(validationRatioField).getId();
            effectiveConfiguration.setJiraValidationRatioFieldId(id);
            LOGGER.debug("[JIRA-SYNC] Found reporting field for Validation Ratio rate : {}", (Object)id);
        } else {
            LOGGER.debug("[JIRA-SYNC] Not found reporting field for Validation Ratio rate. No reporting will be done to JIRA for Validation Ratio.  Conf was : {}", (Object)validationRatioField);
        }
    }

    private void configureVerificationProgressField(Configuration configuration, JiraReportingEffectiveConfiguration effectiveConfiguration, Map<String, Field> fieldByName) {
        String verificationProgressField = configuration.getVerificationProgressField();
        if (fieldByName.containsKey(verificationProgressField)) {
            String id = fieldByName.get(verificationProgressField).getId();
            effectiveConfiguration.setJiraVerificationProgressFieldId(id);
            LOGGER.debug("[JIRA-SYNC] Found reporting field for Verification Progress rate : {}", (Object)id);
        } else {
            LOGGER.debug("[JIRA-SYNC] Not found reporting field for Verification Progress rate. No reporting will be done to JIRA for Verification Progress. Conf was : {}", (Object)verificationProgressField);
        }
    }

    private void configureVerificationRatioField(Configuration configuration, JiraReportingEffectiveConfiguration effectiveConfiguration, Map<String, Field> fieldByName) {
        String verificationRatioField = configuration.getVerificationRatioField();
        if (fieldByName.containsKey(verificationRatioField)) {
            String id = fieldByName.get(verificationRatioField).getId();
            effectiveConfiguration.setJiraVerificationRatioFieldId(id);
            LOGGER.debug("[JIRA-SYNC] Found reporting field for Verification Ratio rate : {}", (Object)id);
        } else {
            LOGGER.debug("[JIRA-SYNC] Not found reporting field for Verification Ratio rate. No reporting will be done to JIRA for Verification Ratio. Conf was : {}", (Object)verificationRatioField);
        }
    }

    private void configureRedactionProgressField(Configuration configuration, JiraReportingEffectiveConfiguration effectiveConfiguration, Map<String, Field> fieldByName) {
        String redactionProgressField = configuration.getRedactionProgressField();
        if (fieldByName.containsKey(redactionProgressField)) {
            String id = fieldByName.get(redactionProgressField).getId();
            effectiveConfiguration.setJiraRedactionProgressFieldId(id);
            LOGGER.debug("[JIRA-SYNC] Found reporting field for Redaction Progress rate : {}", (Object)id);
        } else {
            LOGGER.debug("[JIRA-SYNC] Not found reporting field for Redaction Progress rate. No reporting will be done to JIRA for Redaction Progress. Conf was : {}", (Object)redactionProgressField);
        }
    }

    private void configureRedactionRatioField(Configuration configuration, JiraReportingEffectiveConfiguration effectiveConfiguration, Map<String, Field> fieldByName) {
        String redactionRatioField = configuration.getRedactionRatioField();
        if (fieldByName.containsKey(redactionRatioField)) {
            String id = fieldByName.get(redactionRatioField).getId();
            effectiveConfiguration.setJiraRedactionRatioFieldId(id);
            LOGGER.debug("[JIRA-SYNC] Found reporting field for Redaction Ratio rate : {}", (Object)id);
        } else {
            LOGGER.debug("[JIRA-SYNC] Not found reporting field for Redaction Ratio. No reporting will be done to JIRA for Redaction Ratio. Conf was : {}", (Object)redactionRatioField);
        }
    }

    public void performReportingToJira(List<JiraReport> jiraReports, JiraReportingEffectiveConfiguration configuration) {
        IssueRestClient issueClient = this.client.getIssueClient();
        for (JiraReport jiraReport : jiraReports) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[JIRA-SYNC] - Posting Report to JIRA for Issue : {}", (Object)jiraReport.getKey());
            }
            ArrayList<FieldInput> inputs = new ArrayList<FieldInput>();
            if (configuration.hasValidStatusField() && jiraReport.shouldPostStatus()) {
                inputs.add(new FieldInput(configuration.getJiraStatusFieldId(), (Object)jiraReport.getStatusValue()));
            }
            if (configuration.hasValidRedactionField() && jiraReport.shouldPostRedactionRate()) {
                inputs.add(new FieldInput(configuration.getJiraRedactionProgressFieldId(), (Object)jiraReport.getRedactionRate()));
            }
            if (configuration.hasValidVerificationField() && jiraReport.shouldPostVerificationRate()) {
                inputs.add(new FieldInput(configuration.getJiraVerificationProgressFieldId(), (Object)jiraReport.getVerificationRate()));
            }
            if (configuration.hasValidValidationField() && jiraReport.shouldPostValidationRate()) {
                inputs.add(new FieldInput(configuration.getJiraValidationProgressFieldId(), (Object)jiraReport.getValidationRate()));
            }
            if (configuration.hasValidRedactionRatioField() && jiraReport.shouldPostRedactionRatio()) {
                inputs.add(new FieldInput(configuration.getJiraRedactionRatioFieldId(), (Object)jiraReport.getRedactionRatio()));
            }
            if (configuration.hasValidVerificationRatioField() && jiraReport.shouldPostVerificationRatio()) {
                inputs.add(new FieldInput(configuration.getJiraVerificationRatioFieldId(), (Object)jiraReport.getVerificationRatio()));
            }
            if (configuration.hasValidValidationRatioField() && jiraReport.shouldPostValidationRatio()) {
                inputs.add(new FieldInput(configuration.getJiraValidationRatioFieldId(), (Object)jiraReport.getValidationRatio()));
            }
            IssueInput issueInput = IssueInput.createWithFields(inputs.toArray(new FieldInput[inputs.size()]));
            try {
                issueClient.updateIssue(jiraReport.getKey(), issueInput).claim();
            }
            catch (RestClientException e) {
                LOGGER.debug("[JIRA-SYNC] - Error occurred when updating Jira Issue : {}", (Object)jiraReport.getKey(), (Object)e);
            }
        }
    }

    public Promise<SearchResult> getIssuesForFilter(Collection<String> values, Set<String> fields, int start, int maxres) {
        String jql = this.buildJql(values);
        Set<String> finalFields = this.prepareFinalFields(fields);
        return this.client.getSearchClient().searchJql(jql, maxres, start, finalFields);
    }

    public Promise<SearchResult> getIssuesForFilterCloud(Collection<String> values, Set<String> fields, String nextPageToken, int maxres) {
        String jql = this.buildJql(values);
        Set<String> finalFields = this.prepareFinalFields(fields);
        return this.client.getSearchClient().searchJqlCloud(jql, maxres, nextPageToken, finalFields);
    }

    private Set<String> prepareFinalFields(Set<String> fields) {
        HashSet<String> finalFields = new HashSet<String>(fields);
        finalFields.addAll(REQUIRED_SEARCHED_FIELDS);
        finalFields.add("issuefields");
        finalFields.add("parent");
        return finalFields;
    }

    private String buildJql(Collection<String> values) {
        return String.format("key IN (%s)", StringUtils.join(values, (String)","));
    }

    public List<Issue> getIssuesByKey(List<String> keys, int batchSize, String firstKnownRemoteSyncKey) {
        ArrayList<Issue> result = new ArrayList<Issue>();
        if (keys.size() > 0) {
            List partition = Lists.partition(keys, (int)batchSize);
            for (List oneBatchOfKeys : partition) {
                oneBatchOfKeys.add(firstKnownRemoteSyncKey);
                List<Object> issues = new ArrayList();
                try {
                    try {
                        issues = this.doSearch(firstKnownRemoteSyncKey, oneBatchOfKeys);
                    }
                    catch (RestClientException e) {
                        ArrayList keysInError = new ArrayList();
                        e.getErrorCollections().forEach(error -> error.getErrorMessages().forEach(message -> {
                            Optional<String> keyInError = oneBatchOfKeys.stream().filter(message::contains).findFirst();
                            keyInError.ifPresent(keysInError::add);
                        }));
                        ArrayList<String> filteredBatchOfKeys = new ArrayList<String>(CollectionUtils.removeAll((Collection)oneBatchOfKeys, keysInError));
                        issues = this.doSearch(firstKnownRemoteSyncKey, filteredBatchOfKeys);
                        oneBatchOfKeys.remove(firstKnownRemoteSyncKey);
                        result.addAll(issues);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    oneBatchOfKeys.remove(firstKnownRemoteSyncKey);
                    result.addAll(issues);
                    throw throwable;
                }
                oneBatchOfKeys.remove(firstKnownRemoteSyncKey);
                result.addAll(issues);
            }
        }
        return result;
    }

    private List<Issue> doSearch(String firstKnownRemoteSyncKey, List<String> oneBatchOfKeys) {
        String jql = String.format("key IN (%s)", StringUtils.join(oneBatchOfKeys, (String)","));
        SearchRestClient searcher = this.client.getSearchClient();
        HashSet<String> finalFields = new HashSet<String>(REQUIRED_SEARCHED_FIELDS);
        int maxRes = oneBatchOfKeys.size();
        SearchResult searchResult = this.isJiraCloudServer() ? searcher.searchJqlCloud(jql, maxRes, null, finalFields).claim() : searcher.searchJql(jql, maxRes, 0, finalFields).claim();
        ArrayList issuesWithHack = Lists.newArrayList(searchResult.getIssues());
        return issuesWithHack.stream().filter(issue -> !issue.getKey().equals(firstKnownRemoteSyncKey)).collect(Collectors.toList());
    }

    public Long getBoardId(String boardName) {
        ExtendedAsynchronousJiraRestClient extendedClient = this.getExtendedAsynchronousJiraRestClient();
        AsynchronousPluginRestClient boardRestClient = extendedClient.getBoardRestClient();
        return boardRestClient.getBoardId(boardName);
    }

    public Iterable<JiraReport> getInitialReport(List<String> keys, JiraReportingEffectiveConfiguration configuration) {
        ExtendedAsynchronousJiraRestClient extendedClient = (ExtendedAsynchronousJiraRestClient)this.client;
        AsynchronousPluginRestClient boardRestClient = extendedClient.getBoardRestClient();
        return boardRestClient.getInitialReport(keys, configuration, this.isJiraCloudServer());
    }

    private ExtendedAsynchronousJiraRestClient getExtendedAsynchronousJiraRestClient() {
        return (ExtendedAsynchronousJiraRestClient)this.client;
    }

    public String getFilterForBoard(String boardName) {
        ExtendedAsynchronousJiraRestClient extendedClient = this.getExtendedAsynchronousJiraRestClient();
        AsynchronousPluginRestClient boardRestClient = extendedClient.getBoardRestClient();
        return boardRestClient.getBoardJQL(boardName);
    }

    public JiraBoard getBoard(String boardName) {
        ExtendedAsynchronousJiraRestClient extendedClient = this.getExtendedAsynchronousJiraRestClient();
        AsynchronousPluginRestClient boardRestClient = extendedClient.getBoardRestClient();
        return boardRestClient.getBoard(boardName);
    }

    public List<JiraSprint> tryToGetSprints(Long boardId, JiraSprintState ... states) {
        try {
            return this.getSprints(boardId, states);
        }
        catch (RestClientException ex) {
            if (ex.getStatusCode().isPresent() && (Integer)ex.getStatusCode().get() == 400) {
                LOGGER.warn("Cannot fetch sprints for board " + String.valueOf(boardId));
                return new ArrayList<JiraSprint>();
            }
            throw ex;
        }
    }

    private List<JiraSprint> getSprints(Long boardId, JiraSprintState ... states) {
        ExtendedAsynchronousJiraRestClient extendedClient = this.getExtendedAsynchronousJiraRestClient();
        AsynchronousPluginRestClient boardRestClient = extendedClient.getBoardRestClient();
        return boardRestClient.getSprints(boardId, states);
    }

    public String findSprintFieldIdentifier() {
        Iterable<Field> fields = this.client.getMetadataClient().getFields().claim();
        Optional<Field> sprintField = StreamSupport.stream(fields.spliterator(), false).filter(field -> field != null && field.getSchema() != null).filter(field -> {
            FieldSchema schema = field.getSchema();
            String custom = schema.getCustom();
            return StringUtils.isNotBlank((String)custom) && custom.equals(SPRINT_FIELD_IDENTIFIER);
        }).findFirst();
        if (sprintField.isPresent()) {
            return sprintField.get().getId();
        }
        throw new IllegalArgumentException("Unable to find Sprint field identifier in metadata. Was looking for field : com.pyxis.greenhopper.jira:gh-sprint");
    }

    public Set<String> findIssuesForBackLog(Long boardId) {
        ExtendedAsynchronousJiraRestClient extendedClient = this.getExtendedAsynchronousJiraRestClient();
        AsynchronousPluginRestClient boardRestClient = extendedClient.getBoardRestClient();
        return boardRestClient.getBacklogIssueKeys(boardId);
    }

    public Set<String> findIssuesForSprint(Long sprintId) {
        ExtendedAsynchronousJiraRestClient extendedClient = this.getExtendedAsynchronousJiraRestClient();
        AsynchronousPluginRestClient boardRestClient = extendedClient.getBoardRestClient();
        return boardRestClient.getSprintIssueKeys(sprintId);
    }

    public Set<JiraAgileIssue> findIssuesForSprints(Long boardId, Collection<String> keys) {
        if (keys.isEmpty()) {
            return new HashSet<JiraAgileIssue>();
        }
        ExtendedAsynchronousJiraRestClient extendedClient = this.getExtendedAsynchronousJiraRestClient();
        AsynchronousPluginRestClient boardRestClient = extendedClient.getBoardRestClient();
        return boardRestClient.getAgileIssues(boardId, keys);
    }

    public Promise<SearchResult> getIssueForModificationChecking(String jql, int start, int maxres) {
        SearchRestClient searcher = this.client.getSearchClient();
        return searcher.searchJql(jql, maxres, start, REQUIRED_SEARCHED_FIELDS);
    }

    public Promise<SearchResult> getIssueForModificationCheckingCloud(String jql, String nextPageToken, int maxres) {
        SearchRestClient searcher = this.client.getSearchClient();
        return searcher.searchJqlCloud(jql, maxres, nextPageToken, REQUIRED_SEARCHED_FIELDS);
    }

    public Map<String, String> getIssuesDescription(List<String> keys, int fetchBatchSize, boolean isJiraCloudServer) {
        if (keys.isEmpty()) {
            return new HashMap<String, String>();
        }
        ExtendedAsynchronousJiraRestClient extendedClient = (ExtendedAsynchronousJiraRestClient)this.client;
        AsynchronousPluginRestClient boardRestClient = extendedClient.getBoardRestClient();
        Iterable<JiraHtmlIssueDescription> issues = boardRestClient.getHtmlDescriptionIssues(keys, fetchBatchSize, isJiraCloudServer);
        return StreamSupport.stream(issues.spliterator(), false).collect(Collectors.toMap(issue -> issue.getKey(), issue -> issue.getDescription()));
    }

    public Issue getIssueByIssueKey(String issueKey) {
        return this.client.getIssueClient().getIssue(issueKey).claim();
    }

    public Iterable<IssueLink> getIssueLinksByIssueKey(String issueKey) {
        return this.client.getIssueClient().getIssue(issueKey).claim().getIssueLinks();
    }

    public List<String> getLinkedIssuesByEpicKey(String epicKey, String epicLinkName) {
        SearchResult result;
        String epicLinkJql = "\"" + epicLinkName + "\" = ";
        if (Objects.isNull(epicLinkName) || epicLinkName.isEmpty()) {
            result = this.isJiraCloudServer() ? this.client.getSearchClient().searchJqlCloud(PARENT_JQL + epicKey).claim() : this.client.getSearchClient().searchJql(PARENT_JQL + epicKey).claim();
        } else {
            SearchResult searchResult = result = this.isJiraCloudServer() ? this.client.getSearchClient().searchJqlCloud(epicLinkJql + epicKey + " OR \"parent\" = " + epicKey).claim() : this.client.getSearchClient().searchJql(epicLinkJql + epicKey + " OR \"parent\" = " + epicKey).claim();
        }
        if (result != null) {
            return StreamSupport.stream(result.getIssues().spliterator(), false).filter(issue -> !issue.getIssueType().isSubtask()).map(BasicIssue::getKey).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public Promise<JiraPagedResource<Version>> findPagedVersionsForProject(String projectKey, int pageNum, boolean orderByReleaseDateDesc) {
        ExtendedAsynchronousJiraRestClient extendedClient = this.getExtendedAsynchronousJiraRestClient();
        Map<String, String> options = this.defaultPaginationOptions();
        options.put(START_AT, String.valueOf(pageNum * 100));
        if (orderByReleaseDateDesc) {
            options.put(ORDER_BY, "-releaseDate");
        }
        return extendedClient.getAndParseJiraBiz("/project/" + projectKey + "/version", options, new JiraPaginatedResourceParser<Version>(new VersionJsonParser()));
    }

    public Promise<JiraSearchResult<ExecplanIssue>> findExecplanIssueForJql(String jql, int pageNum) {
        ExtendedAsynchronousJiraRestClient extendedClient = this.getExtendedAsynchronousJiraRestClient();
        Map<String, String> options = this.execplanPaginationOptions(pageNum);
        options.put(JQL, jql);
        ExecplanIssue.Parser issueParser = new ExecplanIssue.Parser();
        JiraSearchResultParser<ExecplanIssue> resultParser = new JiraSearchResultParser<ExecplanIssue>(issueParser);
        return extendedClient.getAndParseJiraBiz("/search", options, resultParser);
    }

    public Promise<JiraSearchResult<ExecplanIssue>> findExecplanIssueForJqlCloud(String jql, @Nullable String nextPageToken) {
        ExtendedAsynchronousJiraRestClient extendedClient = this.getExtendedAsynchronousJiraRestClient();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(JQL, jql);
        options.put(MAX_RESULTS, String.valueOf(100));
        options.put(FIELDS, "self,key,status,assignee,summary,issuetype");
        if (nextPageToken != null) {
            options.put(NEXT_PAGE_TOKEN, nextPageToken);
        }
        ExecplanIssue.Parser issueParser = new ExecplanIssue.Parser();
        JiraSearchResultParser<ExecplanIssue> resultParser = new JiraSearchResultParser<ExecplanIssue>(issueParser);
        return extendedClient.getAndParseJiraBiz("/search/jql", options, resultParser);
    }

    public Promise<JiraSearchResult<ExecplanIssue>> findExecplanIssuesForVersions(List<Long> versionIds, int pageNum) {
        String jql = versionIds.stream().map(id -> "fixVersion=" + String.valueOf(id)).collect(Collectors.joining(" or "));
        return this.findExecplanIssueForJql(jql, pageNum);
    }

    public Promise<JiraSearchResult<ExecplanIssue>> findExecplanIssuesForSprint(Long sprintId, int pageNum) {
        ExtendedAsynchronousJiraRestClient extendedClient = this.getExtendedAsynchronousJiraRestClient();
        Map<String, String> options = this.execplanPaginationOptions(pageNum);
        ExecplanIssue.Parser issueParser = new ExecplanIssue.Parser();
        JiraSearchResultParser<ExecplanIssue> resultParser = new JiraSearchResultParser<ExecplanIssue>(issueParser);
        return extendedClient.getAndParseJiraSoftware("/sprint/" + String.valueOf(sprintId) + "/issue", options, resultParser);
    }

    private ValueMappings getValueMappings(Configuration conf) {
        Yaml yaml = new Yaml();
        Map parsed = new HashMap();
        try {
            parsed = (Map)yaml.load(conf.getYamlFieldvalueMapping());
        }
        catch (ClassCastException ex) {
            LOGGER.error("YAML configuration error. Could not cast into Map", (Throwable)ex);
        }
        if (parsed == null) {
            parsed = new HashMap();
        }
        return new ValueMappings(parsed);
    }

    private Map<String, SynchronisationEffectiveConfiguration.EffectiveMapping> createEffectiveFieldMap(Configuration conf) {
        LOGGER.trace("fetching all fields available on jira");
        HashMap<String, SynchronisationEffectiveConfiguration.EffectiveMapping> mapping = new HashMap<String, SynchronisationEffectiveConfiguration.EffectiveMapping>();
        ArrayList<FieldMapping> mappingsToProcess = new ArrayList<FieldMapping>(conf.getFieldMappings());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("will try to find a match for the following mappings : ");
            for (FieldMapping todo : mappingsToProcess) {
                LOGGER.trace("\t " + todo.toString());
            }
        }
        Iterable<Field> actualFields = this.client.getMetadataClient().getFields().claim();
        boolean foundEpic = false;
        for (Field f : actualFields) {
            FieldSchema schema;
            if (mappingsToProcess.isEmpty() && foundEpic && !LOGGER.isTraceEnabled()) break;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("attempting to find a match for field {id : '" + f.getId() + "', name : '" + f.getName() + "'}");
            }
            Iterator mIterator = mappingsToProcess.iterator();
            while (mIterator.hasNext()) {
                FieldMapping m = (FieldMapping)((Object)mIterator.next());
                String squashField = m.getSquashField();
                String jiraField = m.getJiraField();
                if (!this.fieldsMatch(jiraField, f)) continue;
                SynchronisationEffectiveConfiguration.EffectiveMapping effective = this.newEffectiveMapping(f, squashField);
                mapping.put(squashField, effective);
                mIterator.remove();
                if (!LOGGER.isTraceEnabled()) continue;
                LOGGER.trace("found a an effective mapping for squash field '" + squashField + "' : " + effective.toString());
            }
            if (foundEpic || (schema = f.getSchema()) == null || schema.getCustom() == null || !schema.getCustom().equals("com.pyxis.greenhopper.jira:gh-epic-link")) continue;
            mapping.put("(internal - Epic link)", new SynchronisationEffectiveConfiguration.EffectiveMapping("(internal - Epic link)", f.getId(), true));
            foundEpic = true;
        }
        for (FieldMapping m : mappingsToProcess) {
            mapping.put(m.getSquashField(), new SynchronisationEffectiveConfiguration.EffectiveMapping(m.getSquashField(), null, false));
        }
        LOGGER.trace("finished processing the jira fields");
        return mapping;
    }

    private SynchronisationEffectiveConfiguration.EffectiveMapping newEffectiveMapping(Field jiraField, String squashField) {
        String jiraId = jiraField.getId();
        boolean isCustom = this.isCustom(jiraField);
        SynchronisationEffectiveConfiguration.EffectiveMapping effective = new SynchronisationEffectiveConfiguration.EffectiveMapping(squashField, jiraId, isCustom);
        FieldSchema schema = jiraField.getSchema();
        if (schema != null) {
            effective.addCustomInfos(schema.getType(), schema.getItems());
        }
        return effective;
    }

    private boolean isCustom(Field jiraField) {
        return jiraField.getFieldType() == FieldType.CUSTOM;
    }

    private boolean fieldsMatch(String nameOrId, Field f) {
        return nameOrId.equals(f.getName()) || nameOrId.equals(f.getId());
    }

    private Map<String, String> defaultPaginationOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(MAX_RESULTS, String.valueOf(100));
        return options;
    }

    private Map<String, String> execplanPaginationOptions(int pageNum) {
        Map<String, String> options = this.defaultPaginationOptions();
        options.put(START_AT, String.valueOf(pageNum * 100));
        options.put(FIELDS, "self,key,status,assignee,summary,issuetype");
        return options;
    }

    private static AuthenticationHandler createAuthHandler(Credentials credentials) {
        return switch (credentials.getImplementedProtocol()) {
            case AuthenticationProtocol.BASIC_AUTH -> {
                BasicAuthenticationCredentials basicCreds = (BasicAuthenticationCredentials)credentials;
                yield new Latin1BasicAuthHandler(basicCreds.getUsername(), new String(basicCreds.getPassword()));
            }
            case AuthenticationProtocol.OAUTH_2 -> {
                OAuth2Credentials oauth2Creds = (OAuth2Credentials)credentials;
                yield new OAuth2Handler(oauth2Creds);
            }
            default -> throw new UnsupportedAuthenticationModeException(credentials.getImplementedProtocol().toString());
        };
    }

    private static final class Latin1BasicAuthHandler
    implements AuthenticationHandler {
        private String username;
        private String password;

        Latin1BasicAuthHandler(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public void configure(Request.Builder request) {
            byte[] encoded = this.encode(this.username, this.password);
            request.setHeader(JiraClient.HTTP_AUTHORIZATION, "Basic " + new String(encoded));
        }

        private byte[] encode(String username, String password) {
            String toEncode = username + ":" + password;
            return Base64.encodeBase64((byte[])EncodingUtils.getBytes(toEncode, StandardCharsets.ISO_8859_1.name()));
        }
    }

    private static final class OAuth2Handler
    implements AuthenticationHandler {
        private final OAuth2Credentials credentials;

        public OAuth2Handler(OAuth2Credentials credentials) {
            this.credentials = credentials;
        }

        @Override
        public void configure(Request.Builder builder) {
            String tokenType = org.apache.commons.lang3.StringUtils.capitalize((String)this.credentials.getTokenType());
            builder.setHeader(JiraClient.HTTP_AUTHORIZATION, String.format("%s %s", tokenType, this.credentials.getAccessToken()));
        }
    }
}

