/*
 * Decompiled with CFR 0.152.
 */
package jirasync.com.atlassian.jira.rest.client.internal.async;

import java.net.URI;
import jirasync.com.atlassian.httpclient.api.HttpClient;
import jirasync.com.atlassian.jira.rest.client.api.UserRestClient;
import jirasync.com.atlassian.jira.rest.client.api.domain.User;
import jirasync.com.atlassian.jira.rest.client.api.domain.input.UserInput;
import jirasync.com.atlassian.jira.rest.client.internal.async.AbstractAsynchronousRestClient;
import jirasync.com.atlassian.jira.rest.client.internal.json.UserJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.UsersJsonParser;
import jirasync.com.atlassian.jira.rest.client.internal.json.gen.UserInputJsonGenerator;
import jirasync.com.sun.ws.rs.core.UriBuilder;
import jirasync.io.atlassian.util.concurrent.Promise;
import jirasync.javax.annotation.Nullable;

public class AsynchronousUserRestClient
extends AbstractAsynchronousRestClient
implements UserRestClient {
    private static final String USER_URI_PREFIX = "user";
    private static final String SEARCH_URI_PREFIX = "search";
    private static final String USERNAME_ATTRIBUTE = "username";
    private static final String START_AT_ATTRIBUTE = "startAt";
    private static final String MAX_RESULTS_ATTRIBUTE = "maxResults";
    private static final String INCLUDE_ACTIVE_ATTRIBUTE = "includeActive";
    private static final String INCLUDE_INACTIVE_ATTRIBUTE = "includeInactive";
    private final UserJsonParser userJsonParser = new UserJsonParser();
    private final UsersJsonParser usersJsonParser = new UsersJsonParser();
    private final URI baseUri;

    public AsynchronousUserRestClient(URI baseUri, HttpClient client) {
        super(client);
        this.baseUri = baseUri;
    }

    @Override
    public Promise<User> getUser(String username) {
        URI userUri = UriBuilder.fromUri(this.baseUri).path(USER_URI_PREFIX).queryParam(USERNAME_ATTRIBUTE, username).queryParam("expand", "groups").build(new Object[0]);
        return this.getUser(userUri);
    }

    @Override
    public Promise<User> getUser(URI userUri) {
        return this.getAndParse(userUri, this.userJsonParser);
    }

    @Override
    public Promise<User> createUser(UserInput user) {
        UriBuilder uriBuilder = UriBuilder.fromUri(this.baseUri).path(USER_URI_PREFIX);
        return this.postAndParse(uriBuilder.build(new Object[0]), user, new UserInputJsonGenerator(), this.userJsonParser);
    }

    @Override
    public Promise<User> updateUser(URI userUri, UserInput user) {
        return this.putAndParse(userUri, user, new UserInputJsonGenerator(), this.userJsonParser);
    }

    @Override
    public Promise<Void> removeUser(URI userUri) {
        return this.delete(userUri);
    }

    @Override
    public Promise<Iterable<User>> findUsers(String username) {
        return this.findUsers(username, null, null, null, null);
    }

    @Override
    public Promise<Iterable<User>> findUsers(String username, @Nullable Integer startAt, @Nullable Integer maxResults, @Nullable Boolean includeActive, @Nullable Boolean includeInactive) {
        UriBuilder uriBuilder = UriBuilder.fromUri(this.baseUri).path(USER_URI_PREFIX).path(SEARCH_URI_PREFIX).queryParam(USERNAME_ATTRIBUTE, username);
        this.addOptionalQueryParam(uriBuilder, START_AT_ATTRIBUTE, startAt);
        this.addOptionalQueryParam(uriBuilder, MAX_RESULTS_ATTRIBUTE, maxResults);
        this.addOptionalQueryParam(uriBuilder, INCLUDE_ACTIVE_ATTRIBUTE, includeActive);
        this.addOptionalQueryParam(uriBuilder, INCLUDE_INACTIVE_ATTRIBUTE, includeInactive);
        URI usersUri = uriBuilder.build(new Object[0]);
        return this.getAndParse(usersUri, this.usersJsonParser);
    }

    private void addOptionalQueryParam(UriBuilder uriBuilder, String key, Object value) {
        if (value != null) {
            uriBuilder.queryParam(key, value);
        }
    }
}

