SELECT DISTINCT
rv.requirement_id AS REQUIREMENT_ID,
rs.name REQUIREMENT_NAME,
rv.reference AS REQUIREMENT_REF,
rv.version_number AS REQUIREMENT_VERSION_NUMBER,
rv.criticality AS CRITICALITY,
COALESCE(success.counts,0) AS NB_EXECUTIONS_SUCCESS,
COALESCE(failure.counts,0) AS NB_EXECUTIONS_FAILURE,
COALESCE(untestable.counts,0) AS NB_EXECUTIONS_UNTESTABLE,
COALESCE(blocked.counts,0) AS NB_EXECUTIONS_BLOCKED,
COALESCE(running.counts,0) AS NB_EXECUTIONS_RUNNING,
COALESCE(ready.counts,0) AS NB_EXECUTIONS_READY,
COALESCE(settled.counts,0) AS NB_EXECUTIONS_SETTLED
FROM REQUIREMENT_VERSION AS rv
JOIN RESOURCE AS rs ON rv.res_id = rs.res_id
JOIN REQUIREMENT_VERSION_COVERAGE AS rvc ON rvc.verified_req_version_id = rs.res_id
JOIN TEST_CASE AS tc ON tc.tcln_id =  rvc.verifying_test_case_id
JOIN TEST_PLAN_ITEM tpi ON tpi.tcln_id = tc.tcln_id
JOIN ITERATION i ON i.test_plan_id = tpi.test_plan_id
JOIN CAMPAIGN_ITERATION AS citer ON citer.iteration_id = i.iteration_id
LEFT OUTER JOIN (SELECT DISTINCT
		Count(*) AS COUNTS,
		rvc.verified_req_version_id AS id
		FROM REQUIREMENT_VERSION_COVERAGE AS rvc
		JOIN TEST_CASE AS tc ON tc.tcln_id =  rvc.verifying_test_case_id
		JOIN TEST_PLAN_ITEM tpi ON tpi.tcln_id = tc.tcln_id
		JOIN ITERATION i ON i.test_plan_id = tpi.test_plan_id
		JOIN CAMPAIGN_ITERATION AS citer ON citer.iteration_id = i.iteration_id
		WHERE (tpi.execution_status='SUCCESS' OR tpi.execution_status='WARNING')
		AND citer.campaign_id = :id
		GROUP BY rvc.verified_req_version_id) AS success
		ON success.id = rs.res_id
LEFT OUTER JOIN (SELECT DISTINCT
		Count(*) AS COUNTS,
		rvc.verified_req_version_id AS id
		FROM REQUIREMENT_VERSION_COVERAGE AS rvc
		JOIN TEST_CASE AS tc ON tc.tcln_id =  rvc.verifying_test_case_id
		JOIN TEST_PLAN_ITEM tpi ON tpi.tcln_id = tc.tcln_id
        JOIN ITERATION i ON i.test_plan_id = tpi.test_plan_id
		JOIN CAMPAIGN_ITERATION AS citer ON citer.iteration_id = i.iteration_id
		WHERE tpi.execution_status='FAILURE'
		AND citer.campaign_id = :id
		GROUP BY rvc.verified_req_version_id) AS failure
		ON failure.id = rs.res_id
LEFT OUTER JOIN (SELECT DISTINCT
		Count(*) AS COUNTS,
		rvc.verified_req_version_id AS id
		FROM REQUIREMENT_VERSION_COVERAGE AS rvc
		JOIN TEST_CASE AS tc ON tc.tcln_id =  rvc.verifying_test_case_id
		JOIN TEST_PLAN_ITEM tpi ON tpi.tcln_id = tc.tcln_id
        JOIN ITERATION i ON i.test_plan_id = tpi.test_plan_id
        JOIN CAMPAIGN_ITERATION AS citer ON citer.iteration_id = i.iteration_id
		WHERE tpi.execution_status='UNTESTABLE'
		AND citer.campaign_id = :id
		GROUP BY rvc.verified_req_version_id) AS untestable
		ON untestable.id = rs.res_id
LEFT OUTER JOIN (SELECT DISTINCT
		Count(*) AS COUNTS,
		rvc.verified_req_version_id AS id
		FROM REQUIREMENT_VERSION_COVERAGE AS rvc
		JOIN TEST_CASE AS tc ON tc.tcln_id =  rvc.verifying_test_case_id
		JOIN TEST_PLAN_ITEM tpi ON tpi.tcln_id = tc.tcln_id
        JOIN ITERATION i ON i.test_plan_id = tpi.test_plan_id
        JOIN CAMPAIGN_ITERATION AS citer ON citer.iteration_id = i.iteration_id
		WHERE tpi.execution_status='SETTLED'
		AND citer.campaign_id = :id
		GROUP BY rvc.verified_req_version_id) AS settled
		ON settled.id = rs.res_id
LEFT OUTER JOIN (SELECT DISTINCT
		Count(*) AS COUNTS,
		rvc.verified_req_version_id AS id
		FROM REQUIREMENT_VERSION_COVERAGE AS rvc
		JOIN TEST_CASE AS tc ON tc.tcln_id =  rvc.verifying_test_case_id
		JOIN TEST_PLAN_ITEM tpi ON tpi.tcln_id = tc.tcln_id
        JOIN ITERATION i ON i.test_plan_id = tpi.test_plan_id
        JOIN CAMPAIGN_ITERATION AS citer ON citer.iteration_id = i.iteration_id
		WHERE (tpi.execution_status='BLOCKED' OR tpi.execution_status='ERROR')
		AND citer.campaign_id = :id
		GROUP BY rvc.verified_req_version_id) AS blocked
		ON blocked.id = rs.res_id
LEFT OUTER JOIN (SELECT DISTINCT
		Count(*) AS COUNTS,
		rvc.verified_req_version_id AS id
		FROM REQUIREMENT_VERSION_COVERAGE AS rvc
		JOIN TEST_CASE AS tc ON tc.tcln_id =  rvc.verifying_test_case_id
		JOIN TEST_PLAN_ITEM tpi ON tpi.tcln_id = tc.tcln_id
        JOIN ITERATION i ON i.test_plan_id = tpi.test_plan_id
        JOIN CAMPAIGN_ITERATION AS citer ON citer.iteration_id = i.iteration_id
		WHERE tpi.execution_status='RUNNING'
		AND citer.campaign_id = :id
		GROUP BY rvc.verified_req_version_id) AS running
		ON running.id = rs.res_id
LEFT OUTER JOIN (SELECT DISTINCT
		Count(*) AS COUNTS,
		rvc.verified_req_version_id AS id
		FROM REQUIREMENT_VERSION_COVERAGE AS rvc
		JOIN TEST_CASE AS tc ON tc.tcln_id =  rvc.verifying_test_case_id
		JOIN TEST_PLAN_ITEM tpi ON tpi.tcln_id = tc.tcln_id
        JOIN ITERATION i ON i.test_plan_id = tpi.test_plan_id
        JOIN CAMPAIGN_ITERATION AS citer ON citer.iteration_id = i.iteration_id
		WHERE tpi.execution_status='READY'
		AND citer.campaign_id = :id
		GROUP BY rvc.verified_req_version_id) AS ready
		ON ready.id = rs.res_id
WHERE citer.campaign_id = :id
ORDER BY rs.name ASC
