/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.stereotype.Repository;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.domain.synchronisation.RemoteSynchronisation;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.FieldMapping;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.UserConfiguration;
import org.squashtest.tm.service.internal.repository.RemoteSynchronisationDao;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.web.backend.helper.JsonHelper;

@Repository(value="squash.tm.plugin.xsquash4gitlab.dao")
public class PluginRequirementDao {
    private final DSLContext dslContext;
    private final GenericProjectManagerService projectManager;
    private final RemoteSynchronisationDao remoteSynchronisationDao;

    public PluginRequirementDao(DSLContext dsl, GenericProjectManagerService projectManager, RemoteSynchronisationDao remoteSynchronisationDao) {
        this.dslContext = dsl;
        this.projectManager = projectManager;
        this.remoteSynchronisationDao = remoteSynchronisationDao;
    }

    public List<ParentSynchronisation> findParentSynchronisations(int remoteIssueId) {
        return this.dslContext.select((SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID, (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_PERIMETER_STATUS).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).join((TableLike)Tables.REMOTE_SYNCHRONISATION).on(Tables.REMOTE_SYNCHRONISATION.REMOTE_SYNCHRONISATION_ID.eq((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID)).where(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID.eq((Object)String.valueOf(remoteIssueId))).and(Tables.REMOTE_SYNCHRONISATION.KIND.eq((Object)"squash.tm.plugin.xsquash4gitlab")).and(Tables.REMOTE_SYNCHRONISATION.SYNC_ENABLE.eq((Object)true)).fetchInto(ParentSynchronisation.class);
    }

    public void updateTrackedNoteId(Set<Long> requirementIds, String noteId) {
        this.dslContext.update((Table)Tables.REQUIREMENT_SYNC_EXTENDER).set((Field)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_TESTING_STATUS_COMMENT_ID, (Object)noteId).where(Tables.REQUIREMENT_SYNC_EXTENDER.REQUIREMENT_ID.in(requirementIds.stream().map(String::valueOf).toList())).execute();
    }

    public void storeConfigurationForProject(Long projectId, UserConfiguration userConfiguration) {
        HashMap<String, String> storageConf = new HashMap<String, String>(5);
        List<FieldMapping> fieldMappings = userConfiguration.getFieldMappings();
        String strMappings = JsonHelper.serialize(fieldMappings);
        storageConf.put("attributeMappings", strMappings);
        String valueMapping = userConfiguration.getYamlFieldValueMapping();
        storageConf.put("valuesMapping", valueMapping);
        storageConf.put("testReportingEnabled", Boolean.toString(userConfiguration.isTestReportingEnabled()));
        this.projectManager.setPluginConfiguration(projectId.longValue(), WorkspaceType.REQUIREMENT_WORKSPACE, "squash.tm.plugin.xsquash4gitlab", storageConf);
    }

    public List<Long> findActiveGitLabRemoteSyncIds() {
        return this.remoteSynchronisationDao.findActiveRemoteSyncIdsByPluginId("squash.tm.plugin.xsquash4gitlab");
    }

    public Map<Long, RemoteSynchronisation> findRemoteSynchronisations(List<Long> ids) {
        List remoteSynchronisations = this.remoteSynchronisationDao.findAllById(ids);
        return remoteSynchronisations.stream().collect(Collectors.toMap(RemoteSynchronisation::getId, Function.identity()));
    }

    public List<SynchronizedRequirementInfo> findSynchronizedRequirementInfosBySynchronisationId(Long synchronisationId) {
        return this.dslContext.select((SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID, (SelectField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_TESTING_STATUS_COMMENT_ID).from((TableLike)Tables.REQUIREMENT_SYNC_EXTENDER).where(Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_SYNCHRONISATION_ID.eq((Object)synchronisationId)).orderBy((OrderField)Tables.REQUIREMENT_SYNC_EXTENDER.REMOTE_REQ_ID).fetchInto(SynchronizedRequirementInfo.class);
    }

    public static final class ParentSynchronisation {
        public final Long remoteSynchronisationId;
        public final String remoteReqPerimeterStatus;

        public ParentSynchronisation(Long remoteSynchronisationId, String remoteReqPerimeterStatus) {
            this.remoteSynchronisationId = remoteSynchronisationId;
            this.remoteReqPerimeterStatus = remoteReqPerimeterStatus;
        }
    }

    public record SynchronizedRequirementInfo(String remoteReqId, String remoteTestingStatusCommentId) {
    }
}

