/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.domain;

import org.squashtest.tm.plugin.xsquash4gitlab.domain.GitLabIssue;

public final class GitLabEntityHelper {
    public static final String ISSUE_GID_PREFIX = "gid://gitlab/Issue/";
    public static final String PROJECT_GID_PREFIX = "gid://gitlab/Project/";

    private GitLabEntityHelper() {
        throw new IllegalStateException("This class is not meant to be instantiated");
    }

    public static String getKey(GitLabIssue gitLabIssue) {
        return gitLabIssue.getId();
    }

    public static String extractIssueIdFromGID(String globalId) {
        if (globalId == null || !globalId.startsWith(ISSUE_GID_PREFIX)) {
            throw new IllegalArgumentException(String.format("Malformed issue GID received : %s", globalId));
        }
        return globalId.replace(ISSUE_GID_PREFIX, "");
    }

    public static Integer extractProjectIdFromGID(String globalId) {
        if (globalId == null || !globalId.startsWith(PROJECT_GID_PREFIX)) {
            throw new IllegalArgumentException(String.format("Malformed project GID received : %s", globalId));
        }
        return Integer.parseInt(globalId.replace(PROJECT_GID_PREFIX, ""));
    }
}

