/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.xsquash4gitlab.controller.execPlan;

import jakarta.inject.Inject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.execPlan.GitLabServer;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.execPlan.IssueRequestModel;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.execPlan.IterationFormMetadata;
import org.squashtest.tm.plugin.xsquash4gitlab.controller.execPlan.WizardPageDto;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.ExecPlanSpecification;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.execplan.ExecplanGitLabIssue;
import org.squashtest.tm.plugin.xsquash4gitlab.domain.execplan.ExecplanTestCase;
import org.squashtest.tm.plugin.xsquash4gitlab.exception.PluginNotEnabledException;
import org.squashtest.tm.plugin.xsquash4gitlab.service.execplan.ExecPlanSynchronizationService;
import org.squashtest.tm.plugin.xsquash4gitlab.service.execplan.SelectedNode;

@Controller
@RequestMapping(value={"backend/plugin/xsquash4gitlab"})
public class ExecPlanSynchronizationController {
    @Inject
    private ExecPlanSynchronizationService execplanSynchronizationService;

    @GetMapping(value={"/exec-plan-designer"})
    @ResponseBody
    public WizardPageDto getDesigner(@RequestParam(value="campaign", required=false) Long campaignId, @RequestParam(value="iteration", required=false) Long iterationId) {
        WizardPageDto wizardPageDto = new WizardPageDto();
        SelectedNode selectedNode = this.coerceSelectedNode(campaignId, iterationId);
        wizardPageDto.setSelectedNode(selectedNode);
        this.appendExistingGitLabServers(wizardPageDto);
        this.appendExistingGitLabPerimeters(wizardPageDto, selectedNode.getProjectId());
        return wizardPageDto;
    }

    private void appendExistingGitLabServers(WizardPageDto wizardPageDto) {
        List<GitLabServer> availableGitLabServers = this.execplanSynchronizationService.findAllSyncedGitLabServers().stream().map(GitLabServer::new).collect(Collectors.toList());
        wizardPageDto.setServers(availableGitLabServers);
    }

    private void appendExistingGitLabPerimeters(WizardPageDto wizardPageDto, Long projectId) {
        Set<String> perimeters = this.execplanSynchronizationService.getExistingPerimetersByProjectId(projectId);
        wizardPageDto.setExistingGitLabPerimeters(perimeters);
    }

    private SelectedNode coerceSelectedNode(Long campaignId, Long iterationId) {
        EntityReference reference;
        if (campaignId != null) {
            reference = new EntityReference(EntityType.CAMPAIGN, campaignId);
        } else if (iterationId != null) {
            reference = new EntityReference(EntityType.ITERATION, iterationId);
        } else {
            throw new IllegalArgumentException("no target campaign or iteration provided");
        }
        SelectedNode selectedNode = this.execplanSynchronizationService.createSelectedNode(reference);
        selectedNode.setType(selectedNode.getType().toUpperCase());
        this.checkPluginActivationOnProject(selectedNode.getProjectId());
        return selectedNode;
    }

    void checkPluginActivationOnProject(long projectId) {
        if (!this.execplanSynchronizationService.isWizardEnabledOnProject(projectId)) {
            throw new PluginNotEnabledException(projectId);
        }
    }

    @PostMapping(value={"/exec-plan/test-cases/search-by-issues"})
    @ResponseBody
    public List<ExecplanTestCase> findTestCasesForIssues(@RequestBody List<ExecplanGitLabIssue> issues) {
        return this.execplanSynchronizationService.findCandidateTestCasesForIssues(issues);
    }

    @GetMapping(value={"/campaigns/{id}/iterations/meta"})
    @ResponseBody
    public IterationFormMetadata getIterationMetadataForCampaign(@PathVariable(value="id") long campaignId) {
        return this.execplanSynchronizationService.findIterationMetadataForCampaign(campaignId);
    }

    @PostMapping(value={"exec-plan-designer/issues/search"})
    @ResponseBody
    public List<ExecplanGitLabIssue> getIssues(@RequestBody IssueRequestModel request) {
        return this.execplanSynchronizationService.getGitLabIssuesInPerimeter(request);
    }

    @PostMapping(value={"/campaigns/{id}/test-plan"})
    @ResponseBody
    public EntityReference updateCampaignExecutionPlan(@RequestBody ExecPlanSpecification specification) {
        this.execplanSynchronizationService.updateCampaignTestPlan(specification);
        return specification.getTarget();
    }

    @PostMapping(value={"/iterations/{id}/test-plan"})
    @ResponseBody
    public EntityReference updateIterationExecutionPlan(@RequestBody ExecPlanSpecification specification) {
        this.execplanSynchronizationService.updateIterationTestPlan(specification);
        return specification.getTarget();
    }

    @PostMapping(value={"/campaigns/{id}/iterations/new"})
    @ResponseBody
    public EntityReference createNewIteration(@RequestBody ExecPlanSpecification specification) {
        Iteration iter = this.execplanSynchronizationService.createIteration(specification);
        return this.toEntityReference(iter);
    }

    private EntityReference toEntityReference(Iteration iter) {
        return new EntityReference(EntityType.ITERATION, iter.getId());
    }
}

