/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.service.impl;

import jakarta.inject.Inject;
import java.util.List;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindException;
import org.squashtest.tm.api.plugin.ConfigurablePlugin;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.jooq.domain.Tables;
import org.squashtest.tm.plugin.rest.admin.jackson.model.ProjectAutomationConfigurationDto;
import org.squashtest.tm.plugin.rest.admin.service.RestProjectAdminService;
import org.squashtest.tm.plugin.rest.admin.service.patcher.ProjectAutomationConfigurationPatcher;
import org.squashtest.tm.plugin.rest.admin.validators.ProjectAutomationConfigurationValidator;
import org.squashtest.tm.service.plugin.ConfigurablePluginManager;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.service.project.ProjectManagerService;

@Service
@Transactional
public class RestProjectAdminServiceImpl
implements RestProjectAdminService {
    @Inject
    private GenericProjectManagerService genericProjectManager;
    @Inject
    private ProjectManagerService projectManager;
    @Inject
    private ProjectAutomationConfigurationPatcher projectAutomationConfigurationPatcher;
    @Inject
    private ProjectAutomationConfigurationValidator projectAutomationConfigurationValidator;
    @Inject
    private ConfigurablePluginManager configurablePluginManager;
    @Inject
    private DSLContext dsl;

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void deleteProjectByIds(List<Long> projectIds) {
        for (Long projectId : projectIds) {
            this.projectManager.deleteProject(projectId.longValue());
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void changeBugTracker(Long projectId, Long bugtrackerId) {
        this.genericProjectManager.changeBugTracker(projectId.longValue(), bugtrackerId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void unbindBugTracker(long projectId) {
        this.genericProjectManager.removeBugTracker(projectId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void bindScmRepository(long projectId, long scmRepositoryId) {
        this.genericProjectManager.bindScmRepository(projectId, scmRepositoryId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void unbindScmRepository(long projectId) {
        this.genericProjectManager.unbindScmRepository(projectId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public ProjectAutomationConfigurationDto getProjectAutomationSettings(long projectId) {
        GenericProject project = this.genericProjectManager.findById(projectId);
        return new ProjectAutomationConfigurationDto(project.getBddImplementationTechnology(), project.getBddScriptLanguage(), project.getAutomationWorkflowType());
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public ProjectAutomationConfigurationDto patchProjectAutomationConfiguration(ProjectAutomationConfigurationDto automConfDtoPatch, long projectId) throws BindException {
        GenericProject project = this.genericProjectManager.findById(projectId);
        this.projectAutomationConfigurationValidator.validatePatchAutomationConfiguration(automConfDtoPatch, project);
        this.projectAutomationConfigurationPatcher.patch(project, automConfDtoPatch);
        if (automConfDtoPatch.getAutomationWorkflowType() != null) {
            this.genericProjectManager.changeAutomationWorkflow(projectId, automConfDtoPatch.getAutomationWorkflowType().name());
        }
        return new ProjectAutomationConfigurationDto(project.getBddImplementationTechnology(), project.getBddScriptLanguage(), project.getAutomationWorkflowType());
    }

    @Override
    public void activateProjectPluginById(long projectId, String pluginId) {
        ConfigurablePlugin plugin = (ConfigurablePlugin)this.configurablePluginManager.findById(pluginId).orElseThrow(() -> new IllegalArgumentException(String.format("Could not find a plugin with ID %s", pluginId)));
        this.genericProjectManager.enablePlugin(projectId, plugin);
    }

    @Override
    public void deactivateProjectPluginById(long projectId, String pluginId, Boolean saveConfig) {
        this.configurablePluginManager.disableConfigurablePlugin(pluginId, projectId, saveConfig);
    }

    @Override
    public Long getAiServerId(Long projectId) {
        return (Long)this.dsl.select((SelectField)Tables.PROJECT.AI_SERVER_ID).from((TableLike)Tables.PROJECT).where(Tables.PROJECT.PROJECT_ID.eq((Object)projectId)).fetchOne((Field)Tables.PROJECT.AI_SERVER_ID);
    }
}

