/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.rest.admin.service.impl;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.customfield.BindableEntity;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldBinding;
import org.squashtest.tm.domain.customfield.CustomFieldOption;
import org.squashtest.tm.domain.customfield.MultiSelectField;
import org.squashtest.tm.domain.customfield.NumericField;
import org.squashtest.tm.domain.customfield.RenderingLocation;
import org.squashtest.tm.domain.customfield.RichTextField;
import org.squashtest.tm.domain.customfield.SingleSelectField;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.exception.customfield.CodeAlreadyExistsException;
import org.squashtest.tm.exception.project.LockedParameterException;
import org.squashtest.tm.plugin.rest.admin.jackson.model.CustomFieldDto;
import org.squashtest.tm.plugin.rest.admin.service.RestCustomFieldService;
import org.squashtest.tm.service.customfield.CustomFieldManagerService;
import org.squashtest.tm.service.internal.customfield.PrivateCustomFieldValueService;
import org.squashtest.tm.service.internal.repository.CustomFieldBindingDao;
import org.squashtest.tm.service.internal.repository.CustomFieldDao;
import org.squashtest.tm.service.internal.repository.GenericProjectDao;
import org.squashtest.tm.service.internal.repository.ProjectDao;

@Service
@Transactional
public class RestCustomFieldServiceImpl
implements RestCustomFieldService {
    @Inject
    private CustomFieldDao cufDao;
    @Inject
    private CustomFieldBindingDao customFieldBindingDao;
    @Inject
    private PrivateCustomFieldValueService customValueService;
    @Inject
    private GenericProjectDao genericProjectDao;
    @Inject
    private ProjectDao projectDao;
    @Inject
    private CustomFieldManagerService cufManagerService;

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public CustomField addCustomField(CustomField cuf) {
        this.checkDuplicateName(cuf);
        this.checkDuplicateCode(cuf);
        this.cufDao.save((Object)cuf);
        return cuf;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public CustomField updateCustomField(Long cufId, CustomFieldDto cufDto) {
        CustomField cufToUpdate = new CustomField(cufDto.getInputType());
        switch (cufToUpdate.getInputType()) {
            case DROPDOWN_LIST: {
                this.updateSingleSelectField(cufId, cufDto);
                break;
            }
            case RICH_TEXT: {
                cufToUpdate = this.createRichTextField();
                break;
            }
            case TAG: {
                cufToUpdate = this.createTag();
                break;
            }
            case NUMERIC: {
                cufToUpdate = this.createNumeric();
            }
        }
        cufToUpdate = (CustomField)this.cufDao.getReferenceById((Object)cufId);
        cufToUpdate.setLabel(cufDto.getLabel());
        cufToUpdate.setCode(cufDto.getCode());
        cufToUpdate.setName(cufDto.getName());
        cufToUpdate.setDefaultValue(cufDto.getDefaultValue());
        cufToUpdate.setOptional(cufDto.isOptional());
        this.cufDao.saveAndFlush((Object)cufToUpdate);
        return cufToUpdate;
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public CustomField updateCustomFieldOption(Long cufId, String cufOptionLabel, CustomFieldOption cufOption) {
        this.cufManagerService.changeOptionLabel(cufId, cufOptionLabel, cufOption.getLabel());
        this.cufManagerService.changeOptionCode(cufId.longValue(), cufOptionLabel, cufOption.getCode());
        this.cufManagerService.changeOptionColour(cufId.longValue(), cufOptionLabel, cufOption.getColour());
        return this.cufManagerService.findById(cufId);
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void bindCustomFieldToProject(Long projectId, BindableEntity entity, Long customFieldId, Set<RenderingLocation> locations) {
        this.bindCustomFieldToProjectUnsecured(projectId, entity, customFieldId, locations);
    }

    private void bindCustomFieldToProjectUnsecured(Long projectId, BindableEntity entity, Long customFieldId, Set<RenderingLocation> locations) {
        if (this.genericProjectDao.isBoundToATemplate(projectId.longValue())) {
            throw new LockedParameterException();
        }
        GenericProject genericProject = (GenericProject)this.genericProjectDao.getReferenceById((Object)projectId);
        CustomFieldBinding newBinding = this.createBinding(genericProject, entity, customFieldId, locations);
        if (!this.genericProjectDao.isProjectTemplate(projectId.longValue())) {
            this.customValueService.cascadeCustomFieldValuesCreation(newBinding);
        }
        if (this.genericProjectDao.isProjectTemplate(projectId.longValue())) {
            this.propagateCufBindingCreationToBoundProjects(projectId, entity, customFieldId);
        }
    }

    @Override
    @PreAuthorize(value="hasPermission(#projectId, 'org.squashtest.tm.domain.project.Project', 'MANAGE_PROJECT')  or hasRole('ROLE_ADMIN')")
    public void unbindCustomFieldToProject(Long projectId, BindableEntity entity, Long customFieldId) {
        List<Long> bindingIds = this.findCustomFieldBindingIdsToDelete(projectId, entity, customFieldId);
        if (!bindingIds.isEmpty()) {
            if (this.genericProjectDao.oneIsBoundToABoundProject(bindingIds)) {
                throw new LockedParameterException();
            }
            ArrayList<Long> bindingIdsToRemove = new ArrayList<Long>(bindingIds);
            bindingIdsToRemove.addAll(this.customFieldBindingDao.findEquivalentBindingsForBoundProjects(bindingIds));
            this.customValueService.cascadeCustomFieldValuesDeletion(bindingIdsToRemove);
            this.customFieldBindingDao.removeCustomFieldBindings(bindingIdsToRemove);
        }
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public CustomField findById(Long cufId) {
        return (CustomField)this.cufDao.getReferenceById((Object)cufId);
    }

    @Override
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public Page<CustomField> findSortedCustomFields(Pageable pageable) {
        return this.cufManagerService.findSortedCustomFields(pageable);
    }

    private void updateSingleSelectField(Long cufId, CustomFieldDto cufDto) {
        SingleSelectField customField = this.cufDao.findSingleSelectFieldById(cufId);
        int i = 0;
        for (CustomFieldOption option : cufDto.getOptions()) {
            if (!((CustomFieldOption)customField.getOptions().get(i)).getLabel().equals(option.getLabel())) {
                customField.changeOptionLabel(((CustomFieldOption)customField.getOptions().get(i)).getLabel(), option.getLabel());
            }
            if (!((CustomFieldOption)customField.getOptions().get(i)).getCode().equals(option.getCode())) {
                customField.changeOptionCode(((CustomFieldOption)customField.getOptions().get(i)).getLabel(), option.getCode());
            }
            customField.changeOptionColour(((CustomFieldOption)customField.getOptions().get(i)).getLabel(), option.getColour());
            ++i;
        }
    }

    private CustomField createNumeric() {
        return new NumericField();
    }

    private CustomField createRichTextField() {
        return new RichTextField();
    }

    private CustomField createTag() {
        return new MultiSelectField();
    }

    private void checkDuplicateCode(CustomField newCustomField) {
        CustomField codeDuplicate = this.cufDao.findByCode(newCustomField.getCode());
        if (codeDuplicate != null) {
            throw new CodeAlreadyExistsException(null, newCustomField.getCode(), CustomField.class);
        }
    }

    private void checkDuplicateName(CustomField newCustomField) {
        CustomField nameDuplicate = this.cufDao.findByName(newCustomField.getName());
        if (nameDuplicate != null) {
            throw new NameAlreadyInUseException("CustomField", HtmlUtils.htmlEscape((String)newCustomField.getName()));
        }
    }

    private List<Long> findCustomFieldBindingIdsToDelete(Long projectId, BindableEntity entity, Long customFieldId) {
        ArrayList<Long> cufBindingIdsToDelete = new ArrayList<Long>();
        List cufBinding = this.customFieldBindingDao.findAllForProjectAndEntity(projectId.longValue(), entity);
        for (CustomFieldBinding customFieldBinding : cufBinding) {
            if (!customFieldBinding.getCustomField().getId().equals(customFieldId)) continue;
            cufBindingIdsToDelete.add(customFieldBinding.getId());
        }
        return cufBindingIdsToDelete;
    }

    private CustomFieldBinding createBinding(GenericProject genericProject, BindableEntity entity, long customFieldId, Set<RenderingLocation> locations) {
        CustomFieldBinding newBinding = new CustomFieldBinding();
        CustomField field = (CustomField)this.cufDao.getReferenceById((Object)customFieldId);
        Long newIndex = this.customFieldBindingDao.countAllForProjectAndEntity(genericProject.getId().longValue(), entity) + 1L;
        newBinding.setBoundProject(genericProject);
        newBinding.setBoundEntity(entity);
        newBinding.setCustomField(field);
        newBinding.setPosition(newIndex.intValue());
        if (locations != null) {
            newBinding.setRenderingLocations(locations);
        }
        this.customFieldBindingDao.save((Object)newBinding);
        return newBinding;
    }

    private void propagateCufBindingCreationToBoundProjects(long templateId, BindableEntity entity, long cufId) {
        Collection boundProjectsIds = this.projectDao.findAllIdsBoundToTemplate(templateId);
        for (Long boundProjectId : boundProjectsIds) {
            if (this.customFieldBindingDao.cufBindingAlreadyExists(boundProjectId.longValue(), entity, cufId)) continue;
            this.bindCustomFieldToProjectUnsecured(boundProjectId, entity, cufId, null);
        }
    }
}

