/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.report.qualitativecoverage.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.core.io.Resource;
import org.squashtest.tm.plugin.report.qualitativecoverage.bean.QuaCoverageRequirementBean;
import org.squashtest.tm.plugin.report.qualitativecoverage.bean.QuaCoverageTestSuiteBean;
import org.squashtest.tm.plugin.report.qualitativecoverage.query.AbstractItemProcess;
import org.squashtest.tm.plugin.report.qualitativecoverage.query.QueryContext;

public class QuaCoverageTestSuiteProcess
extends AbstractItemProcess {
    private List<QuaCoverageTestSuiteBean> testSuiteBeans;

    public List<QuaCoverageTestSuiteBean> getTestSuites(QueryContext ctx, Long iterationId) {
        this.testSuiteBeans = new ArrayList<QuaCoverageTestSuiteBean>();
        HashMap<String, Long> parameters = new HashMap<String, Long>();
        parameters.put("id", iterationId);
        List result = ctx.getRunner().executeSelect(this.loadQuery((Resource)ctx.get("testSuitesByIteration")), parameters);
        this.convertResultToTestSuiteBean(result, ctx);
        return this.testSuiteBeans;
    }

    private void convertResultToTestSuiteBean(List<Object[]> result, QueryContext ctx) {
        for (Object[] row : result) {
            QuaCoverageTestSuiteBean testSuiteBean = new QuaCoverageTestSuiteBean();
            testSuiteBean.setTestSuiteId(this.evaluateExpressionToLong(row[0]));
            testSuiteBean.setTestSuiteName(this.evaluateExpressionToString(row[1]));
            testSuiteBean.setRequirements(this.getRequirementBeans(ctx, testSuiteBean.getTestSuiteId()));
            this.testSuiteBeans.add(testSuiteBean);
        }
    }

    private List<QuaCoverageRequirementBean> getRequirementBeans(QueryContext ctx, Long testSuiteId) {
        ArrayList<QuaCoverageRequirementBean> requirementBeans = new ArrayList<QuaCoverageRequirementBean>();
        HashMap<String, Long> parameters = new HashMap<String, Long>();
        parameters.put("id", testSuiteId);
        List result = ctx.getRunner().executeSelect(this.loadQuery((Resource)ctx.get("requirementsByTestSuite")), parameters);
        for (Object[] row : result) {
            QuaCoverageRequirementBean requirementBean = new QuaCoverageRequirementBean();
            requirementBean.setRequirementId(this.evaluateExpressionToLong(row[0]));
            requirementBean.setRequirementName(this.evaluateExpressionToString(row[1]));
            requirementBean.setReference(this.evaluateExpressionToString(row[2]));
            requirementBean.setVersion(this.evaluateExpressionToString(row[3]));
            requirementBean.setCriticality(this.evaluateExpressionToString(row[4]));
            requirementBean.setSuccess(this.evaluateExpressionToLong(row[5]));
            requirementBean.setFailure(this.evaluateExpressionToLong(row[6]));
            requirementBean.setUntestable(this.evaluateExpressionToLong(row[7]));
            requirementBean.setBlocked(this.evaluateExpressionToLong(row[8]));
            requirementBean.setRunning(this.evaluateExpressionToLong(row[9]));
            requirementBean.setReady(this.evaluateExpressionToLong(row[10]));
            requirementBean.setSettled(this.evaluateExpressionToLong(row[11]));
            requirementBeans.add(requirementBean);
        }
        return requirementBeans;
    }
}

