/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.redmine3.redmineextendedmanager.converter;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component(value="redmine3FieldNameTranslator")
@Scope(value="singleton")
public final class FieldNameTranslator {
    @Inject
    @Named(value="redmine3ConnectorMessageSource")
    private MessageSource messageSource;
    private static final Map<String, String> TRANSLATE_MAP = new HashMap<String, String>();

    static {
        TRANSLATE_MAP.put("Tracker", "interface.tracker");
        TRANSLATE_MAP.put("attachment", "interface.attachment");
        TRANSLATE_MAP.put("subject", "interface.subject");
        TRANSLATE_MAP.put("priority", "interface.report.priority.label");
        TRANSLATE_MAP.put("priority_id", "interface.report.priority.label");
        TRANSLATE_MAP.put("description", "interface.report.description.label");
        TRANSLATE_MAP.put("assigned_to_id", "interface.report.assignee.label");
        TRANSLATE_MAP.put("category_id", "interface.report.category.label");
        TRANSLATE_MAP.put("fixed_version_id", "interface.fixed_version_id");
        TRANSLATE_MAP.put("parent_issue_id", "interface.parent_issue_id");
        TRANSLATE_MAP.put("start_date", "interface.start_date");
        TRANSLATE_MAP.put("due_date", "interface.due_date");
        TRANSLATE_MAP.put("estimated_hours", "interface.estimated_hours");
        TRANSLATE_MAP.put("done_ratio", "interface.done_ratio");
        TRANSLATE_MAP.put("true", "interface.boolean.true");
        TRANSLATE_MAP.put("false", "interface.boolean.false");
    }

    private Locale getLocale() {
        return LocaleContextHolder.getLocale();
    }

    public String translate(String name) {
        return this.messageSource.getMessage(TRANSLATE_MAP.get(name), null, this.getLocale());
    }

    public String getFakeIssueSubject() {
        return this.messageSource.getMessage("interface.table.bug-in-error", null, this.getLocale());
    }
}

