/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.bugtracker.azuredevops.internal.caching;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class AzureDevopsValuePool<T, K> {
    private final Map<InternalKey<K>, T> pool = new ConcurrentHashMap<InternalKey<K>, T>();
    private final Function<T, K> keyExtractor;
    private final Map<InternalKey<K>, Date> lastUsed = new ConcurrentHashMap<InternalKey<K>, Date>();

    public AzureDevopsValuePool(Function<T, K> keyExtractor) {
        this.keyExtractor = keyExtractor;
    }

    public int size() {
        return this.pool.size();
    }

    public List<T> replaceWithReferences(long bugTrackerId, List<T> items) {
        return items.stream().map(item -> {
            InternalKey<K> key = new InternalKey<K>(this.keyExtractor.apply(item), bugTrackerId);
            T cachedItem = this.pool.get(key);
            this.lastUsed.put(key, new Date());
            if (cachedItem != null) {
                return cachedItem;
            }
            this.pool.put(key, item);
            return item;
        }).toList();
    }

    public Set<T> replaceWithReferencesForSet(long bugTrackerId, Set<T> items) {
        return items.stream().map(item -> {
            InternalKey<K> key = new InternalKey<K>(this.keyExtractor.apply(item), bugTrackerId);
            T cachedItem = this.pool.get(key);
            this.lastUsed.put(key, new Date());
            if (cachedItem != null) {
                return cachedItem;
            }
            this.pool.put(key, item);
            return item;
        }).collect(Collectors.toSet());
    }

    public void evictUnusedItems(long maxAgeMilliseconds) {
        long now = new Date().getTime();
        this.pool.entrySet().removeIf(entry -> now - this.lastUsed.get(entry.getKey()).getTime() > maxAgeMilliseconds);
        this.lastUsed.entrySet().removeIf(entry -> now - ((Date)entry.getValue()).getTime() > maxAgeMilliseconds);
    }

    private record InternalKey<K>(K key, long bugTrackerId) {
    }
}

