/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.plugin.workflow.automjira.configuration;

import com.fasterxml.jackson.core.JsonProcessingException;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.api.automation.workflow.AutomationWorkflow;
import org.squashtest.tm.api.plugin.EntityReference;
import org.squashtest.tm.api.plugin.PluginType;
import org.squashtest.tm.api.plugin.PluginValidationException;
import org.squashtest.tm.api.wizard.InternationalizedWorkspaceWizard;
import org.squashtest.tm.api.wizard.SupervisionScreenData;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.plugin.workflow.automjira.exception.AutomJiraException;
import org.squashtest.tm.plugin.workflow.automjira.helpers.Util;
import org.squashtest.tm.plugin.workflow.automjira.service.JiraAutomationWorkflowPluginService;
import org.squashtest.tm.plugin.workflow.automjira.service.JiraAutomationWorkflowPluginServiceImpl;
import org.squashtest.tm.plugin.workflow.automjira.synchronisation.service.SynchronizationService;
import org.squashtest.tm.service.project.GenericProjectManagerService;
import org.squashtest.tm.web.i18n.InternationalizationHelper;

public class JiraAutomationWorkflowPlugin
extends InternationalizedWorkspaceWizard
implements AutomationWorkflow {
    public static final String URL_TEMPLATE = "plugin/waj/configuration/project/{projectId}";
    public static final String URL_TEST_CASE = "/test-case-workspace/test-case/{tcId}";
    public static final String PLUGIN_ID = "henix.plugin.automation.workflow.automjira";
    public static final String NAME_KEY = "henix.plugin.automation.workflow.automjira";
    public static final String TYPE_KEY = "henix.automjira.plugin.type";
    public static final String SERVER_FOR_PROJECT = "serverForProject";
    public static final String PROJECT_JIRA = "projectKey";
    public static final String REQUEST_TYPE = "requestType";
    public static final String FINAL_STATE = "finalState";
    public static final String LIST_CUFS = "listCufs";
    public static final String PLUGIN_NAME = "automJira";
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraAutomationWorkflowPluginServiceImpl.class);
    @Inject
    private JiraAutomationWorkflowPluginService jiraAutomationWorkflowPluginService;
    @Inject
    private SynchronizationService synchronizationService;
    @Inject
    private GenericProjectManagerService projectManager;
    @Inject
    private InternationalizationHelper i18nhelper;

    public String getId() {
        return "henix.plugin.automation.workflow.automjira";
    }

    public String getConfigurationPath(EntityReference context) {
        Long id = context.getId();
        return URL_TEMPLATE.replace("{projectId}", id.toString());
    }

    public String getWorkflowName() {
        return "Jira";
    }

    public String createNewTicketRemoteServer(Long testCaseId) {
        try {
            return this.jiraAutomationWorkflowPluginService.createNewTicketRemoteServer(testCaseId);
        }
        catch (IOException iOException) {
            throw new AutomJiraException("[AUTOM-JIRA-TICKET-CREATION] - Error creating jira ticket. ");
        }
    }

    public PluginType getPluginType() {
        return PluginType.AUTOMATION;
    }

    public void createRemoteAutomationRequestExtenderForTestCaseIfNotExist(String remoteIssueKey, Long testCaseId) {
        try {
            this.jiraAutomationWorkflowPluginService.createRemoteAutomationRequestExtenderForTestCaseIfNotExist(remoteIssueKey, testCaseId);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    public void validate(EntityReference reference) throws PluginValidationException {
        String msg = this.i18nhelper.internationalize("workflow.automation.jira.conf.not.exist", Util.getLocale());
        Map conf = this.projectManager.getPluginConfiguration(reference.getId().longValue(), WorkspaceType.TEST_CASE_WORKSPACE, "henix.plugin.automation.workflow.automjira");
        if (conf.size() == 0) {
            throw new PluginValidationException(msg);
        }
    }

    public Runnable performSynchronisation() {
        return () -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[AUTOM-JIRA-SYNC] - start of synchronization");
            }
            this.synchronizationService.performFullSynchronization();
        };
    }

    public SupervisionScreenData getSupervisionScreenData() {
        return SupervisionScreenData.withNoAdditionalColumn();
    }

    public String getSyncErrorLogPath(Long syncId) {
        return this.synchronizationService.getSyncErrorLogPath(syncId);
    }
}

